/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.text.serializer.v1_21_4.nbt;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.NumberTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.libs.mcstructs.text.Style;
import com.viaversion.viaversion.libs.mcstructs.text.events.hover.AHoverEvent;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.ITypedSerializer;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.v1_20_3.nbt.NbtStyleSerializer_v1_20_3;
import java.util.List;
import java.util.function.Function;

public class NbtStyleSerializer_v1_21_4
extends NbtStyleSerializer_v1_20_3 {
    public NbtStyleSerializer_v1_21_4(Function<NbtStyleSerializer_v1_20_3, ITypedSerializer<Tag, AHoverEvent>> hoverEventSerializer) {
        super(hoverEventSerializer);
    }

    @Override
    public Tag serialize(Style object) {
        CompoundTag out = (CompoundTag)super.serialize(object);
        if (object.getShadowColor() != null) {
            out.putInt("shadow_color", object.getShadowColor());
        }
        return out;
    }

    @Override
    public Style deserialize(Tag object) {
        Style style = super.deserialize(object);
        CompoundTag tag = (CompoundTag)object;
        if (tag.contains("shadow_color")) {
            style.setShadowColor(this.getShadowColor(tag.get("shadow_color")));
        }
        return style;
    }

    protected int getShadowColor(Tag tag) {
        if (tag instanceof NumberTag) {
            return ((NumberTag)tag).asInt();
        }
        List<Number> numbers = this.asNumberStream(tag);
        if (numbers.size() != 4) {
            throw new IllegalArgumentException("Expected list with 4 values for 'shadow_color' tag");
        }
        int r = (int)Math.floor(numbers.get(0).floatValue() * 255.0f);
        int g = (int)Math.floor(numbers.get(1).floatValue() * 255.0f);
        int b = (int)Math.floor(numbers.get(2).floatValue() * 255.0f);
        int a = (int)Math.floor(numbers.get(3).floatValue() * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

