/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.data.entity.DimensionData;
import com.viaversion.viaversion.api.minecraft.RegistryEntry;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.data.entity.DimensionDataImpl;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectArrayMap;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RegistryDataRewriter {
    private final Map<String, Consumer<CompoundTag>> enchantmentEffectRewriters = new Object2ObjectArrayMap<String, Consumer<CompoundTag>>();
    private final Map<String, List<RegistryEntry>> toAdd = new Object2ObjectArrayMap<String, List<RegistryEntry>>();
    private final Protocol<?, ?, ?, ?> protocol;

    public RegistryDataRewriter(Protocol<?, ?, ?, ?> protocol) {
        this.protocol = protocol;
    }

    public void handle(PacketWrapper wrapper) {
        String registryKey = wrapper.passthrough(Types.STRING);
        RegistryEntry[] entries = wrapper.read(Types.REGISTRY_ENTRY_ARRAY);
        entries = this.handle(wrapper.user(), registryKey, entries);
        wrapper.write(Types.REGISTRY_ENTRY_ARRAY, entries);
    }

    public RegistryEntry[] handle(UserConnection connection, String key, RegistryEntry[] entries) {
        if ((key = Key.stripMinecraftNamespace(key)).equals("enchantment")) {
            this.updateEnchantments(entries);
        } else if (key.equals("trim_material")) {
            this.updateTrimMaterials(entries);
        }
        List<RegistryEntry> toAdd = this.toAdd.get(key);
        if (toAdd != null) {
            int length = entries.length;
            int toAddLength = toAdd.size();
            entries = Arrays.copyOf(entries, length + toAddLength);
            for (int i = 0; i < toAddLength; ++i) {
                entries[length + i] = toAdd.get(i).copy();
            }
        }
        this.trackDimensionAndBiomes(connection, key, entries);
        return entries;
    }

    public void addEntries(String registryKey, RegistryEntry ... entries) {
        this.toAdd.computeIfAbsent(Key.stripMinecraftNamespace(registryKey), $ -> new ArrayList()).addAll(List.of(entries));
    }

    public void addEnchantmentEffectRewriter(String key, Consumer<CompoundTag> rewriter) {
        this.enchantmentEffectRewriters.put(Key.stripMinecraftNamespace(key), rewriter);
    }

    public void trackDimensionAndBiomes(UserConnection connection, String registryKey, RegistryEntry[] entries) {
        if (registryKey.equals("worldgen/biome")) {
            this.protocol.getEntityRewriter().tracker(connection).setBiomesSent(entries.length);
        } else if (registryKey.equals("dimension_type")) {
            HashMap<String, DimensionData> dimensionDataMap = new HashMap<String, DimensionData>(entries.length);
            for (int i = 0; i < entries.length; ++i) {
                RegistryEntry entry = entries[i];
                String key = Key.stripMinecraftNamespace(entry.key());
                DimensionData dimensionData = entry.tag() != null ? new DimensionDataImpl(i, (CompoundTag)entry.tag()) : DimensionDataImpl.withDefaultsFor(key, i);
                dimensionDataMap.put(key, dimensionData);
            }
            this.protocol.getEntityRewriter().tracker(connection).setDimensions(dimensionDataMap);
        }
    }

    public void updateEnchantments(RegistryEntry[] entries) {
        for (RegistryEntry entry : entries) {
            CompoundTag effects;
            if (entry.tag() == null) continue;
            CompoundTag tag = (CompoundTag)entry.tag();
            if (this.protocol.getMappingData().getFullItemMappings() != null) {
                this.updateItemList(tag.getListTag("supported_items", StringTag.class));
                this.updateItemList(tag.getListTag("primary_items", StringTag.class));
            }
            if ((effects = tag.getCompoundTag("effects")) == null) continue;
            for (Map.Entry<String, Tag> effectEntry : effects.entrySet()) {
                ListTag listTag;
                Object object = effectEntry.getValue();
                if (object instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)object;
                    this.updateNestedEffect(compoundTag);
                    continue;
                }
                object = effectEntry.getValue();
                if (!(object instanceof ListTag) || (listTag = (ListTag)object).getElementType() != CompoundTag.class) continue;
                for (Tag effectTag : listTag) {
                    this.updateNestedEffect((CompoundTag)effectTag);
                }
            }
            this.updateAttributesFields(effects);
        }
    }

    public void updateTrimMaterials(RegistryEntry[] entries) {
        if (this.protocol.getMappingData().getFullItemMappings() == null) {
            return;
        }
        for (RegistryEntry entry : entries) {
            if (entry.tag() == null) continue;
            StringTag ingredientTag = ((CompoundTag)entry.tag()).getStringTag("ingredient");
            String mappedIngredient = this.protocol.getMappingData().getFullItemMappings().mappedIdentifier(ingredientTag.getValue());
            ingredientTag.setValue(mappedIngredient);
        }
    }

    private void updateNestedEffect(CompoundTag effectsTag) {
        CompoundTag effect = effectsTag.getCompoundTag("effect");
        if (effect == null) {
            return;
        }
        this.runEffectRewriters(effect);
        ListTag<CompoundTag> innerEffects = effect.getListTag("effects", CompoundTag.class);
        if (innerEffects == null) {
            return;
        }
        for (CompoundTag innerEffect : innerEffects) {
            this.runEffectRewriters(innerEffect);
        }
    }

    private void updateAttributesFields(CompoundTag effects) {
        if (!this.hasAttributeMappings()) {
            return;
        }
        ListTag<CompoundTag> attributesList = TagUtil.getNamespacedCompoundTagList(effects, "attributes");
        if (attributesList == null) {
            return;
        }
        for (CompoundTag attributeData : attributesList) {
            this.updateAttributeField(attributeData);
        }
    }

    private void runEffectRewriters(CompoundTag effectTag) {
        String effect = effectTag.getString("type");
        if (effect == null) {
            return;
        }
        effect = Key.stripMinecraftNamespace(effect);
        this.updateAttributeField(effectTag);
        Consumer<CompoundTag> rewriter = this.enchantmentEffectRewriters.get(effect);
        if (rewriter != null) {
            rewriter.accept(effectTag);
        }
    }

    private void updateAttributeField(CompoundTag attributeData) {
        String attribute;
        StringTag attributeTag = attributeData.getStringTag("attribute");
        if (attributeTag == null) {
            return;
        }
        FullMappings mappings = this.protocol.getMappingData().getAttributeMappings();
        String mappedAttribute = mappings.mappedIdentifier(attribute = Key.stripMinecraftNamespace(attributeTag.getValue()));
        if (mappedAttribute == null) {
            mappedAttribute = mappings.mappedIdentifier(0);
        }
        attributeTag.setValue(mappedAttribute);
    }

    private boolean hasAttributeMappings() {
        return this.protocol.getMappingData() != null && this.protocol.getMappingData().getAttributeMappings() != null;
    }

    private void updateItemList(ListTag<StringTag> listTag) {
        if (listTag == null) {
            return;
        }
        for (StringTag tag : listTag) {
            this.updateItem(tag);
        }
    }

    private void updateItem(StringTag tag) {
        String mapped = this.protocol.getMappingData().getFullItemMappings().mappedIdentifier(tag.getValue());
        if (mapped != null) {
            tag.setValue(mapped);
        }
    }
}

