/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.DirectoryWalkListener;
import org.apache.maven.shared.utils.io.SelectorUtils;

class DirectoryWalker {
    private File baseDir;
    private int baseDirOffset;
    private Stack<DirStackEntry> dirStack;
    private final List<String> excludes;
    private final List<String> includes = new ArrayList<String>();
    private final List<DirectoryWalkListener> listeners;

    DirectoryWalker() {
        this.excludes = new ArrayList<String>();
        this.listeners = new ArrayList<DirectoryWalkListener>();
    }

    public void addDirectoryWalkListener(DirectoryWalkListener listener) {
        this.listeners.add(listener);
    }

    void addExclude(String exclude) {
        this.excludes.add(this.fixPattern(exclude));
    }

    void addInclude(String include) {
        this.includes.add(this.fixPattern(include));
    }

    public void addSCMExcludes() {
        String[] scmexcludes;
        for (String scmexclude : scmexcludes = DirectoryScanner.DEFAULTEXCLUDES) {
            this.addExclude(scmexclude);
        }
    }

    private void fireStep(File file) {
        DirStackEntry dsEntry = this.dirStack.peek();
        int percentage = dsEntry.getPercentage();
        for (DirectoryWalkListener listener : this.listeners) {
            listener.directoryWalkStep(percentage, file);
        }
    }

    private void fireWalkFinished() {
        Iterator<DirectoryWalkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DirectoryWalkListener listener1;
            DirectoryWalkListener listener = listener1 = iterator.next();
            listener.directoryWalkFinished();
        }
    }

    private void fireWalkStarting() {
        Iterator<DirectoryWalkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DirectoryWalkListener listener1;
            DirectoryWalkListener listener = listener1 = iterator.next();
            listener.directoryWalkStarting(this.baseDir);
        }
    }

    private void fireDebugMessage(String message) {
        Iterator<DirectoryWalkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DirectoryWalkListener listener1;
            DirectoryWalkListener listener = listener1 = iterator.next();
            listener.debug(message);
        }
    }

    private String fixPattern(String pattern) {
        String cleanPattern = pattern;
        if (File.separatorChar != '/') {
            cleanPattern = cleanPattern.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            cleanPattern = cleanPattern.replace('\\', File.separatorChar);
        }
        return cleanPattern;
    }

    private boolean isExcluded(String name) {
        return this.isMatch(this.excludes, name);
    }

    private boolean isIncluded(String name) {
        return this.isMatch(this.includes, name);
    }

    private boolean isMatch(List<String> patterns, String name) {
        for (String pattern : patterns) {
            boolean caseSensitive;
            if (!SelectorUtils.matchPath(pattern, name, caseSensitive = true)) continue;
            return true;
        }
        return false;
    }

    private String relativeToBaseDir(File file) {
        return file.getAbsolutePath().substring(this.baseDirOffset + 1);
    }

    public void scan() {
        if (this.baseDir == null) {
            throw new IllegalStateException("Scan Failure.  BaseDir not specified.");
        }
        if (!this.baseDir.exists()) {
            throw new IllegalStateException("Scan Failure.  BaseDir does not exist.");
        }
        if (!this.baseDir.isDirectory()) {
            throw new IllegalStateException("Scan Failure.  BaseDir is not a directory.");
        }
        if (this.includes.isEmpty()) {
            this.addInclude("**");
        }
        this.fireWalkStarting();
        this.dirStack = new Stack();
        this.scanDir(this.baseDir);
        this.fireWalkFinished();
    }

    private void scanDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        DirStackEntry curStackEntry = new DirStackEntry(dir, files.length);
        if (this.dirStack.isEmpty()) {
            curStackEntry.percentageOffset = 0.0;
            curStackEntry.percentageSize = 100.0;
        } else {
            DirStackEntry previousStackEntry = this.dirStack.peek();
            curStackEntry.percentageOffset = previousStackEntry.getNextPercentageOffset();
            curStackEntry.percentageSize = previousStackEntry.getNextPercentageSize();
        }
        this.dirStack.push(curStackEntry);
        for (int idx = 0; idx < files.length; ++idx) {
            curStackEntry.index = idx;
            String name = this.relativeToBaseDir(files[idx]);
            if (this.isExcluded(name)) {
                this.fireDebugMessage(name + " is excluded.");
                continue;
            }
            if (files[idx].isDirectory()) {
                this.scanDir(files[idx]);
                continue;
            }
            if (!this.isIncluded(name)) continue;
            this.fireStep(files[idx]);
        }
        this.dirStack.pop();
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        this.baseDirOffset = baseDir.getAbsolutePath().length();
    }

    static class DirStackEntry {
        private final int count;
        private final File dir;
        private int index;
        private double percentageOffset;
        private double percentageSize;

        DirStackEntry(File d, int length) {
            this.dir = d;
            this.count = length;
        }

        public double getNextPercentageOffset() {
            return this.percentageOffset + (double)this.index * (this.percentageSize / (double)this.count);
        }

        public double getNextPercentageSize() {
            return this.percentageSize / (double)this.count;
        }

        public int getPercentage() {
            double percentageWithinDir = (double)this.index / (double)this.count;
            return (int)Math.floor(this.percentageOffset + percentageWithinDir * this.percentageSize);
        }

        public String toString() {
            return "DirStackEntry[dir=" + this.dir.getAbsolutePath() + ",count=" + this.count + ",index=" + this.index + ",percentageOffset=" + this.percentageOffset + ",percentageSize=" + this.percentageSize + ",percentage()=" + this.getPercentage() + ",getNextPercentageOffset()=" + this.getNextPercentageOffset() + ",getNextPercentageSize()=" + this.getNextPercentageSize() + "]";
        }
    }
}

