/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

class FactoryFinder {
    FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = Class.forName(string, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(string);
                }
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string, String string2) throws ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        ClassLoader classLoader = FactoryFinder.getContextClassLoader();
        String string3 = "META-INF/services/" + string;
        try {
            object3 = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
            if (object3 != null) {
                object2 = new BufferedReader(new InputStreamReader((InputStream)object3, "UTF-8"));
                object = ((BufferedReader)object2).readLine();
                ((BufferedReader)object2).close();
                if (object != null && !"".equals(object)) {
                    return FactoryFinder.newInstance((String)object, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object3 = System.getProperty("java.home");
            object2 = (String)object3 + File.separator + "lib" + File.separator + "jaxrs.properties";
            object = new File((String)object2);
            if (((File)object).exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream((File)object));
                String string4 = properties.getProperty(string);
                return FactoryFinder.newInstance(string4, classLoader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object3 = System.getProperty(string);
            if (object3 != null) {
                return FactoryFinder.newInstance((String)object3, classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            throw new ClassNotFoundException("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }
}

