/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.guacamole.net.auth.noauth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glyptodon.guacamole.protocol.GuacamoleConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NoAuthConfigContentHandler
extends DefaultHandler {
    private Map<String, GuacamoleConfiguration> configs = new HashMap<String, GuacamoleConfiguration>();
    private String current = null;
    private GuacamoleConfiguration currentConfig = null;

    public Map<String, GuacamoleConfiguration> getConfigs() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("config")) {
            this.configs.put(this.current, this.currentConfig);
            this.currentConfig = null;
            this.current = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("config")) {
            if (this.current != null) {
                throw new SAXException("Configurations cannot be nested.");
            }
            String name = attributes.getValue("name");
            if (name == null) {
                throw new SAXException("Each configuration must have a name.");
            }
            String protocol = attributes.getValue("protocol");
            if (protocol == null) {
                throw new SAXException("Each configuration must have a protocol.");
            }
            this.current = name;
            this.currentConfig = new GuacamoleConfiguration();
            this.currentConfig.setProtocol(protocol);
        } else if (localName.equals("param")) {
            if (this.currentConfig == null) {
                throw new SAXException("Parameter without corresponding configuration.");
            }
            this.currentConfig.setParameter(attributes.getValue("name"), attributes.getValue("value"));
        }
    }
}

