/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import com.google.inject.Inject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sonatype.guice.bean.reflect.BeanProperty;
import org.sonatype.guice.bean.reflect.BeanPropertyField;
import org.sonatype.guice.bean.reflect.BeanPropertySetter;

final class BeanPropertyIterator<T>
implements Iterator<BeanProperty<T>> {
    private final Iterator<Member> memberIterator;
    private BeanProperty<T> nextProperty;

    BeanPropertyIterator(Iterable<Member> members) {
        this.memberIterator = members.iterator();
    }

    @Override
    public boolean hasNext() {
        while (null == this.nextProperty) {
            if (!this.memberIterator.hasNext()) {
                return false;
            }
            Member member = this.memberIterator.next();
            int modifiers = member.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || member.isSynthetic()) continue;
            if (member instanceof Method) {
                Method method = (Method)member;
                if (BeanPropertyIterator.isSetter(method)) {
                    this.nextProperty = new BeanPropertySetter(method);
                }
            } else if (member instanceof Field) {
                this.nextProperty = new BeanPropertyField((Field)member);
            }
            if (null == this.nextProperty || !BeanPropertyIterator.atInject(member)) continue;
            this.nextProperty = null;
        }
        return true;
    }

    @Override
    public BeanProperty<T> next() {
        if (this.hasNext()) {
            BeanProperty<T> property = this.nextProperty;
            this.nextProperty = null;
            return property;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static boolean isSetter(Method method) {
        String name = method.getName();
        if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return method.getParameterTypes().length == 1;
        }
        return false;
    }

    private static boolean atInject(Member member) {
        AnnotatedElement e = (AnnotatedElement)((Object)member);
        return e.isAnnotationPresent(javax.inject.Inject.class) || e.isAnnotationPresent(Inject.class);
    }
}

