/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObject;
import org.apache.guacamole.auth.jdbc.connection.ConnectionModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionService;
import org.apache.guacamole.auth.jdbc.connection.ModeledGuacamoleConfiguration;
import org.apache.guacamole.auth.jdbc.tunnel.GuacamoleTunnelService;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.EnumField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.form.NumericField;
import org.apache.guacamole.form.TextField;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeledConnection
extends ModeledChildDirectoryObject<ConnectionModel>
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ModeledConnection.class);
    public static final String GUACD_HOSTNAME_NAME = "guacd-hostname";
    public static final String GUACD_PORT_NAME = "guacd-port";
    public static final String GUACD_ENCRYPTION_NAME = "guacd-encryption";
    public static final String GUACD_ENCRYPTION_VALUE_NONE = "none";
    public static final String GUACD_ENCRYPTION_VALUE_SSL = "ssl";
    public static final Form GUACD_PARAMETERS = new Form("guacd", Arrays.asList(new TextField("guacd-hostname"), new NumericField("guacd-port"), new EnumField("guacd-encryption", Arrays.asList("", "none", "ssl"))));
    public static final String MAX_CONNECTIONS_NAME = "max-connections";
    public static final String MAX_CONNECTIONS_PER_USER_NAME = "max-connections-per-user";
    public static final String CONNECTION_WEIGHT = "weight";
    public static final String FAILOVER_ONLY_NAME = "failover-only";
    public static final Form CONCURRENCY_LIMITS = new Form("concurrency", Arrays.asList(new NumericField("max-connections"), new NumericField("max-connections-per-user")));
    public static final Form LOAD_BALANCING = new Form("load-balancing", Arrays.asList(new NumericField("weight"), new BooleanField("failover-only", "true")));
    public static final Collection<Form> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(CONCURRENCY_LIMITS, LOAD_BALANCING, GUACD_PARAMETERS));
    public static final Set<String> ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("guacd-hostname", "guacd-port", "guacd-encryption", "max-connections", "max-connections-per-user", "weight", "failover-only")));
    @Inject
    private JDBCEnvironment environment;
    @Inject
    private ConnectionService connectionService;
    @Inject
    private GuacamoleTunnelService tunnelService;
    @Inject
    private Provider<ModeledGuacamoleConfiguration> configProvider;
    private GuacamoleConfiguration config = null;

    public String getName() {
        return ((ConnectionModel)this.getModel()).getName();
    }

    public void setName(String name) {
        ((ConnectionModel)this.getModel()).setName(name);
    }

    public GuacamoleConfiguration getConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        ModeledGuacamoleConfiguration restrictedConfig = this.configProvider.get();
        restrictedConfig.init(this.getCurrentUser(), (ConnectionModel)this.getModel());
        return restrictedConfig;
    }

    public void setConfiguration(GuacamoleConfiguration config) {
        this.config = config;
        ((ConnectionModel)this.getModel()).setProtocol(config.getProtocol());
    }

    public Set<String> getSharingProfileIdentifiers() throws GuacamoleException {
        return ((ConnectionModel)this.getModel()).getSharingProfileIdentifiers();
    }

    public Date getLastActive() {
        return ((ConnectionModel)this.getModel()).getLastActive();
    }

    public List<? extends ConnectionRecord> getHistory() throws GuacamoleException {
        return this.connectionService.retrieveHistory(this.getCurrentUser(), this);
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        return this.connectionService.connect(this.getCurrentUser(), this, info, tokens);
    }

    public int getActiveConnections() {
        return this.tunnelService.getActiveConnections(this).size();
    }

    @Override
    public Set<String> getSupportedAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        attributes.put(MAX_CONNECTIONS_NAME, NumericField.format((Integer)((ConnectionModel)this.getModel()).getMaxConnections()));
        attributes.put(MAX_CONNECTIONS_PER_USER_NAME, NumericField.format((Integer)((ConnectionModel)this.getModel()).getMaxConnectionsPerUser()));
        attributes.put(GUACD_HOSTNAME_NAME, ((ConnectionModel)this.getModel()).getProxyHostname());
        attributes.put(GUACD_PORT_NAME, NumericField.format((Integer)((ConnectionModel)this.getModel()).getProxyPort()));
        GuacamoleProxyConfiguration.EncryptionMethod encryptionMethod = ((ConnectionModel)this.getModel()).getProxyEncryptionMethod();
        if (encryptionMethod == null) {
            attributes.put(GUACD_ENCRYPTION_NAME, null);
        } else {
            switch (encryptionMethod) {
                case NONE: {
                    attributes.put(GUACD_ENCRYPTION_NAME, GUACD_ENCRYPTION_VALUE_NONE);
                    break;
                }
                case SSL: {
                    attributes.put(GUACD_ENCRYPTION_NAME, GUACD_ENCRYPTION_VALUE_SSL);
                    break;
                }
                default: {
                    attributes.put(GUACD_ENCRYPTION_NAME, null);
                }
            }
        }
        attributes.put(CONNECTION_WEIGHT, NumericField.format((Integer)((ConnectionModel)this.getModel()).getConnectionWeight()));
        attributes.put(FAILOVER_ONLY_NAME, ((ConnectionModel)this.getModel()).isFailoverOnly() ? "true" : null);
        return attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        try {
            ((ConnectionModel)this.getModel()).setMaxConnections(NumericField.parse((String)attributes.get(MAX_CONNECTIONS_NAME)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting maximum connections: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        try {
            ((ConnectionModel)this.getModel()).setMaxConnectionsPerUser(NumericField.parse((String)attributes.get(MAX_CONNECTIONS_PER_USER_NAME)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting maximum connections per user: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        ((ConnectionModel)this.getModel()).setProxyHostname(TextField.parse((String)attributes.get(GUACD_HOSTNAME_NAME)));
        try {
            ((ConnectionModel)this.getModel()).setProxyPort(NumericField.parse((String)attributes.get(GUACD_PORT_NAME)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting guacd port: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        String encryptionMethod = attributes.get(GUACD_ENCRYPTION_NAME);
        if (GUACD_ENCRYPTION_VALUE_NONE.equals(encryptionMethod)) {
            ((ConnectionModel)this.getModel()).setProxyEncryptionMethod(GuacamoleProxyConfiguration.EncryptionMethod.NONE);
        } else if (GUACD_ENCRYPTION_VALUE_SSL.equals(encryptionMethod)) {
            ((ConnectionModel)this.getModel()).setProxyEncryptionMethod(GuacamoleProxyConfiguration.EncryptionMethod.SSL);
        } else {
            ((ConnectionModel)this.getModel()).setProxyEncryptionMethod(null);
        }
        try {
            ((ConnectionModel)this.getModel()).setConnectionWeight(NumericField.parse((String)attributes.get(CONNECTION_WEIGHT)));
        }
        catch (NumberFormatException e) {
            logger.warn("Not setting the connection weight: {}", (Object)e.getMessage());
            logger.debug("Unable to parse numeric attribute.", (Throwable)e);
        }
        ((ConnectionModel)this.getModel()).setFailoverOnly("true".equals(attributes.get(FAILOVER_ONLY_NAME)));
    }

    public int getMaxConnections() throws GuacamoleException {
        Integer value = ((ConnectionModel)this.getModel()).getMaxConnections();
        if (value == null) {
            return this.environment.getDefaultMaxConnections();
        }
        return value;
    }

    public int getMaxConnectionsPerUser() throws GuacamoleException {
        Integer value = ((ConnectionModel)this.getModel()).getMaxConnectionsPerUser();
        if (value == null) {
            return this.environment.getDefaultMaxConnectionsPerUser();
        }
        return value;
    }

    public GuacamoleProxyConfiguration getGuacamoleProxyConfiguration() throws GuacamoleException {
        GuacamoleProxyConfiguration defaultConfig = this.environment.getDefaultGuacamoleProxyConfiguration();
        String hostname = ((ConnectionModel)this.getModel()).getProxyHostname();
        Integer port = ((ConnectionModel)this.getModel()).getProxyPort();
        GuacamoleProxyConfiguration.EncryptionMethod encryptionMethod = ((ConnectionModel)this.getModel()).getProxyEncryptionMethod();
        return new GuacamoleProxyConfiguration(hostname != null ? hostname : defaultConfig.getHostname(), port != null ? port.intValue() : defaultConfig.getPort(), encryptionMethod != null ? encryptionMethod : defaultConfig.getEncryptionMethod());
    }

    public int getConnectionWeight() {
        Integer connectionWeight = ((ConnectionModel)this.getModel()).getConnectionWeight();
        if (connectionWeight == null) {
            return 1;
        }
        return connectionWeight;
    }

    public boolean isFailoverOnly() {
        return ((ConnectionModel)this.getModel()).isFailoverOnly();
    }
}

