/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.permission.ModeledPermissionService;
import org.apache.guacamole.auth.jdbc.permission.SystemPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.SystemPermissionModel;
import org.apache.guacamole.auth.jdbc.permission.SystemPermissionSet;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.SystemPermission;

public class SystemPermissionService
extends ModeledPermissionService<SystemPermissionSet, SystemPermission, SystemPermissionModel> {
    @Inject
    private SystemPermissionMapper systemPermissionMapper;
    @Inject
    private Provider<SystemPermissionSet> systemPermissionSetProvider;

    protected SystemPermissionMapper getPermissionMapper() {
        return this.systemPermissionMapper;
    }

    @Override
    protected SystemPermission getPermissionInstance(SystemPermissionModel model) {
        return new SystemPermission((SystemPermission.Type)model.getType());
    }

    @Override
    protected SystemPermissionModel getModelInstance(ModeledPermissions<? extends EntityModel> targetEntity, SystemPermission permission) {
        SystemPermissionModel model = new SystemPermissionModel();
        model.setEntityID(((EntityModel)targetEntity.getModel()).getEntityID());
        model.setType(permission.getType());
        return model;
    }

    @Override
    public SystemPermissionSet getPermissionSet(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Set<String> effectiveGroups) throws GuacamoleException {
        SystemPermissionSet permissionSet = this.systemPermissionSetProvider.get();
        permissionSet.init(user, targetEntity, effectiveGroups);
        return permissionSet;
    }

    @Override
    public void createPermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<SystemPermission> permissions) throws GuacamoleException {
        if (user.getUser().isAdministrator()) {
            Collection models = this.getModelInstances(targetEntity, permissions);
            this.systemPermissionMapper.insert(models);
            return;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void deletePermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<SystemPermission> permissions) throws GuacamoleException {
        if (user.getUser().isAdministrator()) {
            if (user.getUser().getIdentifier().equals(targetEntity.getIdentifier())) {
                throw new GuacamoleUnsupportedException("Removing your own administrative permissions is not allowed.");
            }
            Collection models = this.getModelInstances(targetEntity, permissions);
            this.systemPermissionMapper.delete(models);
            return;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    public boolean hasPermission(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, SystemPermission.Type type, Set<String> effectiveGroups) throws GuacamoleException {
        if (this.canReadPermissions(user, targetEntity)) {
            return this.getPermissionMapper().selectOne((EntityModel)targetEntity.getModel(), type, effectiveGroups) != null;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

