/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.transactional.MyBatisXAException;

public class XASqlSessionManager
implements XAResource {
    private static final Log log = LogFactory.getLog(XASqlSessionManager.class);
    public static final int NO_TX = 0;
    public static final int STARTED = 1;
    public static final int ENDED = 2;
    public static final int PREPARED = 3;
    private SqlSessionManager sqlSessionManager;
    private int transactionTimeout;
    private String id;
    private Xid xid;
    private int state = 0;
    private static ConcurrentHashMap<GlobalKey, GlobalToken> globalTokens = new ConcurrentHashMap();

    public XASqlSessionManager(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
        this.id = sqlSessionManager.getConfiguration().getEnvironment().getId();
    }

    public String getId() {
        return this.id;
    }

    public int getState() {
        return this.state;
    }

    private String xlatedState() {
        switch (this.state) {
            case 0: {
                return "NO_TX";
            }
            case 1: {
                return "STARTED";
            }
            case 2: {
                return "ENDED";
            }
            case 3: {
                return "PREPARED";
            }
        }
        return "!invalid state (" + this.state + ")!";
    }

    private String decodeXAResourceFlag(int flag) {
        switch (flag) {
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x40000000: {
                return "TMONEPHASE";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
        }
        return "" + flag;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean setTransactionTimeout(int second) throws XAException {
        this.transactionTimeout = second;
        return true;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this == xares;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Xid xid, int flag) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": call start old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + this.decodeXAResourceFlag(flag));
        }
        if (flag != 0 && flag != 0x200000) {
            throw new MyBatisXAException(this.id + ": unsupported start flag " + this.decodeXAResourceFlag(flag), -3);
        }
        if (xid == null) {
            throw new MyBatisXAException(this.id + ": XID cannot be null", -5);
        }
        if (this.state == 0) {
            if (this.xid != null) {
                throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid, -6);
            }
            if (flag == 0x200000) {
                throw new MyBatisXAException(this.id + ": resource not yet started", -6);
            }
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to start, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + this.decodeXAResourceFlag(flag));
            }
            this.xid = xid;
        } else {
            if (this.state == 1) {
                throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid, -6);
            }
            if (this.state == 2) {
                if (flag == 0) {
                    throw new MyBatisXAException(this.id + ": resource already registered XID " + this.xid, -8);
                }
                if (!xid.equals(this.xid)) throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid + " - cannot start it on more than one XID at a time", -3);
                if (log.isDebugEnabled()) {
                    log.debug(this.id + ": OK to join, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + this.decodeXAResourceFlag(flag));
                }
            } else if (this.state == 3) {
                throw new MyBatisXAException(this.id + ": resource already prepared on XID " + this.xid, -6);
            }
        }
        this.state = 1;
        this.parentSuspend(xid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": call end old state=" + this.xlatedState() + ", XID=" + xid + " and flag " + this.decodeXAResourceFlag(flag));
        }
        if (flag != 0x4000000 && flag != 0x20000000) {
            throw new MyBatisXAException(this.id + ": unsupported end flag " + this.decodeXAResourceFlag(flag), -3);
        }
        if (xid == null) {
            throw new MyBatisXAException(this.id + ": XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new MyBatisXAException(this.id + ": resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            if (!this.xid.equals(xid)) throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid + " - cannot end it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to end, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + this.decodeXAResourceFlag(flag));
            }
        } else {
            if (this.state == 2) {
                throw new MyBatisXAException(this.id + ": resource already ended on XID " + xid, -6);
            }
            if (this.state == 3) {
                throw new MyBatisXAException(this.id + ": cannot end, resource already prepared on XID " + xid, -6);
            }
        }
        if (flag == 0x20000000 && log.isDebugEnabled()) {
            log.debug(this.id + ": after end TMFAIL reset state to ENDED and roolback");
        }
        this.state = 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": call prepare old state=" + this.xlatedState() + ", XID=" + xid);
        }
        if (xid == null) {
            throw new MyBatisXAException(this.id + ": XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new MyBatisXAException(this.id + ": resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new MyBatisXAException(this.id + ": resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!this.xid.equals(xid)) throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid + " - cannot prepare it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to prepare, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        } else if (this.state == 3) {
            throw new MyBatisXAException(this.id + ": resource already prepared on XID " + this.xid, -6);
        }
        this.state = 3;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": call commit old state=" + this.xlatedState() + ", XID=" + xid + " onePhase is " + onePhase);
        }
        if (xid == null) {
            throw new MyBatisXAException(this.id + ": XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new MyBatisXAException(this.id + ": resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new MyBatisXAException(this.id + ": resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!onePhase) throw new MyBatisXAException(this.id + ": resource never prepared on XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to commit with 1PC, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        } else if (this.state == 3) {
            if (onePhase) throw new MyBatisXAException(this.id + ": cannot commit in one phase as resource has been prepared on XID " + xid, -6);
            if (!this.xid.equals(xid)) throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid + " - cannot commit it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to commit, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        }
        try {
            this.parentResume(xid);
            return;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": after commit reset state to NO_TX");
            }
            this.state = 0;
            this.xid = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": call roolback old state=" + this.xlatedState() + ", XID=" + xid);
        }
        if (xid == null) {
            throw new MyBatisXAException(this.id + ": XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new MyBatisXAException(this.id + ": resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new MyBatisXAException(this.id + ": resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!this.xid.equals(xid)) throw new MyBatisXAException(this.id + ": resource already started on XID " + this.xid + " - cannot roll it back on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": OK to rollback, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        } else if (this.state == 3) {
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": rollback reset state from PREPARED to NO_TX");
            }
            this.state = 0;
            throw new MyBatisXAException(this.id + ": resource committed during prepare on XID " + this.xid, 7);
        }
        try {
            this.parentResume(xid);
            return;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": after rollback reset state to NO_TX");
            }
            this.state = 0;
            this.xid = null;
        }
    }

    private void parentSuspend(Xid xid) {
        byte[] trId;
        GlobalKey key;
        GlobalToken globalToken;
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": suspend parent session " + xid);
        }
        if ((globalToken = globalTokens.get(key = new GlobalKey(trId = xid.getGlobalTransactionId()))) == null) {
            if (log.isDebugEnabled()) {
                log.debug(this.id + ": add GlobalToken " + key);
            }
            globalToken = new GlobalToken();
            globalTokens.put(key, globalToken);
        } else if (log.isDebugEnabled()) {
            log.debug(this.id + ": present GlobalToken " + key);
        }
        globalToken.parentSuspend(this.id, this.sqlSessionManager);
    }

    private void parentResume(Xid xid) {
        byte[] trId;
        GlobalKey key;
        GlobalToken globalToken;
        if (log.isDebugEnabled()) {
            log.debug(this.id + ": resume parent session " + xid);
        }
        if ((globalToken = globalTokens.get(key = new GlobalKey(trId = xid.getGlobalTransactionId()))) != null) {
            globalToken.parentResume(this.id, this.sqlSessionManager);
            if (globalToken.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.id + ": remove GlobalToken " + key);
                }
                globalTokens.remove(key);
            } else if (log.isDebugEnabled()) {
                log.debug(this.id + ": not remove GlobalToken " + key);
            }
        } else if (log.isDebugEnabled()) {
            log.debug(this.id + ": not find GlobalToken " + key);
        }
    }

    static class Token {
        private final Log log = LogFactory.getLog(this.getClass());
        final SqlSessionManager sqlSessionManager;
        ThreadLocal<SqlSession> localSqlSession;
        SqlSession suspendedSqlSession;
        int count;

        public Token(SqlSessionManager sqlSessionManager) {
            this.sqlSessionManager = sqlSessionManager;
            this.count = 0;
            try {
                Field field = SqlSessionManager.class.getDeclaredField("localSqlSession");
                field.setAccessible(true);
                this.localSqlSession = (ThreadLocal)field.get(sqlSessionManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean isFirst() {
            return this.count == 0;
        }

        void parentSuspend(String id) {
            if (this.isFirst()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(id + " suspend parent session");
                }
                if (this.localSqlSession != null) {
                    this.suspendedSqlSession = this.localSqlSession.get();
                    this.localSqlSession.remove();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(id + " skip suspend parent session");
            }
            ++this.count;
        }

        void parentResume(String id) {
            if (this.count > 0) {
                --this.count;
            }
            if (this.isFirst()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(id + " resume parent session");
                }
                if (this.localSqlSession != null) {
                    if (this.suspendedSqlSession == null) {
                        this.localSqlSession.remove();
                    } else {
                        this.localSqlSession.set(this.suspendedSqlSession);
                        this.suspendedSqlSession = null;
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(id + " skip resume parent session");
            }
        }
    }

    static class GlobalToken {
        private final Log log = LogFactory.getLog(this.getClass());
        IdentityHashMap<SqlSessionManager, Token> tokens = new IdentityHashMap();

        void parentSuspend(String id, SqlSessionManager sqlSessionManager) {
            Token token = this.tokens.get(sqlSessionManager);
            if (token == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(id + ": add Token " + sqlSessionManager);
                }
                token = new Token(sqlSessionManager);
                this.tokens.put(sqlSessionManager, token);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(id + ": present Token " + sqlSessionManager);
            }
            token.parentSuspend(id);
        }

        void parentResume(String id, SqlSessionManager sqlSessionManager) {
            Token token = this.tokens.get(sqlSessionManager);
            if (token != null) {
                token.parentResume(id);
                if (token.isFirst()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(id + ": remove parent session " + sqlSessionManager);
                    }
                    this.tokens.remove(sqlSessionManager);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(id + ": not find parent session " + sqlSessionManager);
            }
        }

        boolean isEmpty() {
            return this.tokens.isEmpty();
        }
    }

    static class GlobalKey {
        final byte[] globalId;
        final int arrayHash;

        public GlobalKey(byte[] globalId) {
            this.globalId = globalId;
            this.arrayHash = Arrays.hashCode(globalId);
        }

        public int hashCode() {
            return this.arrayHash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GlobalKey other = (GlobalKey)obj;
            return Arrays.equals(this.globalId, other.globalId);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("[Xid:globalId=");
            for (int i = 0; i < this.globalId.length; ++i) {
                s.append(Integer.toHexString(this.globalId[i]));
            }
            s.append(",length=").append(this.globalId.length);
            return s.toString();
        }
    }
}

