/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class BatchAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private List<Processor> _setProcessors = null;
    private Iterator<Processor> _setProcessorIter = null;
    private List<String> _commandLineProcessors;
    private Iterator<String> _commandLineProcessorIter = null;
    private ServiceLoader<Processor> _serviceLoader = null;
    private Iterator<Processor> _serviceLoaderIter;
    private ClassLoader _procLoader;
    private static final boolean VERBOSE_PROCESSOR_DISCOVERY = true;
    private boolean _printProcessorDiscovery = false;

    @Override
    public void configure(Object object, String[] stringArray) {
        if (null != this._processingEnv) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        BatchProcessingEnvImpl batchProcessingEnvImpl = new BatchProcessingEnvImpl(this, (Main)object, stringArray);
        this._processingEnv = batchProcessingEnvImpl;
        JavaFileManager javaFileManager = batchProcessingEnvImpl.getFileManager();
        if (javaFileManager instanceof StandardJavaFileManager) {
            Iterable<? extends File> iterable = null;
            if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                iterable = ((StandardJavaFileManager)javaFileManager).getLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH);
            }
            this._procLoader = iterable != null ? javaFileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) : javaFileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        } else {
            this._procLoader = javaFileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        }
        this.parseCommandLine(stringArray);
        this._round = 0;
    }

    private void parseCommandLine(String[] stringArray) {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-XprintProcessorInfo".equals(string)) {
                this._printProcessorInfo = true;
                this._printProcessorDiscovery = true;
                continue;
            }
            if ("-XprintRounds".equals(string)) {
                this._printRounds = true;
                continue;
            }
            if (!"-processor".equals(string)) continue;
            arrayList = new ArrayList<String>();
            String string2 = stringArray[++i];
            for (String string3 : string2.split(",")) {
                arrayList.add(string3);
            }
            break;
        }
        this._commandLineProcessors = arrayList;
        if (null != this._commandLineProcessors) {
            this._commandLineProcessorIter = this._commandLineProcessors.iterator();
        }
    }

    @Override
    public ProcessorInfo discoverNextProcessor() {
        if (null != this._setProcessors) {
            if (this._setProcessorIter.hasNext()) {
                Processor processor = this._setProcessorIter.next();
                processor.init(this._processingEnv);
                ProcessorInfo processorInfo = new ProcessorInfo(processor);
                this._processors.add(processorInfo);
                if (this._printProcessorDiscovery && null != this._out) {
                    this._out.println("API specified processor: " + processorInfo);
                }
                return processorInfo;
            }
            return null;
        }
        if (null != this._commandLineProcessors) {
            if (this._commandLineProcessorIter.hasNext()) {
                String string = this._commandLineProcessorIter.next();
                try {
                    Class<?> clazz = this._procLoader.loadClass(string);
                    Object obj = clazz.newInstance();
                    Processor processor = (Processor)obj;
                    processor.init(this._processingEnv);
                    ProcessorInfo processorInfo = new ProcessorInfo(processor);
                    this._processors.add(processorInfo);
                    if (this._printProcessorDiscovery && null != this._out) {
                        this._out.println("Command line specified processor: " + processorInfo);
                    }
                    return processorInfo;
                }
                catch (Exception exception) {
                    throw new AbortCompilation(null, (Throwable)exception);
                }
            }
            return null;
        }
        if (null == this._serviceLoader) {
            this._serviceLoader = ServiceLoader.load(Processor.class, this._procLoader);
            this._serviceLoaderIter = this._serviceLoader.iterator();
        }
        try {
            if (this._serviceLoaderIter.hasNext()) {
                Processor processor = this._serviceLoaderIter.next();
                processor.init(this._processingEnv);
                ProcessorInfo processorInfo = new ProcessorInfo(processor);
                this._processors.add(processorInfo);
                if (this._printProcessorDiscovery && null != this._out) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Discovered processor service ");
                    stringBuilder.append(processorInfo);
                    stringBuilder.append("\n  supporting ");
                    stringBuilder.append(processorInfo.getSupportedAnnotationTypesAsString());
                    stringBuilder.append("\n  in ");
                    stringBuilder.append(this.getProcessorLocation(processor));
                    this._out.println(stringBuilder.toString());
                }
                return processorInfo;
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new AbortCompilation(null, (Throwable)serviceConfigurationError);
        }
        return null;
    }

    private String getProcessorLocation(Processor processor) {
        String string;
        boolean bl = false;
        Class<?> clazz = processor.getClass();
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz.isMemberClass()) {
            stringBuilder.insert(0, clazz.getSimpleName());
            stringBuilder.insert(0, '$');
            bl = true;
            clazz = clazz.getEnclosingClass();
        }
        String string2 = clazz.getName();
        string2 = string2.replace('.', '/');
        if (bl) {
            string2 = string2 + stringBuilder;
        }
        if ((string = this._procLoader.getResource(string2 = string2 + ".class").toString()).endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    @Override
    public void reportProcessorException(Processor processor, Exception exception) {
        throw new AbortCompilation(null, (Throwable)exception);
    }

    @Override
    public void setProcessors(Object[] objectArray) {
        if (!this._isFirstRound) {
            throw new IllegalStateException("setProcessors() cannot be called after processing has begun");
        }
        this._setProcessors = new ArrayList<Processor>(objectArray.length);
        for (Object object : objectArray) {
            Processor processor = (Processor)object;
            this._setProcessors.add(processor);
        }
        this._setProcessorIter = this._setProcessors.iterator();
        this._commandLineProcessors = null;
        this._commandLineProcessorIter = null;
    }

    @Override
    public void reset() {
        super.reset();
        if (this._procLoader instanceof URLClassLoader) {
            try {
                ((URLClassLoader)this._procLoader).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

