/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.bits |= 0x100;
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding typeBinding;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && !this.binding.isAbstract() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.isOrEnclosedByPrivateType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                for (TypeParameter typeParameter : this.typeParameters) {
                    if ((typeParameter.binding.modifiers & 0x8000000) != 0) continue;
                    this.scope.problemReporter().unusedTypeParameter(typeParameter);
                }
            }
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, null, this.scope, FlowInfo.DEAD_END);
            MethodDeclaration.analyseArguments(classScope.environment(), flowInfo, this.arguments, this.binding);
            if (this.binding.declaringClass instanceof MemberTypeBinding && !this.binding.declaringClass.isStatic()) {
                this.bits &= 0xFFFFFEFF;
            }
            if (this.statements != null) {
                int n = this.scope.compilerOptions().enableSyntacticNullAnalysisForFields ? 1 : 0;
                int n2 = (flowInfo.reachMode() & 3) == 0 ? 0 : 1;
                for (Statement statement : this.statements) {
                    if ((n2 = statement.complainIfUnreachable(flowInfo, this.scope, n2, true)) < 2) {
                        flowInfo = statement.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                    }
                    if (n == 0) continue;
                    exceptionHandlingFlowContext.expireNullCheckedFieldInfo();
                }
            } else {
                this.bits &= 0xFFFFFEFF;
            }
            if ((typeBinding = this.binding.returnType) == TypeBinding.VOID || this.isAbstract()) {
                if ((flowInfo.tagBits & 1) == 0) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
            if (!(this.binding.isStatic() || (this.bits & 0x100) == 0 || this.isDefaultMethod() || this.binding.isOverriding() || this.binding.isImplementing())) {
                if (this.binding.isPrivate() || this.binding.isFinal() || this.binding.declaringClass.isFinal()) {
                    this.scope.problemReporter().methodCanBeDeclaredStatic(this);
                } else {
                    this.scope.problemReporter().methodCanBePotentiallyDeclaredStatic(this);
                }
            }
            this.scope.checkUnclosedCloseables(flowInfo, null, null, null);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void getAllAnnotationContexts(int n, List list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this.returnType, n, list);
        for (Annotation annotation : this.annotations) {
            annotation.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        }
    }

    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition annotationPosition) {
        return TypeReference.containsNullAnnotation(this.annotations) || this.returnType != null && this.returnType.hasNullTypeAnnotation(annotationPosition);
    }

    @Override
    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        parser.parse(this, compilationUnitDeclaration);
    }

    @Override
    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        if (this.returnType == null) {
            return stringBuffer;
        }
        return this.returnType.printExpression(0, stringBuffer).append(' ');
    }

    @Override
    public void resolveStatements() {
        long l;
        int n;
        if (this.returnType != null && this.binding != null) {
            this.bits |= this.returnType.bits & 0x100000;
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        boolean bl = false;
        if (this.returnType != null && this.returnType.resolvedType instanceof TypeVariableBinding) {
            bl = true;
        }
        if (this.typeParameters != null) {
            n = this.typeParameters.length;
            for (int i = 0; i < n; ++i) {
                TypeParameter typeParameter = this.typeParameters[i];
                this.bits |= typeParameter.bits & 0x100000;
                if (!bl || !TypeBinding.equalsEquals(this.typeParameters[i].binding, this.returnType.resolvedType)) continue;
                bl = false;
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (this.binding != null && (l = compilerOptions.complianceLevel) >= 0x310000L) {
            boolean bl2;
            int n2 = this.binding.modifiers;
            boolean bl3 = (this.binding.tagBits & 0x2000000000000L) != 0L;
            boolean bl4 = bl2 = (this.binding.tagBits & 0x200L) != 0L;
            if (bl3 && !bl2) {
                if ((n2 & 0x10000008) != 0x10000000 && (l < 0x320000L || (n2 & 0x20000008) != 0x20000000)) {
                    this.scope.problemReporter().methodMustOverride(this, l);
                }
            } else if (!this.binding.declaringClass.isInterface()) {
                if ((n2 & 0x10000008) == 0x10000000) {
                    this.scope.problemReporter().missingOverrideAnnotation(this);
                } else if (l >= 0x320000L && compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && this.binding.isImplementing()) {
                    this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
                }
            } else if (l >= 0x320000L && compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && ((n2 & 0x10000008) == 0x10000000 || this.binding.isImplementing())) {
                this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
            }
        }
        switch (TypeDeclaration.kind(this.scope.referenceType().modifiers)) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) {
                    this.scope.problemReporter().methodNeedingNoBody(this);
                    break;
                }
                if (this.binding != null && !this.binding.isStatic() && !(this.binding.declaringClass instanceof LocalTypeBinding) && !bl) break;
                this.bits &= 0xFFFFFEFF;
                break;
            }
            case 2: {
                if (compilerOptions.sourceLevel < 0x340000L || (this.modifiers & 0x1000400) != 0x1000000) break;
                int n3 = n = compilerOptions.sourceLevel >= 0x350000L && (this.modifiers & 2) != 0 ? 1 : 0;
                if (n == 0 && (this.modifiers & 0x10008) == 0) break;
                this.scope.problemReporter().methodNeedBody(this);
            }
        }
        super.resolveStatements();
        if (compilerOptions.getSeverity(0x20100000) != 256 && this.binding != null && ((n = this.binding.modifiers) & 0x30000000) == 0x10000000 && (this.bits & 0x10) == 0) {
            this.scope.problemReporter().overridesMethodWithoutSuperInvocation(this.binding);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, this.scope);
            }
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                for (n = 0; n < n2; ++n) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

