/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ModuleDeclaration
extends ASTNode
implements ReferenceContext {
    public ExportsStatement[] exports;
    public RequiresStatement[] requires;
    public UsesStatement[] uses;
    public ProvidesStatement[] services;
    public OpensStatement[] opens;
    public Annotation[] annotations;
    public int exportsCount;
    public int requiresCount;
    public int usesCount;
    public int servicesCount;
    public int opensCount;
    public SourceModuleBinding binding;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public int modifiersSourceStart;
    public BlockScope scope;
    public char[][] tokens;
    public char[] moduleName;
    public long[] sourcePositions;
    public int modifiers = 0;
    boolean ignoreFurtherInvestigation;
    boolean hasResolvedModuleDirectives;
    boolean hasResolvedPackageDirectives;
    boolean hasResolvedTypeDirectives;
    CompilationResult compilationResult;

    public ModuleDeclaration(CompilationResult compilationResult, char[][] cArray, long[] lArray) {
        this.compilationResult = compilationResult;
        this.exportsCount = 0;
        this.requiresCount = 0;
        this.tokens = cArray;
        this.moduleName = CharOperation.concatWith(cArray, '.');
        this.sourcePositions = lArray;
        this.sourceEnd = (int)(lArray[lArray.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(lArray[0] >>> 32);
    }

    public ModuleBinding setBinding(SourceModuleBinding sourceModuleBinding) {
        this.binding = sourceModuleBinding;
        return sourceModuleBinding;
    }

    public void checkAndSetModifiers() {
        int n;
        int n2 = this.modifiers & 0xFFFF;
        int n3 = 4128;
        if ((n2 & ~n3) != 0) {
            this.scope.problemReporter().illegalModifierForModule(this);
            n2 &= n3;
        }
        this.modifiers = this.binding.modifiers = (n = 0x8000 | n2);
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public void createScope(final Scope scope) {
        this.scope = new MethodScope(scope, null, true){

            @Override
            public ProblemReporter problemReporter() {
                return scope.problemReporter();
            }

            @Override
            public ReferenceContext referenceContext() {
                return ModuleDeclaration.this;
            }

            @Override
            public boolean isModuleScope() {
                return true;
            }
        };
    }

    public void generateCode() {
        block4: {
            if ((this.bits & 0x2000) != 0) {
                return;
            }
            this.bits |= 0x2000;
            if (this.ignoreFurtherInvestigation) {
                return;
            }
            try {
                LookupEnvironment lookupEnvironment = this.scope.environment();
                ClassFile classFile = lookupEnvironment.classFilePool.acquireForModule(this.binding, lookupEnvironment.globalOptions);
                classFile.initializeForModule(this.binding);
                classFile.addModuleAttributes(this.binding, this.annotations, this.scope.referenceCompilationUnit());
                this.scope.referenceCompilationUnit().compilationResult.record(this.binding.moduleName, classFile);
            }
            catch (AbortType abortType) {
                if (this.binding != null) break block4;
                return;
            }
        }
    }

    public void resolveModuleDirectives(CompilationUnitScope compilationUnitScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedModuleDirectives) {
            return;
        }
        this.hasResolvedModuleDirectives = true;
        HashSet<ModuleBinding> hashSet = new HashSet<ModuleBinding>();
        HashSet<ModuleBinding> hashSet2 = new HashSet<ModuleBinding>();
        for (int i = 0; i < this.requiresCount; ++i) {
            Collection<ModuleBinding> collection;
            RequiresStatement requiresStatement = this.requires[i];
            if (requiresStatement == null || requiresStatement.resolve(compilationUnitScope) == null) continue;
            if (!hashSet.add(requiresStatement.resolvedBinding)) {
                compilationUnitScope.problemReporter().duplicateModuleReference(8389909, requiresStatement.module);
            }
            if (requiresStatement.isTransitive()) {
                hashSet2.add(requiresStatement.resolvedBinding);
            }
            if (!(collection = requiresStatement.resolvedBinding.dependencyGraphCollector().get()).contains(this.binding)) continue;
            compilationUnitScope.problemReporter().cyclicModuleDependency(this.binding, requiresStatement.module);
            hashSet.remove(requiresStatement.module.binding);
        }
        this.binding.setRequires(hashSet.toArray(new ModuleBinding[hashSet.size()]), hashSet2.toArray(new ModuleBinding[hashSet2.size()]));
    }

    public void resolvePackageDirectives(CompilationUnitScope compilationUnitScope) {
        Object object;
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedPackageDirectives) {
            return;
        }
        this.hasResolvedPackageDirectives = true;
        HashSet<PackageBinding> hashSet = new HashSet<PackageBinding>();
        for (int i = 0; i < this.exportsCount; ++i) {
            ExportsStatement exportsStatement = this.exports[i];
            if (exportsStatement == null || !exportsStatement.resolve(compilationUnitScope)) continue;
            if (!hashSet.add(exportsStatement.resolvedPackage)) {
                compilationUnitScope.problemReporter().invalidPackageReference(8389910, exportsStatement);
            }
            object = null;
            if (exportsStatement.targets != null) {
                object = new char[exportsStatement.targets.length][];
                for (int j = 0; j < ((Object)object).length; ++j) {
                    object[j] = exportsStatement.targets[j].moduleName;
                }
            }
            this.binding.addResolvedExport(exportsStatement.resolvedPackage, (char[][])object);
        }
        HashtableOfObject hashtableOfObject = new HashtableOfObject();
        for (int i = 0; i < this.opensCount; ++i) {
            object = this.opens[i];
            if (this.isOpen()) {
                compilationUnitScope.problemReporter().invalidOpensStatement((OpensStatement)object, this);
                continue;
            }
            if (hashtableOfObject.containsKey(((OpensStatement)object).pkgName)) {
                compilationUnitScope.problemReporter().invalidPackageReference(8389921, (PackageVisibilityStatement)object);
            } else {
                hashtableOfObject.put(((OpensStatement)object).pkgName, object);
                ((PackageVisibilityStatement)object).resolve(compilationUnitScope);
            }
            char[][] cArrayArray = null;
            if (((OpensStatement)object).targets != null) {
                cArrayArray = new char[((OpensStatement)object).targets.length][];
                for (int j = 0; j < cArrayArray.length; ++j) {
                    cArrayArray[j] = ((OpensStatement)object).targets[j].moduleName;
                }
            }
            this.binding.addResolvedOpens(((OpensStatement)object).resolvedPackage, cArrayArray);
        }
    }

    public void resolveTypeDirectives(CompilationUnitScope compilationUnitScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedTypeDirectives) {
            return;
        }
        this.hasResolvedTypeDirectives = true;
        ASTNode.resolveAnnotations(this.scope, this.annotations, this.binding);
        HashSet<TypeBinding> hashSet = new HashSet<TypeBinding>();
        for (int i = 0; i < this.usesCount; ++i) {
            TypeBinding typeBinding = this.uses[i].serviceInterface.resolveType(this.scope);
            if (typeBinding == null || !typeBinding.isValidBinding()) continue;
            if (!(typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotationType())) {
                compilationUnitScope.problemReporter().invalidServiceRef(8389924, this.uses[i].serviceInterface);
            }
            if (hashSet.add(this.uses[i].serviceInterface.resolvedType)) continue;
            compilationUnitScope.problemReporter().duplicateTypeReference(8389911, this.uses[i].serviceInterface);
        }
        this.binding.setUses(hashSet.toArray(new TypeBinding[hashSet.size()]));
        HashSet<TypeBinding> hashSet2 = new HashSet<TypeBinding>();
        for (int i = 0; i < this.servicesCount; ++i) {
            this.services[i].resolve(this.scope);
            TypeBinding typeBinding = this.services[i].serviceInterface.resolvedType;
            if (typeBinding == null || !typeBinding.isValidBinding()) continue;
            if (!hashSet2.add(this.services[i].serviceInterface.resolvedType)) {
                compilationUnitScope.problemReporter().duplicateTypeReference(8389912, this.services[i].serviceInterface);
            }
            this.binding.setImplementations(typeBinding, this.services[i].getResolvedImplementations());
        }
        this.binding.setServices(hashSet2.toArray(new TypeBinding[hashSet2.size()]));
    }

    public void analyseCode(CompilationUnitScope compilationUnitScope) {
        this.analyseModuleGraph(compilationUnitScope);
        this.analyseReferencedPackages(compilationUnitScope);
    }

    private void analyseReferencedPackages(CompilationUnitScope compilationUnitScope) {
        if (this.exports != null) {
            for (ExportsStatement exportsStatement : this.exports) {
                PackageBinding packageBinding = exportsStatement.resolvedPackage;
                if (packageBinding == null) continue;
                if (packageBinding instanceof SplitPackageBinding) {
                    packageBinding = ((SplitPackageBinding)packageBinding).getIncarnation(this.binding);
                }
                if (packageBinding.hasCompilationUnit(true)) continue;
                compilationUnitScope.problemReporter().invalidPackageReference(8389919, exportsStatement);
            }
        }
    }

    public void analyseModuleGraph(CompilationUnitScope compilationUnitScope) {
        if (this.requires != null) {
            HashMap<String, Set<ModuleBinding>> hashMap = new HashMap<String, Set<ModuleBinding>>();
            for (ModuleBinding object : this.binding.getAllRequiredModules()) {
                for (PackageBinding packageBinding : object.getExports()) {
                    if (!this.binding.canAccess(packageBinding)) continue;
                    String string = String.valueOf(packageBinding.readableName());
                    HashSet<ModuleBinding> hashSet = (HashSet<ModuleBinding>)hashMap.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet<ModuleBinding>();
                        hashMap.put(string, hashSet);
                    }
                    hashSet.add(object);
                }
            }
            for (RequiresStatement requiresStatement : this.requires) {
                ModuleBinding moduleBinding = requiresStatement.resolvedBinding;
                if (moduleBinding == null) continue;
                if (moduleBinding.isDeprecated()) {
                    compilationUnitScope.problemReporter().deprecatedModule(requiresStatement.module, moduleBinding);
                }
                this.analyseOneDependency(requiresStatement, moduleBinding, compilationUnitScope, hashMap);
                if (!requiresStatement.isTransitive()) continue;
                for (ModuleBinding moduleBinding2 : moduleBinding.getAllRequiredModules()) {
                    this.analyseOneDependency(requiresStatement, moduleBinding2, compilationUnitScope, hashMap);
                }
            }
        }
    }

    private void analyseOneDependency(RequiresStatement requiresStatement, ModuleBinding moduleBinding, CompilationUnitScope compilationUnitScope, Map<String, Set<ModuleBinding>> map) {
        for (PackageBinding packageBinding : moduleBinding.getExports()) {
            Set<ModuleBinding> set = map.get(String.valueOf(packageBinding.readableName()));
            if (set == null || set.size() <= 1) continue;
            compilationUnitScope.problemReporter().conflictingPackagesFromModules(packageBinding, set, requiresStatement.sourceStart, requiresStatement.sourceEnd);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        aSTVisitor.visit(this, compilationUnitScope);
    }

    public StringBuffer printHeader(int n, StringBuffer stringBuffer) {
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.length; ++i) {
                this.annotations[i].print(n, stringBuffer);
                if (i == this.annotations.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append('\n');
        }
        if (this.isOpen()) {
            stringBuffer.append("open ");
        }
        stringBuffer.append("module ");
        stringBuffer.append(CharOperation.charToString(this.moduleName));
        return stringBuffer;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(" {");
        if (this.requires != null) {
            for (n2 = 0; n2 < this.requiresCount; ++n2) {
                stringBuffer.append('\n');
                ModuleDeclaration.printIndent(n + 1, stringBuffer);
                this.requires[n2].print(0, stringBuffer);
            }
        }
        if (this.exports != null) {
            for (n2 = 0; n2 < this.exportsCount; ++n2) {
                stringBuffer.append('\n');
                this.exports[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.opens != null) {
            for (n2 = 0; n2 < this.opensCount; ++n2) {
                stringBuffer.append('\n');
                this.opens[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.uses != null) {
            for (n2 = 0; n2 < this.usesCount; ++n2) {
                stringBuffer.append('\n');
                this.uses[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.servicesCount != 0) {
            for (n2 = 0; n2 < this.servicesCount; ++n2) {
                stringBuffer.append('\n');
                this.services[n2].print(n + 1, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        return ModuleDeclaration.printIndent(n, stringBuffer).append('}');
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        ModuleDeclaration.printIndent(n, stringBuffer);
        this.printHeader(0, stringBuffer);
        return this.printBody(n, stringBuffer);
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortType(this.compilationResult, categorizedProblem);
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.scope.referenceCompilationUnit();
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
    }
}

