/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathMultiReleaseJar
extends ClasspathJar {
    private FileSystem fs = null;
    Path releasePath = null;
    String compliance = null;

    public ClasspathMultiReleaseJar(File file, boolean bl, AccessRuleSet accessRuleSet, String string, String string2) {
        super(file, bl, accessRuleSet, string);
        this.compliance = string2;
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        URI uRI = this.file.toURI();
        if (this.file.exists()) {
            URI uRI2 = URI.create("jar:file:" + uRI.getRawPath());
            try {
                this.fs = FileSystems.getFileSystem(uRI2);
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                // empty catch block
            }
            if (this.fs == null) {
                HashMap hashMap = new HashMap();
                try {
                    this.fs = FileSystems.newFileSystem(uRI2, hashMap);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.releasePath = this.fs.getPath("/", "META-INF", "versions", this.compliance);
            if (!Files.exists(this.releasePath, new LinkOption[0])) {
                this.releasePath = null;
            }
        }
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String string, String string2) {
        block12: {
            Object object;
            if (this.releasePath == null) {
                return super.getModulesDeclaringPackage(string, string2);
            }
            if (this.packageCache != null) {
                return this.singletonModuleNameIf(this.packageCache.contains(string));
            }
            this.packageCache = new HashSet(41);
            this.packageCache.add(Util.EMPTY_STRING);
            Object object2 = this.zipFile.entries();
            while (object2.hasMoreElements()) {
                object = object2.nextElement().getName();
                this.addToPackageCache((String)object, false);
            }
            try {
                if (this.releasePath == null || !Files.exists(this.releasePath, new LinkOption[0])) break block12;
                object2 = Files.newDirectoryStream(this.releasePath);
                try {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Path path = (Path)object.next();
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                Path path2 = ClasspathMultiReleaseJar.this.releasePath.relativize(path);
                                ClasspathMultiReleaseJar.this.addToPackageCache(path2.toString(), false);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.singletonModuleNameIf(this.packageCache.contains(string));
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        block14: {
            if (!this.isPackage(string, string2)) {
                return null;
            }
            if (this.releasePath != null) {
                try {
                    Object object;
                    char[] cArray2;
                    IBinaryType iBinaryType;
                    block15: {
                        Path path = this.releasePath.resolve(string3);
                        byte[] byArray = Files.readAllBytes(path);
                        iBinaryType = null;
                        if (byArray != null) {
                            iBinaryType = new ClassFileReader(byArray, string3.toCharArray());
                        }
                        if (iBinaryType == null) break block14;
                        char[] cArray3 = cArray2 = this.module == null ? null : this.module.name();
                        if (iBinaryType instanceof ClassFileReader) {
                            object = iBinaryType;
                            if (((ClassFileReader)object).moduleName == null) {
                                ((ClassFileReader)object).moduleName = cArray2;
                            } else {
                                cArray2 = ((ClassFileReader)object).moduleName;
                            }
                        }
                        object = string3.substring(0, string3.length() - SuffixConstants.SUFFIX_CLASS.length);
                        if (this.annotationPaths != null) {
                            String string4 = string3.substring(0, string3.length() - "CLASS".length() - 1);
                            for (String string5 : this.annotationPaths) {
                                try {
                                    if (this.annotationZipFile == null) {
                                        this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(string5, null);
                                    }
                                    if ((iBinaryType = ExternalAnnotationDecorator.create(iBinaryType, string5, string4, this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                                    break block15;
                                }
                                catch (IOException iOException) {
                                }
                            }
                            iBinaryType = new ExternalAnnotationDecorator(iBinaryType, null);
                        }
                    }
                    if (this.accessRuleSet == null) {
                        return new NameEnvironmentAnswer(iBinaryType, null, cArray2);
                    }
                    return new NameEnvironmentAnswer(iBinaryType, this.accessRuleSet.getViolatedRestriction(((String)object).toCharArray()), cArray2);
                }
                catch (IOException | ClassFormatException exception) {
                    // empty catch block
                }
            }
        }
        return super.findClass(cArray, string, string2, string3, bl);
    }
}

