/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public abstract class ReferenceBinding
extends TypeBinding {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private SimpleLookupTable compatibleCache;
    int typeBits;
    protected MethodBinding[] singleAbstractMethod;
    public static final ReferenceBinding LUB_GENERIC = new ReferenceBinding(){
        {
            this.id = 0;
        }

        @Override
        public boolean hasTypeBit(int n) {
            return false;
        }
    };
    private static final Comparator<FieldBinding> FIELD_COMPARATOR = new Comparator<FieldBinding>(){

        @Override
        public int compare(FieldBinding fieldBinding, FieldBinding fieldBinding2) {
            char[] cArray = fieldBinding.name;
            char[] cArray2 = fieldBinding2.name;
            return ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
        }
    };
    private static final Comparator<MethodBinding> METHOD_COMPARATOR = new Comparator<MethodBinding>(){

        @Override
        public int compare(MethodBinding methodBinding, MethodBinding methodBinding2) {
            MethodBinding methodBinding3 = methodBinding;
            MethodBinding methodBinding4 = methodBinding2;
            char[] cArray = methodBinding3.selector;
            char[] cArray2 = methodBinding4.selector;
            int n = ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
            return n == 0 ? methodBinding3.parameters.length - methodBinding4.parameters.length : n;
        }
    };
    protected static ProblemMethodBinding samProblemBinding = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 17);

    public ReferenceBinding(ReferenceBinding referenceBinding) {
        super(referenceBinding);
        this.compoundName = referenceBinding.compoundName;
        this.sourceName = referenceBinding.sourceName;
        this.modifiers = referenceBinding.modifiers;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.constantPoolName = referenceBinding.constantPoolName;
        this.signature = referenceBinding.signature;
        this.compatibleCache = referenceBinding.compatibleCache;
        this.typeBits = referenceBinding.typeBits;
        this.singleAbstractMethod = referenceBinding.singleAbstractMethod;
    }

    public ReferenceBinding() {
    }

    public static FieldBinding binarySearch(char[] cArray, FieldBinding[] fieldBindingArray) {
        if (fieldBindingArray == null) {
            return null;
        }
        int n = fieldBindingArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = fieldBindingArray[n5].name;
            int n6 = ReferenceBinding.compare(cArray, fieldBindingArray[n5].name, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            return fieldBindingArray[n5];
        }
        return null;
    }

    public static long binarySearch(char[] cArray, MethodBinding[] methodBindingArray) {
        if (methodBindingArray == null) {
            return -1L;
        }
        int n = methodBindingArray.length;
        if (n == 0) {
            return -1L;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            int n6;
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = methodBindingArray[n5].selector;
            int n7 = ReferenceBinding.compare(cArray, methodBindingArray[n5].selector, n4, cArray2.length);
            if (n7 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n7 > 0) {
                n2 = n5 + 1;
                continue;
            }
            int n8 = n5;
            for (n6 = n5; n6 > n2 && CharOperation.equals(methodBindingArray[n6 - 1].selector, cArray); --n6) {
            }
            while (n8 < n3 && CharOperation.equals(methodBindingArray[n8 + 1].selector, cArray)) {
                ++n8;
            }
            return (long)n6 + ((long)n8 << 32);
        }
        return -1L;
    }

    static int compare(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static void sortFields(FieldBinding[] fieldBindingArray, int n, int n2) {
        Arrays.sort(fieldBindingArray, n, n2, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] methodBindingArray, int n, int n2) {
        Arrays.sort(methodBindingArray, n, n2, METHOD_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    @Override
    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.fPackage;
    }

    public boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        block19: {
            ReferenceBinding referenceBinding3;
            block20: {
                block21: {
                    if (this.isPublic()) {
                        return true;
                    }
                    if (this.isStatic() && (referenceBinding.isRawType() || referenceBinding.isParameterizedType())) {
                        referenceBinding = referenceBinding.actualType();
                    }
                    if (TypeBinding.equalsEquals(referenceBinding2, this) && TypeBinding.equalsEquals(referenceBinding2, referenceBinding)) {
                        return true;
                    }
                    if (this.isProtected()) {
                        if (TypeBinding.equalsEquals(referenceBinding2, this)) {
                            return true;
                        }
                        if (referenceBinding2.fPackage == this.fPackage) {
                            return true;
                        }
                        TypeBinding typeBinding = referenceBinding2.erasure();
                        TypeBinding typeBinding2 = this.enclosingType().erasure();
                        if (TypeBinding.equalsEquals(typeBinding2, referenceBinding2)) {
                            return true;
                        }
                        if (typeBinding2 == null) {
                            return false;
                        }
                        do {
                            if (typeBinding.findSuperTypeOriginatingFrom(typeBinding2) == null) continue;
                            return true;
                        } while ((typeBinding = typeBinding.enclosingType()) != null);
                        return false;
                    }
                    if (!this.isPrivate()) break block19;
                    if (TypeBinding.equalsEquals(referenceBinding, this) || TypeBinding.equalsEquals(referenceBinding, this.enclosingType())) break block20;
                    if (!referenceBinding.isTypeVariable()) break block21;
                    referenceBinding3 = (TypeVariableBinding)referenceBinding;
                    if (((TypeVariableBinding)referenceBinding3).environment.globalOptions.complianceLevel <= 0x320000L && (((TypeVariableBinding)referenceBinding3).isErasureBoundTo(this.erasure()) || ((TypeVariableBinding)referenceBinding3).isErasureBoundTo(this.enclosingType().erasure()))) break block20;
                }
                return false;
            }
            if (TypeBinding.notEquals(referenceBinding2, this)) {
                ReferenceBinding referenceBinding4;
                referenceBinding3 = referenceBinding2;
                for (referenceBinding4 = referenceBinding3.enclosingType(); referenceBinding4 != null; referenceBinding4 = referenceBinding4.enclosingType()) {
                    referenceBinding3 = referenceBinding4;
                }
                ReferenceBinding referenceBinding5 = (ReferenceBinding)this.erasure();
                for (referenceBinding4 = referenceBinding5.enclosingType(); referenceBinding4 != null; referenceBinding4 = referenceBinding4.enclosingType()) {
                    referenceBinding5 = referenceBinding4;
                }
                if (TypeBinding.notEquals(referenceBinding3, referenceBinding5)) {
                    return false;
                }
            }
            return true;
        }
        if (referenceBinding2.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding referenceBinding6 = referenceBinding;
        TypeBinding typeBinding = (this.enclosingType() == null ? this : this.enclosingType()).original();
        do {
            if (referenceBinding6.isCapture() ? TypeBinding.equalsEquals(typeBinding, referenceBinding6.erasure().original()) : TypeBinding.equalsEquals(typeBinding, referenceBinding6.original())) {
                return true;
            }
            PackageBinding packageBinding = referenceBinding6.fPackage;
            if (packageBinding == null || packageBinding == this.fPackage) continue;
            return false;
        } while ((referenceBinding6 = referenceBinding6.superclass()) != null);
        return false;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(sourceTypeBinding, this)) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding typeBinding = this.enclosingType();
            if (typeBinding == null) {
                return false;
            }
            typeBinding = typeBinding.erasure();
            TypeBinding typeBinding2 = sourceTypeBinding.erasure();
            do {
                if (TypeBinding.equalsEquals(typeBinding, sourceTypeBinding)) {
                    return true;
                }
                if (typeBinding2.findSuperTypeOriginatingFrom(typeBinding) == null) continue;
                return true;
            } while ((typeBinding2 = typeBinding2.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = sourceTypeBinding;
            for (referenceBinding = referenceBinding2.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding2 = referenceBinding;
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.erasure();
            for (referenceBinding = referenceBinding3.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding3 = referenceBinding;
            }
            return TypeBinding.equalsEquals(referenceBinding2, referenceBinding3);
        }
        return sourceTypeBinding.fPackage == this.fPackage;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariableBindingArray) {
        char[] cArray;
        boolean bl;
        boolean bl2 = bl = this.isMemberType() && this.hasEnclosingInstanceContext() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES && !bl) {
            return this.signature();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (bl) {
            cArray = this.enclosingType().genericTypeSignature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('.');
            stringBuffer.append(this.sourceName);
        } else {
            cArray = this.signature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
        }
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('<');
            int n = typeVariableBindingArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(typeVariableBindingArray[i].genericTypeSignature());
            }
            stringBuffer.append(">;");
        }
        int n = stringBuffer.length();
        char[] cArray2 = new char[n];
        stringBuffer.getChars(0, n, cArray2, 0);
        return cArray2;
    }

    public void computeId() {
        switch (this.compoundName.length) {
            case 3: {
                char[] cArray = this.compoundName[0];
                switch (cArray.length) {
                    case 3: {
                        if (CharOperation.equals(TypeConstants.ORG_JUNIT_ASSERT, this.compoundName)) {
                            this.id = 70;
                        }
                        return;
                    }
                    case 4: {
                        if (CharOperation.equals(TypeConstants.JAVA, cArray)) break;
                        return;
                    }
                    case 5: {
                        switch (cArray[1]) {
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.JAVAX_ANNOTATION_INJECT_INJECT, this.compoundName)) {
                                    this.id = 80;
                                }
                                return;
                            }
                            case 'u': {
                                if (CharOperation.equals(TypeConstants.JUNIT_FRAMEWORK_ASSERT, this.compoundName)) {
                                    this.id = 69;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                cArray = this.compoundName[1];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray2 = this.compoundName[2];
                if (cArray2.length == 0) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    switch (cArray[0]) {
                        case 'i': {
                            if (CharOperation.equals(cArray, TypeConstants.IO)) {
                                switch (cArray2[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_CLOSEABLE[2])) {
                                            this.typeBits |= 2;
                                        }
                                        return;
                                    }
                                    case 'E': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_EXTERNALIZABLE[2])) {
                                            this.id = 56;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_IOEXCEPTION[2])) {
                                            this.id = 58;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_OBJECTSTREAMEXCEPTION[2])) {
                                            this.id = 57;
                                        }
                                        return;
                                    }
                                    case 'P': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_PRINTSTREAM[2])) {
                                            this.id = 53;
                                        }
                                        return;
                                    }
                                    case 'S': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_SERIALIZABLE[2])) {
                                            this.id = 37;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                        case 'u': {
                            if (CharOperation.equals(cArray, TypeConstants.UTIL)) {
                                switch (cArray2[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_COLLECTION[2])) {
                                            this.id = 59;
                                            this.typeBits |= 0x200;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_ITERATOR[2])) {
                                            this.id = 39;
                                        }
                                        return;
                                    }
                                    case 'L': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_LIST[2])) {
                                            this.id = 92;
                                            this.typeBits |= 0x400;
                                        }
                                        return;
                                    }
                                    case 'M': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_MAP[2])) {
                                            this.id = 91;
                                            this.typeBits |= 0x100;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_OBJECTS[2])) {
                                            this.id = 74;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                    }
                    return;
                }
                switch (cArray2[0]) {
                    case 'A': {
                        switch (cArray2.length) {
                            case 13: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_AUTOCLOSEABLE[2])) {
                                    this.id = 62;
                                    this.typeBits |= 1;
                                }
                                return;
                            }
                            case 14: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ASSERTIONERROR[2])) {
                                    this.id = 35;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'B': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BYTE[2])) {
                                    this.id = 26;
                                }
                                return;
                            }
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BOOLEAN[2])) {
                                    this.id = 33;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'C': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASS[2])) {
                                    this.id = 16;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CHARACTER[2])) {
                                    this.id = 28;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLONEABLE[2])) {
                                    this.id = 36;
                                }
                                return;
                            }
                            case 22: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                                    this.id = 23;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'D': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DOUBLE[2])) {
                                    this.id = 32;
                                }
                                return;
                            }
                            case 10: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                                    this.id = 44;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'E': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ENUM[2])) {
                                    this.id = 41;
                                }
                                return;
                            }
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ERROR[2])) {
                                    this.id = 19;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_EXCEPTION[2])) {
                                    this.id = 25;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_FUNCTIONAL_INTERFACE[2])) {
                            this.id = 77;
                        }
                        return;
                    }
                    case 'I': {
                        switch (cArray2.length) {
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_INTEGER[2])) {
                                    this.id = 29;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ITERABLE[2])) {
                                    this.id = 38;
                                }
                                return;
                            }
                            case 24: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                                    this.id = 42;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_NOCLASSDEFERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OBJECT[2])) {
                                    this.id = 1;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OVERRIDE[2])) {
                                    this.id = 47;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'R': {
                        if (!CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2])) break;
                        this.id = 24;
                        break;
                    }
                    case 'S': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SHORT[2])) {
                                    this.id = 27;
                                }
                                return;
                            }
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRING[2])) {
                                    this.id = 11;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SYSTEM[2])) {
                                    this.id = 18;
                                }
                                return;
                            }
                            case 11: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SAFEVARARGS[2])) {
                                    this.id = 60;
                                }
                                return;
                            }
                            case 12: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUFFER[2])) {
                                    this.id = 17;
                                }
                                return;
                            }
                            case 13: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUILDER[2])) {
                                    this.id = 40;
                                }
                                return;
                            }
                            case 16: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SUPPRESSWARNINGS[2])) {
                                    this.id = 49;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (CharOperation.equals(TypeConstants.COM_GOOGLE_INJECT_INJECT, this.compoundName)) {
                    this.id = 81;
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                char[] cArray = this.compoundName[1];
                if (cArray.length == 0) {
                    return;
                }
                cArray = this.compoundName[2];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray3 = this.compoundName[3];
                if (cArray3.length == 0) {
                    return;
                }
                switch (cArray[0]) {
                    case 'a': {
                        if (CharOperation.equals(cArray, TypeConstants.ANNOTATION)) {
                            switch (cArray3[0]) {
                                case 'A': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                                        this.id = 43;
                                    }
                                    return;
                                }
                                case 'D': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                                        this.id = 45;
                                    }
                                    return;
                                }
                                case 'E': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                                        this.id = 52;
                                    }
                                    return;
                                }
                                case 'I': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                                        this.id = 46;
                                    }
                                    return;
                                }
                                case 'R': {
                                    switch (cArray3.length) {
                                        case 9: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                                                this.id = 48;
                                            }
                                            return;
                                        }
                                        case 10: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_REPEATABLE[3])) {
                                                this.id = 90;
                                            }
                                            return;
                                        }
                                        case 15: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                                                this.id = 51;
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                case 'T': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                                        this.id = 50;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'i': {
                        if (CharOperation.equals(cArray, TypeConstants.INVOKE)) {
                            if (cArray3.length == 0) {
                                return;
                            }
                            switch (cArray3[0]) {
                                case 'M': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE[3])) {
                                        this.id = 61;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'r': {
                        if (CharOperation.equals(cArray, TypeConstants.REFLECT)) {
                            switch (cArray3[0]) {
                                case 'C': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[2])) {
                                        this.id = 20;
                                    }
                                    return;
                                }
                                case 'F': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_FIELD[2])) {
                                        this.id = 54;
                                    }
                                    return;
                                }
                                case 'M': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_METHOD[2])) {
                                        this.id = 55;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                }
                break;
            }
            case 5: {
                char[] cArray = this.compoundName[0];
                switch (cArray[0]) {
                    case 'j': {
                        if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                            return;
                        }
                        cArray = this.compoundName[1];
                        if (cArray.length == 0) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.LANG, cArray)) {
                            cArray = this.compoundName[2];
                            if (cArray.length == 0) {
                                return;
                            }
                            switch (cArray[0]) {
                                case 'i': {
                                    if (CharOperation.equals(cArray, TypeConstants.INVOKE)) {
                                        char[] cArray4 = this.compoundName[3];
                                        if (cArray4.length == 0) {
                                            return;
                                        }
                                        switch (cArray4[0]) {
                                            case 'M': {
                                                char[] cArray5 = this.compoundName[4];
                                                if (cArray5.length == 0) {
                                                    return;
                                                }
                                                if (CharOperation.equals(cArray4, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[3]) && CharOperation.equals(cArray5, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[4])) {
                                                    this.id = 61;
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    return;
                                }
                            }
                            return;
                        }
                        return;
                    }
                    case 'o': {
                        if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) {
                            return;
                        }
                        cArray = this.compoundName[1];
                        if (cArray.length == 0) {
                            return;
                        }
                        switch (cArray[0]) {
                            case 'e': {
                                if (CharOperation.equals(TypeConstants.ECLIPSE, cArray)) {
                                    cArray = this.compoundName[2];
                                    if (cArray.length == 0) {
                                        return;
                                    }
                                    switch (cArray[0]) {
                                        case 'c': {
                                            if (CharOperation.equals(cArray, TypeConstants.CORE)) {
                                                char[] cArray6 = this.compoundName[3];
                                                if (cArray6.length == 0) {
                                                    return;
                                                }
                                                switch (cArray6[0]) {
                                                    case 'r': {
                                                        char[] cArray7 = this.compoundName[4];
                                                        if (cArray7.length == 0) {
                                                            return;
                                                        }
                                                        if (CharOperation.equals(cArray6, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[3]) && CharOperation.equals(cArray7, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[4])) {
                                                            this.id = 68;
                                                        }
                                                        return;
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                return;
                            }
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.APACHE, cArray) && CharOperation.equals(TypeConstants.COMMONS, this.compoundName[2])) {
                                    if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG_VALIDATE, this.compoundName)) {
                                        this.id = 71;
                                    } else if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG3_VALIDATE, this.compoundName)) {
                                        this.id = 72;
                                    }
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'c': {
                        if (!CharOperation.equals(TypeConstants.COM, this.compoundName[0])) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.COM_GOOGLE_COMMON_BASE_PRECONDITIONS, this.compoundName)) {
                            this.id = 73;
                        }
                        return;
                    }
                }
                break;
            }
            case 6: {
                if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) break;
                if (CharOperation.equals(TypeConstants.SPRING, this.compoundName[1])) {
                    if (CharOperation.equals(TypeConstants.AUTOWIRED, this.compoundName[5]) && CharOperation.equals(TypeConstants.ORG_SPRING_AUTOWIRED, this.compoundName)) {
                        this.id = 82;
                    }
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.ITYPEBINDING, this.compoundName[5])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_CORE_DOM_ITYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
                break;
            }
            case 7: {
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.TYPEBINDING, this.compoundName[6])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_INTERNAL_COMPILER_LOOKUP_TYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
            }
        }
    }

    public void computeId(LookupEnvironment lookupEnvironment) {
        lookupEnvironment.getUnannotatedType(this);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        if (!bl) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    @Override
    public String debugName() {
        return this.compoundName != null ? (this.hasTypeAnnotations() ? this.annotatedDebugName() : new String(this.readableName())) : "UNNAMED TYPE";
    }

    @Override
    public int depth() {
        int n = 0;
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.enclosingType()) != null) {
            ++n;
        }
        return n;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) != 0L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) != 0L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] methodBindingArray = this.methods();
        boolean bl = false;
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            MethodDeclaration methodDeclaration;
            TypeBinding typeBinding = methodBindingArray[i].returnType.leafComponentType().erasure();
            if (TypeBinding.equalsEquals(this, typeBinding)) {
                if (!(this instanceof SourceTypeBinding)) continue;
                methodDeclaration = (MethodDeclaration)methodBindingArray[i].sourceMethod();
                ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, this, methodDeclaration != null ? methodDeclaration.returnType : null);
                continue;
            }
            if (!typeBinding.isAnnotationType() || !((ReferenceBinding)typeBinding).detectAnnotationCycle()) continue;
            if (this instanceof SourceTypeBinding) {
                methodDeclaration = (MethodDeclaration)methodBindingArray[i].sourceMethod();
                ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, typeBinding, methodDeclaration != null ? methodDeclaration.returnType : null);
            }
            bl = true;
        }
        if (bl) {
            return true;
        }
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int n) {
        ReferenceBinding referenceBinding;
        for (referenceBinding = this; n-- > 0 && referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
        }
        return referenceBinding;
    }

    public int enumConstantCount() {
        int n = 0;
        FieldBinding[] fieldBindingArray = this.fields();
        int n2 = fieldBindingArray.length;
        for (int i = 0; i < n2; ++i) {
            if ((fieldBindingArray[i].modifiers & 0x4000) == 0) continue;
            ++n;
        }
        return n;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return Binding.NO_FIELDS;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    @Override
    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public int getEnclosingInstancesSlotSize() {
        if (this.isStatic()) {
            return 0;
        }
        return this.enclosingType() == null ? 0 : 1;
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        ReferenceBinding[] referenceBindingArray = this.memberTypes();
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(referenceBindingArray[n].sourceName, cArray)) continue;
            return referenceBindingArray[n];
        }
        return null;
    }

    @Override
    public MethodBinding[] getMethods(char[] cArray) {
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] cArray, int n) {
        return this.getMethods(cArray);
    }

    public int getOuterLocalVariablesSlotSize() {
        return 0;
    }

    @Override
    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        int n = typeVariableBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(typeVariableBindingArray[n].sourceName, cArray)) continue;
            return typeVariableBindingArray[n];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding referenceBinding) {
        int n;
        TypeBinding typeBinding;
        if (TypeBinding.equalsEquals(this, referenceBinding)) {
            return false;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            if ((typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2)) != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding2.superInterfaces();
            if (referenceBindingArray2 == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            block1: for (n = 0; n < n3; ++n) {
                ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                for (int i = 0; i < n2; ++i) {
                    if (TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray[i])) continue block1;
                }
                referenceBindingArray[n2++] = referenceBinding3;
            }
        } while ((referenceBinding2 = referenceBinding2.superclass()) != null);
        for (int i = 0; i < n2; ++i) {
            referenceBinding2 = referenceBindingArray[i];
            if (TypeBinding.equalsEquals(referenceBinding2, referenceBinding)) {
                return false;
            }
            typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2);
            if (typeBinding != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 == null || referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
            n = referenceBindingArray4.length;
            if (n2 + n >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
            }
            block4: for (int j = 0; j < n; ++j) {
                ReferenceBinding referenceBinding4 = referenceBindingArray4[j];
                for (int k = 0; k < n2; ++k) {
                    if (TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray[k])) continue block4;
                }
                referenceBindingArray[n2++] = referenceBinding4;
            }
        }
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    boolean hasNonNullDefaultFor(int n, int n2) {
        for (ReferenceBinding referenceBinding = this; referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
            int n3 = ((ReferenceBinding)referenceBinding.original()).getNullDefault();
            if (n3 == 0) continue;
            return (n3 & n) != 0;
        }
        return (this.getPackage().getDefaultNullness() & n) != 0;
    }

    int getNullDefault() {
        return 0;
    }

    @Override
    public boolean acceptsNonNullDefault() {
        return true;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean hasNullBit(int n) {
        return (this.typeBits & n) != 0;
    }

    public boolean implementsInterface(ReferenceBinding referenceBinding, boolean bl) {
        int n;
        if (TypeBinding.equalsEquals(this, referenceBinding)) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            ReferenceBinding[] referenceBindingArray2;
            if ((referenceBindingArray2 = referenceBinding2.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            block1: for (n = 0; n < n3; ++n) {
                ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                for (int i = 0; i < n2; ++i) {
                    if (TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray[i])) continue block1;
                }
                referenceBindingArray[n2++] = referenceBinding3;
            }
        } while (bl && (referenceBinding2 = referenceBinding2.superclass()) != null);
        for (int i = 0; i < n2; ++i) {
            referenceBinding2 = referenceBindingArray[i];
            if (referenceBinding2.isEquivalentTo(referenceBinding)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 == null || referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
            n = referenceBindingArray4.length;
            if (n2 + n >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
            }
            block4: for (int j = 0; j < n; ++j) {
                ReferenceBinding referenceBinding4 = referenceBindingArray4[j];
                for (int k = 0; k < n2; ++k) {
                    if (TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray[k])) continue block4;
                }
                referenceBindingArray[n2++] = referenceBinding4;
            }
        }
        return false;
    }

    boolean implementsMethod(MethodBinding methodBinding) {
        char[] cArray = methodBinding.selector;
        for (ReferenceBinding referenceBinding = this; referenceBinding != null; referenceBinding = referenceBinding.superclass()) {
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            long l = ReferenceBinding.binarySearch(cArray, methodBindingArray);
            if (l < 0L) continue;
            int n = (int)l;
            int n2 = (int)(l >> 32);
            for (int i = n; i <= n2; ++i) {
                if (!methodBindingArray[i].areParametersEqual(methodBinding)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    @Override
    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    @Override
    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    private static SourceTypeBinding getSourceTypeBinding(ReferenceBinding referenceBinding) {
        if (referenceBinding instanceof SourceTypeBinding) {
            return (SourceTypeBinding)referenceBinding;
        }
        if (referenceBinding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
            return parameterizedTypeBinding.type instanceof SourceTypeBinding ? (SourceTypeBinding)parameterizedTypeBinding.type : null;
        }
        return null;
    }

    public boolean isNestmateOf(ReferenceBinding referenceBinding) {
        SourceTypeBinding sourceTypeBinding = ReferenceBinding.getSourceTypeBinding(this);
        SourceTypeBinding sourceTypeBinding2 = ReferenceBinding.getSourceTypeBinding(referenceBinding);
        if (sourceTypeBinding == null || sourceTypeBinding2 == null) {
            return false;
        }
        return sourceTypeBinding.isNestmateOf(sourceTypeBinding2);
    }

    @Override
    public boolean isProperType(boolean bl) {
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding != null && !referenceBinding.isProperType(bl)) {
            return false;
        }
        return super.isProperType(bl);
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (ReferenceBinding.equalsEquals(typeBinding, this)) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new SimpleLookupTable(3);
            Object var3_3 = null;
        } else {
            Object object = this.compatibleCache.get(typeBinding);
            if (object != null) {
                return object == Boolean.TRUE;
            }
        }
        this.compatibleCache.put(typeBinding, Boolean.FALSE);
        if (this.isCompatibleWith0(typeBinding, scope)) {
            this.compatibleCache.put(typeBinding, Boolean.TRUE);
            return true;
        }
        if (scope == null && this instanceof TypeVariableBinding && ((TypeVariableBinding)this).firstBound instanceof ParameterizedTypeBinding) {
            this.compatibleCache.put(typeBinding, null);
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding typeBinding, Scope scope) {
        if (TypeBinding.equalsEquals(typeBinding, this)) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return false;
            }
            case 4100: {
                Object object;
                Object object2;
                if (typeBinding.isCapture()) {
                    object2 = (CaptureBinding)typeBinding;
                    object = ((CaptureBinding)object2).lowerBound;
                    if (((CaptureBinding)object2).lowerBound != null) {
                        if (object.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith((TypeBinding)object);
                    }
                }
                if (typeBinding instanceof InferenceVariable && scope != null && (object2 = scope.methodScope()) != null && (object = ((MethodScope)object2).referenceContext) instanceof LambdaExpression && ((LambdaExpression)object).inferenceContext != null) {
                    return true;
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: 
            case 32772: {
                Object object;
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (!TypeBinding.equalsEquals(this.erasure(), typeBinding.erasure())) break;
                        return false;
                    }
                }
                Object object2 = (ReferenceBinding)typeBinding;
                if (((TypeBinding)object2).isIntersectionType18()) {
                    for (ReferenceBinding referenceBinding : object = ((IntersectionTypeBinding18)object2).intersectingTypes) {
                        if (this.isCompatibleWith(referenceBinding)) continue;
                        return false;
                    }
                    return true;
                }
                if (((ReferenceBinding)object2).isInterface()) {
                    if (this.implementsInterface((ReferenceBinding)object2, true)) {
                        return true;
                    }
                    if (this instanceof TypeVariableBinding && scope != null) {
                        object = (TypeVariableBinding)this;
                        if (object.firstBound instanceof ParameterizedTypeBinding) {
                            TypeBinding typeBinding2 = object.firstBound.capture(scope, -1, -1);
                            return typeBinding2.isCompatibleWith((TypeBinding)object2);
                        }
                    }
                }
                if (this.isInterface()) {
                    return false;
                }
                return ((ReferenceBinding)object2).isSuperclassOf(this);
            }
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding, boolean bl) {
        if (this.isSubTypeOfRTL(typeBinding)) {
            return true;
        }
        TypeBinding typeBinding2 = this.findSuperTypeOriginatingFrom(typeBinding);
        if (typeBinding2 == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(typeBinding2, typeBinding)) {
            return true;
        }
        if (typeBinding.isRawType() && TypeBinding.equalsEquals(typeBinding2.erasure(), typeBinding.erasure())) {
            return true;
        }
        TypeBinding[] typeBindingArray = typeBinding.typeArguments();
        TypeBinding[] typeBindingArray2 = typeBinding2.typeArguments();
        if (typeBindingArray2 == null || typeBindingArray == null) {
            return false;
        }
        if (typeBindingArray.length != typeBindingArray2.length) {
            return false;
        }
        for (int i = 0; i < typeBindingArray.length; ++i) {
            if (typeBindingArray2[i].isTypeArgumentContainedBy(typeBindingArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubTypeOfRTL(TypeBinding typeBinding) {
        ReferenceBinding[] referenceBindingArray;
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding instanceof CaptureBinding) {
            TypeBinding typeBinding2 = ((CaptureBinding)typeBinding).lowerBound;
            return typeBinding2 != null && this.isSubtypeOf(typeBinding2, false);
        }
        if (typeBinding instanceof ReferenceBinding && (referenceBindingArray = ((ReferenceBinding)typeBinding).getIntersectingTypes()) != null) {
            for (int i = 0; i < referenceBindingArray.length; ++i) {
                if (this.isSubtypeOf(referenceBindingArray[i], false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isHierarchyBeingActivelyConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L && (this.tagBits & 0x80000L) == 0L;
    }

    public boolean isHierarchyConnected() {
        return true;
    }

    @Override
    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    @Override
    public boolean isFunctionalInterface(Scope scope) {
        MethodBinding methodBinding;
        return this.isInterface() && (methodBinding = this.getSingleAbstractMethod(scope, true)) != null && methodBinding.isValidBinding();
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if (this.isLocalType()) {
            return true;
        }
        for (ReferenceBinding referenceBinding = this; referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
            if ((referenceBinding.modifiers & 2) == 0) continue;
            return true;
        }
        return false;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            if (!referenceBinding.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrowable() {
        ReferenceBinding referenceBinding = this;
        do {
            switch (referenceBinding.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    @Override
    public boolean isUncheckedException(boolean bl) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return bl;
            }
        }
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            switch (referenceBinding.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        if ((this.modifiers & 0x300000) != 0) {
            return true;
        }
        if (this.getPackage().isViewedAsDeprecated()) {
            this.tagBits |= this.getPackage().tagBits & 0x4000000000000000L;
            return true;
        }
        return false;
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding referenceBinding;
        ReferenceBinding referenceBinding2 = this;
        do {
            referenceBinding = referenceBinding2;
        } while ((referenceBinding2 = referenceBinding2.enclosingType()) != null);
        return referenceBinding;
    }

    @Override
    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    @Override
    public char[] readableName() {
        return this.readableName(true);
    }

    public char[] readableName(boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(bl && this.hasEnclosingInstanceContext()), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        if (bl && (typeVariableBindingArray = this.typeVariables()) != Binding.NO_TYPE_VARIABLES) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n2 = typeVariableBindingArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].readableName());
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    protected void appendNullAnnotation(StringBuffer stringBuffer, CompilerOptions compilerOptions) {
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (compilerOptions.usesNullTypeAnnotations()) {
                for (AnnotationBinding annotationBinding : this.typeAnnotations) {
                    ReferenceBinding referenceBinding = annotationBinding.getAnnotationType();
                    if (!referenceBinding.hasNullBit(96)) continue;
                    stringBuffer.append('@').append(referenceBinding.shortReadableName()).append(' ');
                }
            } else {
                char[][] cArray;
                if ((this.tagBits & 0x100000000000000L) != 0L) {
                    cArray = compilerOptions.nonNullAnnotationName;
                    stringBuffer.append('@').append(cArray[cArray.length - 1]).append(' ');
                }
                if ((this.tagBits & 0x80000000000000L) != 0L) {
                    cArray = compilerOptions.nullableAnnotationName;
                    stringBuffer.append('@').append(cArray[cArray.length - 1]).append(' ');
                }
            }
        }
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(bl, false);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.storeAnnotations(this, annotationBindingArray, bl);
    }

    public void setContainerAnnotationType(ReferenceBinding referenceBinding) {
    }

    public void tagAsHavingDefectiveContainerType() {
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (bl) {
            return this.nullAnnotatedShortReadableName(compilerOptions);
        }
        return this.nullAnnotatedReadableName(compilerOptions);
    }

    char[] nullAnnotatedReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, false));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else if (this.compoundName != null) {
            int n2;
            n = this.compoundName.length;
            for (n2 = 0; n2 < n - 1; ++n2) {
                stringBuffer.append(this.compoundName[n2]);
                stringBuffer.append('.');
            }
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.compoundName[n2]);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.sourceName != null) {
                stringBuffer.append(this.sourceName);
            } else {
                stringBuffer.append(this.readableName());
            }
        }
        TypeBinding[] typeBindingArray = this.typeArguments();
        if (typeBindingArray != null && typeBindingArray.length > 0) {
            stringBuffer.append('<');
            int n3 = typeBindingArray.length;
            for (n = 0; n < n3; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeBindingArray[n].nullAnnotatedReadableName(compilerOptions, false));
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    char[] nullAnnotatedShortReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, true));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.sourceName != null) {
                stringBuffer.append(this.sourceName);
            } else {
                stringBuffer.append(this.shortReadableName());
            }
        }
        TypeBinding[] typeBindingArray = this.typeArguments();
        if (typeBindingArray != null && typeBindingArray.length > 0) {
            stringBuffer.append('<');
            int n2 = typeBindingArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeBindingArray[n].nullAnnotatedReadableName(compilerOptions, true));
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public char[] shortReadableName() {
        return this.shortReadableName(true);
    }

    public char[] shortReadableName(boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(bl && this.hasEnclosingInstanceContext()), this.sourceName, '.') : this.sourceName;
        if (bl && (typeVariableBindingArray = this.typeVariables()) != Binding.NO_TYPE_VARIABLES) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n2 = typeVariableBindingArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].shortReadableName());
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    @Override
    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    @Override
    public char[] sourceName() {
        return this.sourceName;
    }

    @Override
    public ReferenceBinding upwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        return this;
    }

    @Override
    public ReferenceBinding downwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        return this;
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray, boolean bl) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, bl);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, bl);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    SimpleLookupTable storedAnnotations(boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public ReferenceBinding superclass() {
        return null;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        return Binding.NO_SUPERINTERFACES;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding == null) {
            return null;
        }
        return new ReferenceBinding[]{referenceBinding};
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }

    public FieldBinding[] unResolvedFields() {
        return Binding.NO_FIELDS;
    }

    protected int applyCloseableClassWhitelists() {
        int n;
        switch (this.compoundName.length) {
            case 3: {
                int n2;
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) || !CharOperation.equals(TypeConstants.IO, this.compoundName[1])) break;
                char[] cArray = this.compoundName[2];
                n = TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES.length;
                for (n2 = 0; n2 < n; ++n2) {
                    if (!CharOperation.equals(cArray, TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES[n2])) continue;
                    return 4;
                }
                n = TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES.length;
                for (n2 = 0; n2 < n; ++n2) {
                    if (!CharOperation.equals(cArray, TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES[n2])) continue;
                    return 8;
                }
                break;
            }
            case 4: {
                int n2;
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) || !CharOperation.equals(TypeConstants.UTIL, this.compoundName[1]) || !CharOperation.equals(TypeConstants.ZIP, this.compoundName[2])) break;
                char[] cArray = this.compoundName[3];
                n = TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES.length;
                for (n2 = 0; n2 < n; ++n2) {
                    if (!CharOperation.equals(cArray, TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES[n2])) continue;
                    return 4;
                }
                break;
            }
        }
        int n3 = TypeConstants.OTHER_WRAPPER_CLOSEABLES.length;
        for (n = 0; n < n3; ++n) {
            if (!CharOperation.equals(this.compoundName, TypeConstants.OTHER_WRAPPER_CLOSEABLES[n])) continue;
            return 4;
        }
        return 0;
    }

    protected int applyCloseableInterfaceWhitelists() {
        switch (this.compoundName.length) {
            case 4: {
                for (int i = 0; i < 2; ++i) {
                    if (CharOperation.equals(this.compoundName[i], TypeConstants.JAVA_UTIL_STREAM[i])) continue;
                    return 0;
                }
                for (char[] cArray : TypeConstants.RESOURCE_FREE_CLOSEABLE_J_U_STREAMS) {
                    if (!CharOperation.equals(this.compoundName[3], cArray)) continue;
                    return 8;
                }
                break;
            }
        }
        return 0;
    }

    protected MethodBinding[] getInterfaceAbstractContracts(Scope scope, boolean bl, boolean bl2) throws InvalidInputException {
        int n;
        if (!this.isInterface() || !this.isValidBinding()) {
            throw new InvalidInputException("Not a functional interface");
        }
        MethodBinding[] methodBindingArray = this.methods();
        MethodBinding[] methodBindingArray2 = new MethodBinding[]{};
        int n2 = 0;
        int n3 = 0;
        ReferenceBinding[] referenceBindingArray = this.superInterfaces();
        int n4 = referenceBindingArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            MethodBinding[] methodBindingArray3 = referenceBindingArray[i].getInterfaceAbstractContracts(scope, bl, false);
            int n6 = n5 = methodBindingArray3 == null ? 0 : methodBindingArray3.length;
            if (n5 == 0) continue;
            if (n3 < n2 + n5) {
                MethodBinding[] methodBindingArray4 = methodBindingArray2;
                n3 = n2 + n5;
                methodBindingArray2 = new MethodBinding[n3];
                System.arraycopy(methodBindingArray4, 0, methodBindingArray2, 0, n2);
            }
            System.arraycopy(methodBindingArray3, 0, methodBindingArray2, n2, n5);
            n2 += n5;
        }
        LookupEnvironment lookupEnvironment = scope.environment();
        int n7 = n = methodBindingArray == null ? 0 : methodBindingArray.length;
        for (n4 = 0; n4 < n; ++n4) {
            MethodBinding methodBinding = methodBindingArray[n4];
            if (methodBinding == null || methodBinding.isStatic() || methodBinding.redeclaresPublicObjectMethod(scope) || methodBinding.isPrivate()) continue;
            if (!methodBinding.isValidBinding()) {
                throw new InvalidInputException("Not a functional interface");
            }
            int n8 = 0;
            while (n8 < n2) {
                if (methodBindingArray2[n8] != null && MethodVerifier.doesMethodOverride(methodBinding, methodBindingArray2[n8], lookupEnvironment) && n8 < --n2) {
                    System.arraycopy(methodBindingArray2, n8 + 1, methodBindingArray2, n8, n2 - n8);
                    continue;
                }
                ++n8;
            }
            if (bl2 && methodBinding.isDefaultMethod()) continue;
            if (n2 == n3) {
                MethodBinding[] methodBindingArray5 = methodBindingArray2;
                methodBindingArray2 = new MethodBinding[n3 += 16];
                System.arraycopy(methodBindingArray5, 0, methodBindingArray2, 0, n2);
            }
            if (lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                ImplicitNullAnnotationVerifier.ensureNullnessIsKnown(methodBinding, scope);
            }
            methodBindingArray2[n2++] = methodBinding;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            MethodBinding methodBinding = methodBindingArray2[n4];
            if (TypeBinding.equalsEquals(methodBinding.declaringClass, this)) continue;
            for (int i = 0; i < n2; ++i) {
                MethodBinding methodBinding2 = methodBindingArray2[i];
                if (n4 == i || TypeBinding.equalsEquals(methodBinding2.declaringClass, this) || methodBinding != methodBinding2 && !MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, lookupEnvironment)) continue;
                if (i < --n2) {
                    System.arraycopy(methodBindingArray2, i + 1, methodBindingArray2, i, n2 - i);
                }
                if (--i >= n4) continue;
                --n4;
            }
            if (!bl2 || !methodBinding.isDefaultMethod()) continue;
            if (n4 < --n2) {
                System.arraycopy(methodBindingArray2, n4 + 1, methodBindingArray2, n4, n2 - n4);
            }
            --n4;
        }
        if (n2 < n3) {
            MethodBinding[] methodBindingArray6 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n2];
            System.arraycopy(methodBindingArray6, 0, methodBindingArray2, 0, n2);
        }
        return methodBindingArray2;
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = bl ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n3] != null) {
                return this.singleAbstractMethod[n3];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        if (this.compoundName != null) {
            scope.compilationUnitScope().recordQualifiedReference(this.compoundName);
        }
        MethodBinding[] methodBindingArray = null;
        try {
            methodBindingArray = this.getInterfaceAbstractContracts(scope, bl, true);
            if (methodBindingArray == null || methodBindingArray.length == 0) {
                this.singleAbstractMethod[n3] = samProblemBinding;
                return this.singleAbstractMethod[n3];
            }
            int n5 = 0;
            char[] cArray = null;
            n2 = methodBindingArray.length;
            for (n = 0; n < n2; ++n) {
                int n6;
                MethodBinding methodBinding = methodBindingArray[n];
                if (methodBinding == null) continue;
                if (cArray == null) {
                    cArray = methodBinding.selector;
                    n5 = methodBinding.parameters == null ? 0 : methodBinding.parameters.length;
                    continue;
                }
                int n7 = n6 = methodBinding.parameters == null ? 0 : methodBinding.parameters.length;
                if (n6 == n5 && CharOperation.equals(methodBinding.selector, cArray)) continue;
                this.singleAbstractMethod[n3] = samProblemBinding;
                return this.singleAbstractMethod[n3];
            }
        }
        catch (InvalidInputException invalidInputException) {
            this.singleAbstractMethod[n3] = samProblemBinding;
            return this.singleAbstractMethod[n3];
        }
        if (methodBindingArray.length == 1) {
            this.singleAbstractMethod[n3] = methodBindingArray[0];
            return this.singleAbstractMethod[n3];
        }
        LookupEnvironment lookupEnvironment = scope.environment();
        boolean bl2 = false;
        n = methodBindingArray.length;
        n2 = lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled ? 1 : 0;
        block3: for (int i = n - 1; i >= 0; --i) {
            MethodBinding methodBinding = methodBindingArray[i];
            MethodBinding methodBinding2 = null;
            if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                bl2 = true;
            }
            TypeBinding typeBinding = methodBinding.returnType;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                methodBinding2 = methodBindingArray[j];
                if (methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    bl2 = true;
                }
                if (bl2 && (methodBinding2 = MethodVerifier.computeSubstituteMethod(methodBinding2, methodBinding, lookupEnvironment)) == null || !MethodVerifier.isSubstituteParameterSubsignature(methodBinding, methodBinding2, lookupEnvironment) || !MethodVerifier.areReturnTypesCompatible(methodBinding, methodBinding2, lookupEnvironment)) continue block3;
                if (n2 == 0) continue;
                typeBinding = NullAnnotationMatching.strongerType(typeBinding, methodBinding2.returnType, lookupEnvironment);
                typeBindingArray = NullAnnotationMatching.weakerTypes(typeBindingArray, methodBinding2.parameters, lookupEnvironment);
            }
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[]{};
            int n8 = 0;
            int n9 = 0;
            MethodBinding methodBinding3 = methodBinding;
            boolean bl3 = methodBinding3.typeVariables == Binding.NO_TYPE_VARIABLES && bl2;
            boolean bl4 = methodBinding3.typeVariables != Binding.NO_TYPE_VARIABLES;
            int n10 = methodBinding3.typeVariables.length;
            block5: for (i = 0; i < n; ++i) {
                int n11;
                int n12;
                methodBinding = methodBindingArray[i];
                ReferenceBinding[] referenceBindingArray2 = methodBinding.thrownExceptions;
                int n13 = n12 = referenceBindingArray2 == null ? 0 : referenceBindingArray2.length;
                if (n12 == 0) break;
                if (bl4 && methodBinding != methodBinding3) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n12];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n12);
                    for (n11 = 0; n11 < n10; ++n11) {
                        if (!(referenceBindingArray2[n11] instanceof TypeVariableBinding)) continue;
                        referenceBindingArray2[n11] = methodBinding3.typeVariables[n11];
                    }
                }
                block7: for (n11 = 0; n11 < n12; ++n11) {
                    ReferenceBinding referenceBinding = referenceBindingArray2[n11];
                    if (bl3) {
                        referenceBinding = (ReferenceBinding)referenceBinding.erasure();
                    }
                    block8: for (int j = 0; j < n; ++j) {
                        int n14;
                        int n15;
                        if (i == j) continue;
                        methodBinding2 = methodBindingArray[j];
                        ReferenceBinding[] referenceBindingArray4 = methodBinding2.thrownExceptions;
                        int n16 = n15 = referenceBindingArray4 == null ? 0 : referenceBindingArray4.length;
                        if (n15 == 0) break block5;
                        if (bl4 && methodBinding2 != methodBinding3) {
                            ReferenceBinding[] referenceBindingArray5 = referenceBindingArray4;
                            referenceBindingArray4 = new ReferenceBinding[n15];
                            System.arraycopy(referenceBindingArray5, 0, referenceBindingArray4, 0, n15);
                            for (n14 = 0; n14 < n10; ++n14) {
                                if (!(referenceBindingArray4[n14] instanceof TypeVariableBinding)) continue;
                                referenceBindingArray4[n14] = methodBinding3.typeVariables[n14];
                            }
                        }
                        for (n14 = 0; n14 < n15; ++n14) {
                            ReferenceBinding referenceBinding2 = referenceBindingArray4[n14];
                            if (bl3) {
                                referenceBinding2 = (ReferenceBinding)referenceBinding2.erasure();
                            }
                            if (referenceBinding.isCompatibleWith(referenceBinding2)) continue block8;
                        }
                        continue block7;
                    }
                    if (n8 == n9) {
                        ReferenceBinding[] referenceBindingArray6 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n9 += 16];
                        System.arraycopy(referenceBindingArray6, 0, referenceBindingArray, 0, n8);
                    }
                    referenceBindingArray[n8++] = referenceBinding;
                }
            }
            if (n8 != n9) {
                ReferenceBinding[] referenceBindingArray7 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n8];
                System.arraycopy(referenceBindingArray7, 0, referenceBindingArray, 0, n8);
            }
            this.singleAbstractMethod[n3] = new MethodBinding(methodBinding3.modifiers | 0x1000, methodBinding3.selector, typeBinding, typeBindingArray, referenceBindingArray, methodBinding3.declaringClass);
            this.singleAbstractMethod[n3].typeVariables = methodBinding3.typeVariables;
            return this.singleAbstractMethod[n3];
        }
        this.singleAbstractMethod[n3] = samProblemBinding;
        return this.singleAbstractMethod[n3];
    }

    public static boolean isConsistentIntersection(TypeBinding[] typeBindingArray) {
        TypeBinding[] typeBindingArray2 = new TypeBinding[typeBindingArray.length];
        for (int i = 0; i < typeBindingArray2.length; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            typeBindingArray2[i] = typeBinding.isClass() || typeBinding.isArrayType() ? typeBinding : typeBinding.superclass();
        }
        TypeBinding typeBinding = typeBindingArray2[0];
        for (int i = 1; i < typeBindingArray2.length; ++i) {
            TypeBinding typeBinding2 = typeBindingArray2[i];
            if (typeBinding2.isTypeVariable() || typeBinding2.isWildcard() || !typeBinding2.isProperType(true) || typeBinding.isSubtypeOf(typeBinding2, false)) continue;
            if (typeBinding2.isSubtypeOf(typeBinding, false)) {
                typeBinding = typeBinding2;
                continue;
            }
            return false;
        }
        return true;
    }

    public ModuleBinding module() {
        if (this.fPackage != null) {
            return this.fPackage.enclosingModule;
        }
        return null;
    }

    public boolean hasEnclosingInstanceContext() {
        if (this.isMemberType() && !this.isStatic()) {
            return true;
        }
        MethodBinding methodBinding = this.enclosingMethod();
        if (methodBinding != null) {
            return !methodBinding.isStatic();
        }
        return false;
    }
}

