/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;

public class SignatureWrapper {
    public char[] signature;
    public int start;
    public int end;
    public int bracket;
    private boolean use15specifics;
    private boolean useExternalAnnotations;

    public SignatureWrapper(char[] cArray, boolean bl) {
        this.signature = cArray;
        this.start = 0;
        this.bracket = -1;
        this.end = -1;
        this.use15specifics = bl;
        if (!bl) {
            this.removeTypeArguments();
        }
    }

    public SignatureWrapper(char[] cArray, boolean bl, boolean bl2) {
        this.signature = cArray;
        this.start = 0;
        this.bracket = -1;
        this.end = -1;
        this.use15specifics = bl;
        this.useExternalAnnotations = bl2;
        if (!bl) {
            this.removeTypeArguments();
        }
    }

    public SignatureWrapper(char[] cArray) {
        this(cArray, true);
    }

    public boolean atEnd() {
        return this.start < 0 || this.start >= this.signature.length;
    }

    public boolean isParameterized() {
        return this.bracket == this.end;
    }

    public int computeEnd() {
        int n = this.start;
        if (this.useExternalAnnotations) {
            block7: while (true) {
                switch (this.signature[n]) {
                    case '0': 
                    case '1': 
                    case '@': {
                        if (n == this.start) break block7;
                    }
                    case '[': {
                        ++n;
                        continue block7;
                    }
                }
                break;
            }
        } else {
            while (this.signature[n] == '[') {
                ++n;
            }
        }
        switch (this.signature[n]) {
            case 'L': 
            case 'T': {
                this.end = CharOperation.indexOf(';', this.signature, this.start);
                if (this.bracket <= this.start) {
                    this.bracket = CharOperation.indexOf('<', this.signature, this.start);
                }
                if (this.bracket > this.start && this.bracket < this.end) {
                    this.end = this.bracket;
                    break;
                }
                if (this.end != -1) break;
                this.end = this.signature.length + 1;
                break;
            }
            default: {
                this.end = n;
            }
        }
        if (this.use15specifics || this.end != this.bracket) {
            this.start = this.end + 1;
        } else {
            this.start = this.skipAngleContents(this.end) + 1;
            this.bracket = -1;
        }
        return this.end;
    }

    private void removeTypeArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.start;
        if (this.signature[0] == '<') {
            ++n2;
        }
        while (n2 < this.signature.length) {
            if (this.signature[n2] == '<') {
                stringBuilder.append(this.signature, n, n2 - n);
                n2 = n = this.skipAngleContents(n2);
            }
            ++n2;
        }
        stringBuilder.append(this.signature, n, n2 - n);
        this.signature = new char[stringBuilder.length()];
        stringBuilder.getChars(0, this.signature.length, this.signature, 0);
    }

    public int skipAngleContents(int n) {
        if (this.signature[n] != '<') {
            return n;
        }
        int n2 = 0;
        int n3 = this.signature.length;
        ++n;
        while (n < n3) {
            switch (this.signature[n]) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    if (--n2 >= 0) break;
                    return n + 1;
                }
            }
            ++n;
        }
        return n;
    }

    public char[] nextWord() {
        this.end = CharOperation.indexOf(';', this.signature, this.start);
        if (this.bracket <= this.start) {
            this.bracket = CharOperation.indexOf('<', this.signature, this.start);
        }
        int n = CharOperation.indexOf('.', this.signature, this.start);
        if (this.bracket > this.start && this.bracket < this.end) {
            this.end = this.bracket;
        }
        if (n > this.start && n < this.end) {
            this.end = n;
        }
        this.start = this.end;
        return CharOperation.subarray(this.signature, this.start, this.start);
    }

    public char[] nextName() {
        this.end = CharOperation.indexOf(';', this.signature, this.start);
        if (this.bracket <= this.start) {
            this.bracket = CharOperation.indexOf('<', this.signature, this.start);
        }
        if (this.bracket > this.start && this.bracket < this.end) {
            this.end = this.bracket;
        }
        this.start = this.end;
        return CharOperation.subarray(this.signature, this.start, this.start);
    }

    public char[] peekFullType() {
        int n = this.start;
        int n2 = this.bracket;
        int n3 = this.end;
        int n4 = this.skipAngleContents(this.computeEnd());
        this.start = n;
        this.bracket = n2;
        this.end = n3;
        return CharOperation.subarray(this.signature, n, n4 + 1);
    }

    public char[] getFrom(int n) {
        if (this.end == this.bracket) {
            this.end = this.skipAngleContents(this.bracket);
            this.start = this.end + 1;
        }
        return CharOperation.subarray(this.signature, n, this.end + 1);
    }

    public char[] tail() {
        return CharOperation.subarray(this.signature, this.start, this.signature.length);
    }

    public String toString() {
        if (this.start >= 0 && this.start <= this.signature.length) {
            return new String(CharOperation.subarray(this.signature, 0, this.start)) + " ^ " + new String(CharOperation.subarray(this.signature, this.start, this.signature.length));
        }
        return new String(this.signature) + " @ " + this.start;
    }

    public char charAtStart() {
        return this.signature[this.start];
    }
}

