/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.net;

import java.util.concurrent.locks.ReentrantLock;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.io.GuacamoleReader;
import org.glyptodon.guacamole.io.GuacamoleWriter;
import org.glyptodon.guacamole.net.GuacamoleTunnel;

public abstract class AbstractGuacamoleTunnel
implements GuacamoleTunnel {
    private final ReentrantLock readerLock = new ReentrantLock();
    private final ReentrantLock writerLock = new ReentrantLock();

    @Override
    public GuacamoleReader acquireReader() {
        this.readerLock.lock();
        return this.getSocket().getReader();
    }

    @Override
    public void releaseReader() {
        this.readerLock.unlock();
    }

    @Override
    public boolean hasQueuedReaderThreads() {
        return this.readerLock.hasQueuedThreads();
    }

    @Override
    public GuacamoleWriter acquireWriter() {
        this.writerLock.lock();
        return this.getSocket().getWriter();
    }

    @Override
    public void releaseWriter() {
        this.writerLock.unlock();
    }

    @Override
    public boolean hasQueuedWriterThreads() {
        return this.writerLock.hasQueuedThreads();
    }

    @Override
    public void close() throws GuacamoleException {
        this.getSocket().close();
    }

    @Override
    public boolean isOpen() {
        return this.getSocket().isOpen();
    }
}

