/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.protocol;

import java.util.Arrays;
import java.util.Iterator;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.GuacamoleServerException;
import org.glyptodon.guacamole.protocol.GuacamoleInstruction;

public class GuacamoleParser
implements Iterator<GuacamoleInstruction> {
    public static final int INSTRUCTION_MAX_LENGTH = 8192;
    public static final int INSTRUCTION_MAX_DIGITS = 5;
    public static final int INSTRUCTION_MAX_ELEMENTS = 64;
    private GuacamoleInstruction parsedInstruction;
    private State state = State.PARSING_LENGTH;
    private int elementLength = 0;
    private int elementCount = 0;
    private final String[] elements = new String[64];

    public int append(char[] chunk, int offset, int length) throws GuacamoleException {
        int charsParsed = 0;
        if (this.elementCount == 64 && this.state != State.COMPLETE) {
            this.state = State.ERROR;
            throw new GuacamoleServerException("Instruction contains too many elements.");
        }
        if (this.state == State.PARSING_LENGTH) {
            int parsedLength = this.elementLength;
            while (charsParsed < length) {
                char c;
                if ((c = chunk[offset + charsParsed++]) >= '0' && c <= '9') {
                    parsedLength = parsedLength * 10 + c - 48;
                    continue;
                }
                if (c == '.') {
                    this.state = State.PARSING_CONTENT;
                    break;
                }
                this.state = State.ERROR;
                throw new GuacamoleServerException("Non-numeric character in element length.");
            }
            if (parsedLength > 8192) {
                this.state = State.ERROR;
                throw new GuacamoleServerException("Instruction exceeds maximum length.");
            }
            this.elementLength = parsedLength;
        }
        if (this.state == State.PARSING_CONTENT && charsParsed + this.elementLength + 1 <= length) {
            String element = new String(chunk, offset + charsParsed, this.elementLength);
            charsParsed += this.elementLength;
            this.elementLength = 0;
            char terminator = chunk[offset + charsParsed++];
            this.elements[this.elementCount++] = element;
            if (terminator == ';') {
                this.state = State.COMPLETE;
                this.parsedInstruction = new GuacamoleInstruction(this.elements[0], Arrays.asList(this.elements).subList(1, this.elementCount));
            } else if (terminator == ',') {
                this.state = State.PARSING_LENGTH;
            } else {
                this.state = State.ERROR;
                throw new GuacamoleServerException("Element terminator of instruction was not ';' nor ','");
            }
        }
        return charsParsed;
    }

    public int append(char[] chunk) throws GuacamoleException {
        return this.append(chunk, 0, chunk.length);
    }

    @Override
    public boolean hasNext() {
        return this.state == State.COMPLETE;
    }

    @Override
    public GuacamoleInstruction next() {
        if (this.state != State.COMPLETE) {
            return null;
        }
        this.state = State.PARSING_LENGTH;
        this.elementCount = 0;
        this.elementLength = 0;
        return this.parsedInstruction;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("GuacamoleParser does not support remove().");
    }

    private static enum State {
        PARSING_LENGTH,
        PARSING_CONTENT,
        COMPLETE,
        ERROR;

    }
}

