/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.guice.bean.locators.DefaultRankingFunction;
import org.sonatype.guice.bean.locators.ImplicitBindings;
import org.sonatype.guice.bean.locators.InjectorPublisher;
import org.sonatype.guice.bean.locators.LocatedBeans;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.locators.RankedBindings;
import org.sonatype.guice.bean.locators.RankedSequence;
import org.sonatype.guice.bean.locators.RankingFunction;
import org.sonatype.guice.bean.locators.WatchedBeans;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.Soft;
import org.sonatype.guice.bean.reflect.TypeParameters;
import org.sonatype.guice.bean.reflect.Weak;
import org.sonatype.inject.BeanEntry;
import org.sonatype.inject.Mediator;

@Singleton
public final class DefaultBeanLocator
extends ReentrantLock
implements MutableBeanLocator {
    private static final long serialVersionUID = 1L;
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<TypeLiteral, RankedBindings> cachedBindings = Soft.concurrentValues((int)256, (int)8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = (RankedBindings)this.cachedBindings.get(type);
        if (null == bindings) {
            this.lock();
            try {
                bindings = new RankedBindings(type, this.publishers);
                RankedBindings oldBindings = this.cachedBindings.putIfAbsent(type, bindings);
                if (null != oldBindings) {
                    bindings = oldBindings;
                }
            }
            finally {
                this.unlock();
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeParameters.isImplicit((TypeLiteral)type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Key key, Mediator mediator, Object watcher) {
        this.lock();
        try {
            WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
            for (BindingPublisher p : this.publishers.snapshot()) {
                p.subscribe(beans);
            }
            this.cachedWatchers.put(beans, watcher);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BindingPublisher publisher, int rank) {
        this.lock();
        try {
            if (!this.publishers.contains(publisher)) {
                Logs.debug((String)"Add publisher: {}", (Object)publisher, null);
                this.publishers.insert(publisher, rank);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.add(publisher, rank);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.subscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(BindingPublisher publisher) {
        this.lock();
        try {
            if (this.publishers.remove(publisher)) {
                Logs.debug((String)"Remove publisher: {}", (Object)publisher, null);
                for (RankedBindings bindings : this.cachedBindings.values()) {
                    bindings.remove(publisher);
                }
                for (WatchedBeans beans : this.cachedWatchers.keySet()) {
                    publisher.unsubscribe(beans);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock();
        try {
            for (BindingPublisher p : this.publishers.snapshot()) {
                this.remove(p);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        RankingFunction function = (RankingFunction)injector.getInstance(RankingFunction.class);
        locator.add(new InjectorPublisher(injector, function), function.maxRank());
    }
}

