/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.Implementations;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.inject.TypeArguments;

public final class InjectorBindings
implements BindingPublisher {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private static final Binding<?>[] NO_BINDINGS = new Binding[0];
    private final Injector injector;
    private final RankingFunction function;
    private volatile Binding<?>[] wildcards;

    public InjectorBindings(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
    }

    public InjectorBindings(Injector injector) {
        this(injector, (RankingFunction)injector.getInstance(RankingFunction.class));
    }

    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        TypeLiteral<T> type = subscriber.type();
        Class clazz = type.getRawType();
        if (clazz != Object.class) {
            this.publishExactMatches(type, subscriber);
            if (clazz != type.getType()) {
                this.publishGenericMatches(type, subscriber, clazz);
            }
        }
        this.publishWildcardMatches(type, subscriber);
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        Map ourBindings = this.injector.getBindings();
        for (Binding<T> binding : subscriber.bindings()) {
            if (binding != ourBindings.get(binding.getKey())) continue;
            subscriber.remove(binding);
        }
    }

    @Override
    public int maxBindingRank() {
        return this.function.maxRank();
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorBindings) {
            return this.injector.equals(((InjectorBindings)rhs).injector);
        }
        return false;
    }

    public String toString() {
        return Logs.toString(this.injector);
    }

    private static <T, S> boolean isAssignableFrom(TypeLiteral<T> type, Binding<S> binding) {
        Class<?> implementation = Implementations.find(binding);
        if (null != implementation && type.getRawType() != implementation) {
            return TypeArguments.isAssignableFrom(type, TypeLiteral.get(implementation));
        }
        return false;
    }

    private <T> void publishExactMatches(TypeLiteral<T> type, BindingSubscriber<T> subscriber) {
        List bindings = this.injector.findBindingsByType(type);
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (null != Sources.getAnnotation(binding, Hidden.class)) continue;
            subscriber.add(binding, this.function.rank(binding));
        }
    }

    private <T, S> void publishGenericMatches(TypeLiteral<T> type, BindingSubscriber<T> subscriber, Class<S> rawType) {
        List bindings = this.injector.findBindingsByType(TypeLiteral.get(rawType));
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (null != Sources.getAnnotation(binding, Hidden.class) || !InjectorBindings.isAssignableFrom(type, binding)) continue;
            subscriber.add(binding, this.function.rank(binding));
        }
    }

    private <T> void publishWildcardMatches(TypeLiteral<T> type, BindingSubscriber<T> subscriber) {
        boolean untyped = type.getRawType() == Object.class;
        for (Binding<?> binding : this.getWildcardBindings()) {
            if (!untyped && !InjectorBindings.isAssignableFrom(type, binding)) continue;
            subscriber.add(binding, this.function.rank(binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding<?>[] getWildcardBindings() {
        if (null == this.wildcards) {
            InjectorBindings injectorBindings = this;
            synchronized (injectorBindings) {
                if (null == this.wildcards) {
                    ArrayList<Binding> visible = new ArrayList<Binding>();
                    List candidates = this.injector.findBindingsByType(OBJECT_TYPE_LITERAL);
                    int size = candidates.size();
                    for (int i = 0; i < size; ++i) {
                        Binding binding = (Binding)candidates.get(i);
                        if (null != Sources.getAnnotation(binding, Hidden.class)) continue;
                        visible.add(binding);
                    }
                    this.wildcards = visible.isEmpty() ? NO_BINDINGS : visible.toArray(new Binding[visible.size()]);
                }
            }
        }
        return this.wildcards;
    }
}

