/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.binders;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.guice.bean.locators.EntryListAdapter;
import org.sonatype.guice.bean.locators.EntryMapAdapter;
import org.sonatype.guice.bean.reflect.BeanProperty;
import org.sonatype.guice.plexus.config.Hints;
import org.sonatype.guice.plexus.config.PlexusBeanLocator;
import org.sonatype.guice.plexus.config.Roles;

final class PlexusRequirements {
    private final Provider<PlexusBeanLocator> locatorProvider;

    PlexusRequirements(TypeEncounter<?> encounter) {
        this.locatorProvider = encounter.getProvider(PlexusBeanLocator.class);
    }

    public <T> Provider<T> lookup(Requirement requirement, final BeanProperty<T> property) {
        try {
            TypeLiteral expectedType = property.getType();
            TypeLiteral<?> roleType = Roles.roleType(requirement, expectedType);
            Class rawType = expectedType.getRawType();
            String[] hints = Hints.canonicalHints(requirement);
            if (Map.class == rawType) {
                return new RequirementMapProvider(this.locatorProvider, roleType, hints);
            }
            if (List.class == rawType) {
                return new RequirementListProvider(this.locatorProvider, roleType, hints);
            }
            return new RequirementProvider(this.locatorProvider, roleType, hints);
        }
        catch (RuntimeException e) {
            return new Provider<T>(){

                public T get() {
                    throw new ProvisionException("Error in requirement: " + property, (Throwable)e);
                }
            };
        }
    }

    private static final class RequirementProvider<T>
    extends AbstractRequirementProvider<T, T> {
        RequirementProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        public T get() {
            Iterator i = this.locate().iterator();
            if (i.hasNext()) {
                return i.next().getValue();
            }
            return Roles.throwMissingComponentException(this.type, null);
        }
    }

    private static final class RequirementListProvider<T>
    extends AbstractRequirementProvider<List<T>, T> {
        RequirementListProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        public List<T> get() {
            return new EntryListAdapter(this.locate());
        }
    }

    private static final class RequirementMapProvider<T>
    extends AbstractRequirementProvider<Map<String, T>, T> {
        RequirementMapProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        public Map<String, T> get() {
            return new EntryMapAdapter(this.locate());
        }
    }

    private static abstract class AbstractRequirementProvider<S, T>
    implements Provider<S> {
        private final Provider<PlexusBeanLocator> locatorProvider;
        final TypeLiteral<T> type;
        private final String[] hints;

        AbstractRequirementProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            this.locatorProvider = locatorProvider;
            this.type = type;
            this.hints = hints;
        }

        final Iterable<? extends Map.Entry<String, T>> locate() {
            return ((PlexusBeanLocator)this.locatorProvider.get()).locate(this.type, this.hints);
        }
    }
}

