/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.NamedClass;
import org.sonatype.guice.bean.reflect.ResourceEnumeration;

public final class BundleClassSpace
implements ClassSpace {
    private static final URL[] NO_URLS = new URL[0];
    private static final Enumeration<URL> NO_ENTRIES = Collections.enumeration(Collections.emptySet());
    private final Bundle bundle;
    private URL[] classPath;

    public BundleClassSpace(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.bundle.loadClass(name);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public URL getResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        try {
            Enumeration<URL> resources = this.bundle.getResources(name);
            return null != resources ? resources : NO_ENTRIES;
        }
        catch (IOException e) {
            return NO_ENTRIES;
        }
    }

    @Override
    public synchronized Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        if (null == this.classPath) {
            this.classPath = BundleClassSpace.getBundleClassPath(this.bundle);
        }
        Enumeration<URL> entries = this.bundle.findEntries(null != path ? path : "/", glob, recurse);
        if (this.classPath.length > 0) {
            return new ChainedEnumeration<URL>(entries, new ResourceEnumeration(path, glob, recurse, this.classPath));
        }
        return null != entries ? entries : NO_ENTRIES;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BundleClassSpace) {
            return this.bundle.equals(((BundleClassSpace)rhs).bundle);
        }
        return false;
    }

    public String toString() {
        return this.bundle.toString();
    }

    private static URL[] getBundleClassPath(Bundle bundle) {
        String path = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (null == path) {
            return NO_URLS;
        }
        ArrayList<URL> classPath = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        visited.add(".");
        for (String entry : path.trim().split("\\s*,\\s*")) {
            URL url;
            if (!visited.add(entry) || null == (url = bundle.getEntry(entry))) continue;
            classPath.add(url);
        }
        return classPath.isEmpty() ? NO_URLS : classPath.toArray(new URL[classPath.size()]);
    }

    private static final class ChainedEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T>[] enumerations;
        private Enumeration<T> currentEnumeration;
        private T nextElement;
        private int index;

        ChainedEnumeration(Enumeration<T> ... enumerations) {
            this.enumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (null == this.nextElement) {
                if (null != this.currentEnumeration && this.currentEnumeration.hasMoreElements()) {
                    this.nextElement = this.currentEnumeration.nextElement();
                    continue;
                }
                if (this.index < this.enumerations.length) {
                    this.currentEnumeration = this.enumerations[this.index++];
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                T element = this.nextElement;
                this.nextElement = null;
                return element;
            }
            throw new NoSuchElementException();
        }
    }
}

