/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

final class FileEntryIterator
implements Iterator<String> {
    private final String rootPath;
    private final LinkedList<String> entryNames = new LinkedList();
    private final boolean recurse;

    FileEntryIterator(URL url, String subPath, boolean recurse) {
        this.rootPath = FileEntryIterator.normalizePath(FileEntryIterator.toFile(url).getAbsoluteFile());
        this.recurse = recurse;
        this.appendEntries(subPath);
    }

    @Override
    public boolean hasNext() {
        return this.entryNames.size() > 0;
    }

    @Override
    public String next() {
        String name = this.entryNames.removeFirst();
        if (this.recurse && name.endsWith("/")) {
            this.appendEntries(name);
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static File toFile(URL url) {
        StringBuilder buf = new StringBuilder();
        String path = url.getPath();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if ('/' == c) {
                buf.append(File.separatorChar);
                continue;
            }
            if ('%' == c && i < length - 2) {
                int hi = Character.digit(path.charAt(i + 1), 16);
                int lo = Character.digit(path.charAt(i + 2), 16);
                if (hi >= 0 && lo >= 0) {
                    buf.append((char)(hi << 4 | lo));
                    i += 2;
                    continue;
                }
                buf.append('%');
                continue;
            }
            buf.append(c);
        }
        return new File(buf.toString());
    }

    private void appendEntries(String subPath) {
        File[] listing = new File(this.rootPath + subPath).listFiles();
        if (null != listing) {
            for (File f : listing) {
                this.entryNames.add(FileEntryIterator.normalizePath(f).substring(this.rootPath.length()));
            }
        }
    }

    private static String normalizePath(File file) {
        return file.toURI().getPath();
    }
}

