/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.protocol;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GuacamoleConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String connectionID;
    private String protocol;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public GuacamoleConfiguration() {
    }

    public GuacamoleConfiguration(GuacamoleConfiguration config) {
        this.protocol = config.getProtocol();
        this.connectionID = config.getConnectionID();
        for (String name : config.getParameterNames()) {
            this.parameters.put(name, config.getParameter(name));
        }
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void unsetParameter(String name) {
        this.parameters.remove(name);
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }
}

