/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GuacamoleInstruction {
    private String opcode;
    private List<String> args;

    public GuacamoleInstruction(String opcode, String ... args) {
        this.opcode = opcode;
        this.args = Collections.unmodifiableList(Arrays.asList(args));
    }

    public GuacamoleInstruction(String opcode, List<String> args) {
        this.opcode = opcode;
        this.args = Collections.unmodifiableList(args);
    }

    public String getOpcode() {
        return this.opcode;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.opcode.length());
        buff.append('.');
        buff.append(this.opcode);
        for (String value : this.args) {
            buff.append(',');
            buff.append(value.length());
            buff.append('.');
            buff.append(value);
        }
        buff.append(';');
        return buff.toString();
    }
}

