/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.net.auth.simple;

import java.util.Map;
import java.util.UUID;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.net.auth.AbstractAuthenticatedUser;
import org.glyptodon.guacamole.net.auth.AuthenticatedUser;
import org.glyptodon.guacamole.net.auth.AuthenticationProvider;
import org.glyptodon.guacamole.net.auth.Credentials;
import org.glyptodon.guacamole.net.auth.UserContext;
import org.glyptodon.guacamole.net.auth.simple.SimpleUserContext;
import org.glyptodon.guacamole.protocol.GuacamoleConfiguration;
import org.glyptodon.guacamole.token.StandardTokens;
import org.glyptodon.guacamole.token.TokenFilter;

public abstract class SimpleAuthenticationProvider
implements AuthenticationProvider {
    public abstract Map<String, GuacamoleConfiguration> getAuthorizedConfigurations(Credentials var1) throws GuacamoleException;

    private Map<String, GuacamoleConfiguration> getFilteredAuthorizedConfigurations(Credentials credentials) throws GuacamoleException {
        Map<String, GuacamoleConfiguration> configs = this.getAuthorizedConfigurations(credentials);
        if (configs == null) {
            return null;
        }
        TokenFilter tokenFilter = new TokenFilter();
        StandardTokens.addStandardTokens(tokenFilter, credentials);
        for (GuacamoleConfiguration config : configs.values()) {
            tokenFilter.filterValues(config.getParameters());
        }
        return configs;
    }

    private Map<String, GuacamoleConfiguration> getFilteredAuthorizedConfigurations(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (authenticatedUser instanceof SimpleAuthenticatedUser && authenticatedUser.getAuthenticationProvider() == this) {
            return ((SimpleAuthenticatedUser)authenticatedUser).getAuthorizedConfigurations();
        }
        return this.getFilteredAuthorizedConfigurations(authenticatedUser.getCredentials());
    }

    @Override
    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        Map<String, GuacamoleConfiguration> configs = this.getFilteredAuthorizedConfigurations(credentials);
        if (configs == null) {
            return null;
        }
        return new SimpleAuthenticatedUser(credentials, configs);
    }

    @Override
    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        Map<String, GuacamoleConfiguration> configs = this.getFilteredAuthorizedConfigurations(authenticatedUser);
        if (configs == null) {
            return null;
        }
        return new SimpleUserContext(this, authenticatedUser.getIdentifier(), configs);
    }

    @Override
    public AuthenticatedUser updateAuthenticatedUser(AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        return authenticatedUser;
    }

    @Override
    public UserContext updateUserContext(UserContext context, AuthenticatedUser authorizedUser) throws GuacamoleException {
        return context;
    }

    private class SimpleAuthenticatedUser
    extends AbstractAuthenticatedUser {
        private final Credentials credentials;
        private final Map<String, GuacamoleConfiguration> configs;

        public SimpleAuthenticatedUser(Credentials credentials, Map<String, GuacamoleConfiguration> configs) {
            this.credentials = credentials;
            this.configs = configs;
            String username = credentials.getUsername();
            if (username != null && !username.isEmpty()) {
                this.setIdentifier(username);
            } else {
                this.setIdentifier(UUID.randomUUID().toString());
            }
        }

        public Map<String, GuacamoleConfiguration> getAuthorizedConfigurations() {
            return this.configs;
        }

        @Override
        public AuthenticationProvider getAuthenticationProvider() {
            return SimpleAuthenticationProvider.this;
        }

        @Override
        public Credentials getCredentials() {
            return this.credentials;
        }
    }
}

