/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.GuacamoleServerException;
import org.glyptodon.guacamole.properties.BooleanGuacamoleProperty;
import org.glyptodon.guacamole.properties.GuacamoleHome;
import org.glyptodon.guacamole.properties.GuacamoleProperty;
import org.glyptodon.guacamole.properties.IntegerGuacamoleProperty;
import org.glyptodon.guacamole.properties.StringGuacamoleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleProperties {
    private static final Logger logger = LoggerFactory.getLogger(GuacamoleProperties.class);
    public static final StringGuacamoleProperty GUACD_HOSTNAME;
    public static final IntegerGuacamoleProperty GUACD_PORT;
    public static final BooleanGuacamoleProperty GUACD_SSL;
    private static final Properties properties;
    private static GuacamoleException exception;

    private GuacamoleProperties() {
    }

    public static <Type> Type getProperty(GuacamoleProperty<Type> property) throws GuacamoleException {
        if (exception != null) {
            throw exception;
        }
        return property.parseValue(properties.getProperty(property.getName()));
    }

    public static <Type> Type getProperty(GuacamoleProperty<Type> property, Type defaultValue) throws GuacamoleException {
        Type value = GuacamoleProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <Type> Type getRequiredProperty(GuacamoleProperty<Type> property) throws GuacamoleException {
        Type value = GuacamoleProperties.getProperty(property);
        if (value == null) {
            throw new GuacamoleServerException("Property " + property.getName() + " is required.");
        }
        return value;
    }

    static {
        logger.warn("GuacamoleProperties is deprecated. Please use Environment instead.");
        GUACD_HOSTNAME = new StringGuacamoleProperty(){

            @Override
            public String getName() {
                return "guacd-hostname";
            }
        };
        GUACD_PORT = new IntegerGuacamoleProperty(){

            @Override
            public String getName() {
                return "guacd-port";
            }
        };
        GUACD_SSL = new BooleanGuacamoleProperty(){

            @Override
            public String getName() {
                return "guacd-ssl";
            }
        };
        properties = new Properties();
        try {
            InputStream stream;
            File guacHome = GuacamoleHome.getDirectory();
            if (!guacHome.isDirectory()) {
                stream = GuacamoleProperties.class.getResourceAsStream("/guacamole.properties");
                if (stream == null) {
                    throw new IOException("guacamole.properties not loaded from " + guacHome + " (not a directory), and guacamole.properties could not be found as a resource in the classpath.");
                }
            } else {
                stream = new FileInputStream(new File(guacHome, "guacamole.properties"));
            }
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            exception = new GuacamoleServerException("Error reading guacamole.properties", (Throwable)e);
        }
    }
}

