/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.sonatype.guice.bean.locators.BeanCache;
import org.sonatype.guice.bean.locators.QualifyingStrategy;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.inject.BeanEntry;
import org.sonatype.inject.Mediator;

final class WatchedBeans<Q extends Annotation, T, W>
implements BindingSubscriber<T> {
    private final BeanCache<Q, T> beans = new BeanCache();
    private final Key<T> key;
    private final Mediator<Q, T, W> mediator;
    private final QualifyingStrategy strategy;
    private final Reference<W> watcherRef;

    WatchedBeans(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        this.key = key;
        this.mediator = mediator;
        this.strategy = QualifyingStrategy.selectFor(key);
        this.watcherRef = new WeakReference<W>(watcher);
    }

    @Override
    public TypeLiteral<T> type() {
        return this.key.getTypeLiteral();
    }

    @Override
    public void add(Binding<T> binding, int rank) {
        W watcher;
        Annotation qualifier = this.strategy.qualifies(this.key, binding);
        if (null != qualifier && null != (watcher = this.watcherRef.get())) {
            BeanEntry<Annotation, T> bean = this.beans.create(qualifier, binding, rank);
            try {
                this.mediator.add(bean, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable((Throwable)e);
                Logs.warn((String)("Problem adding: <> to: " + this.detail(watcher)), bean, (Object)e);
            }
        }
    }

    @Override
    public void remove(Binding<T> binding) {
        W watcher;
        BeanEntry<Q, T> bean = this.beans.remove(binding);
        if (null != bean && null != (watcher = this.watcherRef.get())) {
            try {
                this.mediator.remove(bean, watcher);
            }
            catch (Throwable e) {
                Logs.catchThrowable((Throwable)e);
                Logs.warn((String)("Problem removing: <> from: " + this.detail(watcher)), bean, (Object)e);
            }
        }
    }

    @Override
    public Iterable<Binding<T>> bindings() {
        return this.beans.bindings();
    }

    private String detail(Object watcher) {
        return Logs.identityToString((Object)watcher) + " via: " + Logs.identityToString(this.mediator);
    }
}

