/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.maven.shared.io.location.Location;

public class FileLocation
implements Location {
    private File file;
    private FileChannel channel;
    private final String specification;
    private FileInputStream stream;

    public FileLocation(File file, String specification) {
        this.file = file;
        this.specification = specification;
    }

    protected FileLocation(String specification) {
        this.specification = specification;
    }

    @Override
    public void close() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public File getFile() throws IOException {
        this.initFile();
        return this.unsafeGetFile();
    }

    protected File unsafeGetFile() {
        return this.file;
    }

    protected void initFile() throws IOException {
        if (this.file == null) {
            this.file = new File(this.specification);
        }
    }

    protected void setFile(File file) {
        if (this.channel != null) {
            throw new IllegalStateException("Location is already open; cannot setFile(..).");
        }
        this.file = file;
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public void open() throws IOException {
        if (this.stream == null) {
            this.initFile();
            this.stream = new FileInputStream(this.file);
            this.channel = this.stream.getChannel();
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        this.open();
        return this.channel.read(buffer);
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        this.open();
        return this.channel.read(ByteBuffer.wrap(buffer));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.open();
        return this.stream;
    }
}

