/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2.model;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.txw2.NameUtil;
import com.sun.tools.txw2.model.Leaf;
import com.sun.tools.txw2.model.NodeSet;
import com.sun.tools.txw2.model.Ref;
import com.sun.tools.txw2.model.Text;
import com.sun.tools.txw2.model.XmlNode;
import com.sun.tools.txw2.model.prop.ElementProp;
import com.sun.tools.txw2.model.prop.LeafElementProp;
import com.sun.tools.txw2.model.prop.Prop;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.annotation.XmlElement;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

public class Element
extends XmlNode {
    public boolean isRoot;
    private Strategy strategy;

    public Element(Locator location, QName name, Leaf leaf) {
        super(location, name, leaf);
    }

    private Strategy decideStrategy() {
        if (this.isRoot) {
            return new ToInterface();
        }
        if (this.hasOneChild() && this.leaf instanceof Ref && !((Ref)this.leaf).isInline()) {
            return new HasOneRef((Ref)this.leaf);
        }
        Set<Leaf> children = this.collectChildren();
        for (Leaf l : children) {
            if (!(l instanceof XmlNode)) continue;
            return new ToInterface();
        }
        return new DataOnly();
    }

    @Override
    void declare(NodeSet nset) {
        this.strategy = this.decideStrategy();
        this.strategy.declare(nset);
    }

    @Override
    void generate(NodeSet nset) {
        this.strategy.generate(nset);
    }

    @Override
    void generate(JDefinedClass clazz, NodeSet nset, Set<Prop> props) {
        this.strategy.generate(clazz, nset, props);
    }

    private JMethod generateMethod(JDefinedClass clazz, NodeSet nset, JType retT) {
        String methodName = NameUtil.toMethodName(this.name.getLocalPart());
        JMethod m = clazz.method(1, retT, methodName);
        JAnnotationUse a = m.annotate(XmlElement.class);
        if (!methodName.equals(this.name.getLocalPart())) {
            a.param("value", this.name.getLocalPart());
        }
        if (nset.defaultNamespace == null || !nset.defaultNamespace.equals(this.name.getNamespaceURI())) {
            a.param("ns", this.name.getNamespaceURI());
        }
        return m;
    }

    public String toString() {
        return "Element " + this.name;
    }

    private class DataOnly
    implements Strategy {
        private DataOnly() {
        }

        @Override
        public void declare(NodeSet nset) {
        }

        @Override
        public void generate(NodeSet nset) {
        }

        @Override
        public void generate(JDefinedClass clazz, NodeSet nset, Set<Prop> props) {
            HashSet<JType> types = new HashSet<JType>();
            for (Leaf l : Element.this.collectChildren()) {
                if (!(l instanceof Text)) continue;
                types.add(((Text)((Object)l)).getDatatype(nset));
            }
            for (JType t : types) {
                if (!props.add(new LeafElementProp(Element.this.name, t))) continue;
                Element.this.generateMethod(clazz, nset, (JType)(nset.opts.chainMethod ? clazz : nset.codeModel.VOID)).param(t, "value");
            }
        }
    }

    private class HasOneRef
    implements Strategy {
        private final Ref ref;

        public HasOneRef(Ref ref) {
            this.ref = ref;
        }

        @Override
        public void declare(NodeSet nset) {
        }

        @Override
        public void generate(NodeSet nset) {
        }

        @Override
        public void generate(JDefinedClass clazz, NodeSet nset, Set<Prop> props) {
            if (props.add(new ElementProp(Element.this.name, (JType)this.ref.def.clazz))) {
                Element.this.generateMethod(clazz, nset, (JType)this.ref.def.clazz);
            }
        }
    }

    private class ToInterface
    implements Strategy {
        private JDefinedClass clazz;

        private ToInterface() {
        }

        @Override
        public void declare(NodeSet nset) {
            String cname = Element.this.alternativeName != null ? Element.this.alternativeName : Element.this.name.getLocalPart();
            this.clazz = nset.createClass(cname);
            this.clazz._implements(TypedXmlWriter.class);
            this.clazz.annotate(XmlElement.class).param("value", Element.this.name.getLocalPart());
        }

        @Override
        public void generate(NodeSet nset) {
            HashSet<Prop> props = new HashSet<Prop>();
            for (Leaf l : Element.this) {
                l.generate(this.clazz, nset, props);
            }
        }

        @Override
        public void generate(JDefinedClass outer, NodeSet nset, Set<Prop> props) {
            if (props.add(new ElementProp(Element.this.name, (JType)this.clazz))) {
                Element.this.generateMethod(outer, nset, (JType)this.clazz);
            }
        }
    }

    static interface Strategy {
        public void declare(NodeSet var1);

        public void generate(NodeSet var1);

        public void generate(JDefinedClass var1, NodeSet var2, Set<Prop> var3);
    }
}

