/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import com.sun.tools.txw2.ConsoleErrorReporter;
import com.sun.tools.txw2.RELAXNGLoader;
import com.sun.tools.txw2.SchemaBuilder;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.XmlSchemaLoader;
import com.sun.tools.txw2.model.NodeSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.Parseable;
import org.kohsuke.rngom.parse.compact.CompactParseable;
import org.kohsuke.rngom.parse.xml.SAXParseable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Main {
    private final TxwOptions opts;

    public Main(TxwOptions opts) {
        this.opts = opts;
    }

    public static void main(String[] args) {
        System.exit(Main.run(args));
    }

    public static int run(String[] args) {
        Options opts = new Options();
        CmdLineParser parser = new CmdLineParser((Object)opts);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.out.println(e.getMessage());
            Main.printUsage();
            return 1;
        }
        TxwOptions topts = new TxwOptions();
        topts.errorListener = new ConsoleErrorReporter(System.out);
        if (opts.output != null) {
            try {
                topts.codeWriter = new FileCodeWriter(new File(opts.output));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                Main.printUsage();
                return 1;
            }
        } else {
            topts.codeWriter = new SingleStreamCodeWriter((OutputStream)System.out);
        }
        if (opts.chain) {
            topts.chainMethod = true;
        }
        topts._package = opts.pkg != null ? topts.codeModel._package(opts.pkg) : topts.codeModel.rootPackage();
        if (parser.getArguments().size() != 1) {
            Main.printUsage();
            return 1;
        }
        try {
            topts.source = Main.makeSourceSchema(parser, opts, topts.errorListener);
        }
        catch (MalformedURLException e) {
            System.out.println(e.getMessage());
            Main.printUsage();
            return 1;
        }
        return Main.run(topts);
    }

    private static SchemaBuilder makeSourceSchema(CmdLineParser parser, Options opts, ErrorHandler eh) throws MalformedURLException {
        File f = new File((String)opts.arguments.get(0));
        InputSource in = new InputSource(f.toURL().toExternalForm());
        if (!(opts.xsd || opts.xml || opts.compact)) {
            if (in.getSystemId().endsWith(".rnc")) {
                opts.compact = true;
            } else if (in.getSystemId().endsWith(".rng")) {
                opts.xml = true;
            } else {
                opts.xsd = true;
            }
        }
        if (opts.xsd) {
            return new XmlSchemaLoader(in);
        }
        Parseable parseable = Main.makeRELAXNGSource(opts, in, eh, f);
        return new RELAXNGLoader(parseable);
    }

    private static Parseable makeRELAXNGSource(Options opts, InputSource in, ErrorHandler eh, File f) {
        if (opts.compact) {
            return new CompactParseable(in, eh);
        }
        if (opts.xml) {
            return new SAXParseable(in, eh);
        }
        if (f.getPath().toLowerCase().endsWith("rnc")) {
            return new CompactParseable(in, eh);
        }
        return new SAXParseable(in, eh);
    }

    private static void printUsage() {
        System.out.println("Typed Xml Writer ver." + Main.getVersion());
        System.out.println("txw <schema file>\n -o <dir>   : Specify the directory to place generated source files\n -p <pkg>   : Specify the Java package to put the generated classes into\n -c         : The input schema is written in the RELAX NG compact syntax\n -x         : The input schema is written in the RELAX NG XML syntax\n -xsd       : The input schema is written in the XML SChema\n -h         : Generate code that allows method invocation chaining\n");
    }

    public static int run(TxwOptions opts) {
        return new Main(opts).run();
    }

    private int run() {
        try {
            NodeSet ns = this.opts.source.build(this.opts);
            ns.write(this.opts);
            this.opts.codeModel.build(this.opts.codeWriter);
            return 0;
        }
        catch (SAXParseException e) {
            this.opts.errorListener.error(e);
            return 1;
        }
        catch (IOException | IllegalSchemaException | SAXException e) {
            this.opts.errorListener.error(new SAXParseException(e.getMessage(), null, (Exception)e));
            return 1;
        }
    }

    public static String getVersion() {
        try {
            Properties p = new Properties();
            p.load(Main.class.getResourceAsStream("version.properties"));
            return p.get("version").toString();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    public static class Options {
        @Option(name="-o", metaVar="<dir>", usage="Specify the directory to place generated source files")
        public String output;
        @Option(name="-p", metaVar="<pkg>", usage="Specify the Java package to put the generated classes into")
        public String pkg;
        @Option(name="-c", usage="The input schema is written in the RELAX NG compact syntax")
        public boolean compact;
        @Option(name="-x", usage="The input schema is written in the RELAX NG XML syntax")
        public boolean xml;
        @Option(name="-xsd", usage="The input schema is written in the XML Schema")
        public boolean xsd;
        @Option(name="-h", usage="Generate code that allows method invocation chaining")
        public boolean chain;
        @Argument
        private List<String> arguments = new ArrayList<String>();
    }
}

