/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.bootstrap;

import java.io.IOException;
import org.apache.maven.wagon.providers.http.httpclient.ExceptionLogger;
import org.apache.maven.wagon.providers.http.httpclient.HttpServerConnection;
import org.apache.maven.wagon.providers.http.httpclient.protocol.BasicHttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpCoreContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpService;

class Worker
implements Runnable {
    private final HttpService httpservice;
    private final HttpServerConnection conn;
    private final ExceptionLogger exceptionLogger;

    Worker(HttpService httpservice, HttpServerConnection conn, ExceptionLogger exceptionLogger) {
        this.httpservice = httpservice;
        this.conn = conn;
        this.exceptionLogger = exceptionLogger;
    }

    public HttpServerConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        try {
            BasicHttpContext localContext = new BasicHttpContext();
            HttpCoreContext context = HttpCoreContext.adapt(localContext);
            while (!Thread.interrupted() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, context);
                localContext.clear();
            }
            this.conn.close();
        }
        catch (Exception ex) {
            this.exceptionLogger.log(ex);
        }
        finally {
            try {
                this.conn.shutdown();
            }
            catch (IOException ex) {
                this.exceptionLogger.log(ex);
            }
        }
    }
}

