/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xerial.snappy.BitShuffleNative;
import org.xerial.snappy.BitShuffleType;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyLoader;

public class BitShuffle {
    private static BitShuffleNative impl;

    public static int shuffle(ByteBuffer input, BitShuffleType type, ByteBuffer shuffled) throws IOException {
        int typeSize;
        if (!input.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!shuffled.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int uPos = input.position();
        int uLen = input.remaining();
        if (uLen % (typeSize = type.getTypeSize()) != 0) {
            throw new IllegalArgumentException("input length must be a multiple of the given type size: " + typeSize);
        }
        if (shuffled.remaining() < uLen) {
            throw new IllegalArgumentException("not enough space for output");
        }
        int numProcessed = impl.shuffleDirectBuffer(input, uPos, typeSize, uLen, shuffled, shuffled.position());
        assert (numProcessed == uLen);
        shuffled.limit(shuffled.position() + numProcessed);
        return numProcessed;
    }

    public static byte[] shuffle(short[] input) throws IOException {
        byte[] output = new byte[input.length * 2];
        int numProcessed = impl.shuffle(input, 0, 2, input.length * 2, output, 0);
        assert (numProcessed == input.length * 2);
        return output;
    }

    public static byte[] shuffle(int[] input) throws IOException {
        byte[] output = new byte[input.length * 4];
        int numProcessed = impl.shuffle(input, 0, 4, input.length * 4, output, 0);
        assert (numProcessed == input.length * 4);
        return output;
    }

    public static byte[] shuffle(long[] input) throws IOException {
        byte[] output = new byte[input.length * 8];
        int numProcessed = impl.shuffle(input, 0, 8, input.length * 8, output, 0);
        assert (numProcessed == input.length * 8);
        return output;
    }

    public static byte[] shuffle(float[] input) throws IOException {
        byte[] output = new byte[input.length * 4];
        int numProcessed = impl.shuffle(input, 0, 4, input.length * 4, output, 0);
        assert (numProcessed == input.length * 4);
        return output;
    }

    public static byte[] shuffle(double[] input) throws IOException {
        byte[] output = new byte[input.length * 8];
        int numProcessed = impl.shuffle(input, 0, 8, input.length * 8, output, 0);
        assert (numProcessed == input.length * 8);
        return output;
    }

    public static int unshuffle(ByteBuffer shuffled, BitShuffleType type, ByteBuffer output) throws IOException {
        int typeSize;
        if (!shuffled.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!output.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int uPos = shuffled.position();
        int uLen = shuffled.remaining();
        if (uLen % (typeSize = type.getTypeSize()) != 0) {
            throw new IllegalArgumentException("length of input shuffled data must be a multiple of the given type size: " + typeSize);
        }
        if (output.remaining() < uLen) {
            throw new IllegalArgumentException("not enough space for output");
        }
        int numProcessed = impl.unshuffleDirectBuffer(shuffled, uPos, typeSize, uLen, output, shuffled.position());
        assert (numProcessed == uLen);
        shuffled.limit(shuffled.position() + numProcessed);
        return numProcessed;
    }

    public static short[] unshuffleShortArray(byte[] input) throws IOException {
        short[] output = new short[input.length / 2];
        int numProcessed = impl.unshuffle(input, 0, 2, input.length, output, 0);
        assert (numProcessed == input.length);
        return output;
    }

    public static int[] unshuffleIntArray(byte[] input) throws IOException {
        int[] output = new int[input.length / 4];
        int numProcessed = impl.unshuffle(input, 0, 4, input.length, output, 0);
        assert (numProcessed == input.length);
        return output;
    }

    public static long[] unshuffleLongArray(byte[] input) throws IOException {
        long[] output = new long[input.length / 8];
        int numProcessed = impl.unshuffle(input, 0, 8, input.length, output, 0);
        assert (numProcessed == input.length);
        return output;
    }

    public static float[] unshuffleFloatArray(byte[] input) throws IOException {
        float[] output = new float[input.length / 4];
        int numProcessed = impl.unshuffle(input, 0, 4, input.length, output, 0);
        assert (numProcessed == input.length);
        return output;
    }

    public static double[] unshuffleDoubleArray(byte[] input) throws IOException {
        double[] output = new double[input.length / 8];
        int numProcessed = impl.unshuffle(input, 0, 8, input.length, output, 0);
        assert (numProcessed == input.length);
        return output;
    }

    static {
        try {
            impl = SnappyLoader.loadBitShuffleApi();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

