/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sonatype.guice.bean.reflect.MildConcurrentKeys;
import org.sonatype.guice.bean.reflect.MildConcurrentValues;
import org.sonatype.guice.bean.reflect.MildElements;
import org.sonatype.guice.bean.reflect.MildKeys;
import org.sonatype.guice.bean.reflect.MildValues;

public final class Soft {
    private Soft() {
    }

    public static <T> Collection<T> elements() {
        return Soft.elements(10);
    }

    public static <T> Collection<T> elements(int capacity) {
        return new MildElements(new ArrayList(capacity), true);
    }

    public static <K, V> Map<K, V> keys() {
        return Soft.keys(16);
    }

    public static <K, V> Map<K, V> keys(int capacity) {
        return new MildKeys(new HashMap(capacity), true);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys() {
        return Soft.concurrentKeys(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys(int capacity, int concurrency) {
        return new MildConcurrentKeys(new ConcurrentHashMap(capacity, 0.75f, concurrency), true);
    }

    public static <K, V> Map<K, V> values() {
        return Soft.values(16);
    }

    public static <K, V> Map<K, V> values(int capacity) {
        return new MildValues(new HashMap(capacity), true);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues() {
        return Soft.concurrentValues(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues(int capacity, int concurrency) {
        return new MildConcurrentValues(new ConcurrentHashMap(capacity, 0.75f, concurrency), true);
    }
}

