/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.guacamole.net.auth.noauth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.sourceforge.guacamole.net.auth.noauth.NoAuthConfigContentHandler;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.GuacamoleServerException;
import org.glyptodon.guacamole.environment.Environment;
import org.glyptodon.guacamole.environment.LocalEnvironment;
import org.glyptodon.guacamole.net.auth.Credentials;
import org.glyptodon.guacamole.net.auth.simple.SimpleAuthenticationProvider;
import org.glyptodon.guacamole.properties.FileGuacamoleProperty;
import org.glyptodon.guacamole.properties.GuacamoleProperty;
import org.glyptodon.guacamole.protocol.GuacamoleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class NoAuthenticationProvider
extends SimpleAuthenticationProvider {
    private Logger logger = LoggerFactory.getLogger(NoAuthenticationProvider.class);
    private Map<String, GuacamoleConfiguration> configs;
    private long configTime;
    private final Environment environment = new LocalEnvironment();
    public static final FileGuacamoleProperty NOAUTH_CONFIG = new FileGuacamoleProperty(){

        public String getName() {
            return "noauth-config";
        }
    };
    public static final String DEFAULT_NOAUTH_CONFIG = "noauth-config.xml";

    public String getIdentifier() {
        return "noauth";
    }

    private File getConfigurationFile() throws GuacamoleException {
        File configFile = (File)this.environment.getProperty((GuacamoleProperty)NOAUTH_CONFIG);
        if (configFile == null) {
            configFile = new File(this.environment.getGuacamoleHome(), DEFAULT_NOAUTH_CONFIG);
        }
        return configFile;
    }

    public synchronized void init() throws GuacamoleException {
        File configFile = this.getConfigurationFile();
        this.logger.debug("Reading configuration file: \"{}\"", (Object)configFile);
        try {
            NoAuthConfigContentHandler contentHandler = new NoAuthConfigContentHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(contentHandler);
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            parser.parse(new InputSource(reader));
            ((Reader)reader).close();
            this.configTime = configFile.lastModified();
            this.configs = contentHandler.getConfigs();
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Error reading configuration file.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new GuacamoleServerException("Error parsing XML file.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GuacamoleConfiguration> getAuthorizedConfigurations(Credentials credentials) throws GuacamoleException {
        File configFile = this.getConfigurationFile();
        if (configFile.exists() && this.configTime < configFile.lastModified()) {
            NoAuthenticationProvider noAuthenticationProvider = this;
            synchronized (noAuthenticationProvider) {
                if (configFile.exists() && this.configTime < configFile.lastModified()) {
                    this.logger.debug("Configuration file \"{}\" has been modified.", (Object)configFile);
                    this.init();
                }
            }
        }
        if (this.configs == null) {
            throw new GuacamoleServerException("Configuration could not be read.");
        }
        return this.configs;
    }
}

