/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth;

import java.util.Collections;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.DelegatingUserContext;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.TokenInjectingConnection;
import org.apache.guacamole.net.auth.TokenInjectingConnectionGroup;
import org.apache.guacamole.net.auth.UserContext;

public class TokenInjectingUserContext
extends DelegatingUserContext {
    private final Map<String, String> tokens;

    public TokenInjectingUserContext(UserContext userContext, Map<String, String> tokens) {
        super(userContext);
        this.tokens = tokens;
    }

    public TokenInjectingUserContext(UserContext userContext) {
        this(userContext, Collections.emptyMap());
    }

    protected Map<String, String> getTokens(Connection connection) {
        return this.tokens;
    }

    protected Map<String, String> getTokens(ConnectionGroup connectionGroup) {
        return this.tokens;
    }

    @Override
    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return new DecoratingDirectory<ConnectionGroup>(super.getConnectionGroupDirectory()){

            @Override
            protected ConnectionGroup decorate(ConnectionGroup object) throws GuacamoleException {
                return new TokenInjectingConnectionGroup(object, TokenInjectingUserContext.this.getTokens(object));
            }

            @Override
            protected ConnectionGroup undecorate(ConnectionGroup object) throws GuacamoleException {
                return ((TokenInjectingConnectionGroup)object).getDelegateConnectionGroup();
            }
        };
    }

    @Override
    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return new DecoratingDirectory<Connection>(super.getConnectionDirectory()){

            @Override
            protected Connection decorate(Connection object) throws GuacamoleException {
                return new TokenInjectingConnection(object, TokenInjectingUserContext.this.getTokens(object));
            }

            @Override
            protected Connection undecorate(Connection object) throws GuacamoleException {
                return ((TokenInjectingConnection)object).getDelegateConnection();
            }
        };
    }
}

