/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.InetGuacamoleSocket;
import org.apache.guacamole.net.SSLGuacamoleSocket;
import org.apache.guacamole.net.SimpleGuacamoleTunnel;
import org.apache.guacamole.net.auth.AbstractConnection;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.net.auth.simple.SimpleActivityRecordSet;
import org.apache.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.TokenFilter;

public class SimpleConnection
extends AbstractConnection {
    private GuacamoleConfiguration fullConfig;
    private final boolean interpretTokens;
    private final ThreadLocal<Map<String, String>> currentTokens = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };

    public SimpleConnection() {
        this(false);
    }

    public SimpleConnection(boolean interpretTokens) {
        this.interpretTokens = interpretTokens;
    }

    public SimpleConnection(String name, String identifier, GuacamoleConfiguration config) {
        this(name, identifier, config, false);
    }

    public SimpleConnection(String name, String identifier, GuacamoleConfiguration config, boolean interpretTokens) {
        super.setName(name);
        super.setIdentifier(identifier);
        super.setConfiguration(config);
        this.fullConfig = config;
        this.interpretTokens = interpretTokens;
    }

    protected GuacamoleConfiguration getFullConfiguration() {
        return this.fullConfig;
    }

    @Override
    public void setConfiguration(GuacamoleConfiguration config) {
        super.setConfiguration(config);
        this.fullConfig = config;
    }

    @Override
    public int getActiveConnections() {
        return 0;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    @Deprecated
    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        ConfiguredGuacamoleSocket socket;
        LocalEnvironment environment = new LocalEnvironment();
        GuacamoleProxyConfiguration proxyConfig = environment.getDefaultGuacamoleProxyConfiguration();
        String hostname = proxyConfig.getHostname();
        int port = proxyConfig.getPort();
        GuacamoleConfiguration filteredConfig = new GuacamoleConfiguration(this.getFullConfiguration());
        new TokenFilter(this.currentTokens.get()).filterValues(filteredConfig.getParameters());
        switch (proxyConfig.getEncryptionMethod()) {
            case SSL: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new SSLGuacamoleSocket(hostname, port), filteredConfig, info);
                break;
            }
            case NONE: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new InetGuacamoleSocket(hostname, port), filteredConfig, info);
                break;
            }
            default: {
                throw new GuacamoleServerException("Unimplemented encryption method.");
            }
        }
        return new SimpleGuacamoleTunnel((GuacamoleSocket)socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        try {
            if (this.interpretTokens) {
                this.currentTokens.set(tokens);
            }
            GuacamoleTunnel guacamoleTunnel = this.connect(info);
            return guacamoleTunnel;
        }
        finally {
            this.currentTokens.remove();
        }
    }

    @Override
    public Date getLastActive() {
        return null;
    }

    @Override
    public ActivityRecordSet<ConnectionRecord> getConnectionHistory() throws GuacamoleException {
        return new SimpleActivityRecordSet<ConnectionRecord>();
    }
}

