/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;

public class SimpleDirectory<ObjectType extends Identifiable>
implements Directory<ObjectType> {
    private Map<String, ObjectType> objects = Collections.emptyMap();

    public SimpleDirectory() {
    }

    public SimpleDirectory(Map<String, ObjectType> objects) {
        this.objects = objects;
    }

    public SimpleDirectory(ObjectType object) {
        this(Collections.singletonMap(object.getIdentifier(), object));
    }

    @SafeVarargs
    public SimpleDirectory(ObjectType ... objects) {
        this((Collection<ObjectType>)Arrays.asList(objects));
    }

    public SimpleDirectory(Collection<ObjectType> objects) {
        this.objects = new HashMap<String, ObjectType>(objects.size());
        for (Identifiable object : objects) {
            this.objects.put(object.getIdentifier(), object);
        }
    }

    protected void setObjects(Map<String, ObjectType> objects) {
        this.objects = objects;
    }

    protected Map<String, ObjectType> getObjects() {
        return this.objects;
    }

    @Override
    public ObjectType get(String identifier) throws GuacamoleException {
        return (ObjectType)((Identifiable)this.objects.get(identifier));
    }

    @Override
    public Collection<ObjectType> getAll(Collection<String> identifiers) throws GuacamoleException {
        ArrayList<Identifiable> foundObjects = new ArrayList<Identifiable>(identifiers.size());
        for (String identifier : identifiers) {
            Identifiable object = (Identifiable)this.objects.get(identifier);
            if (object == null) continue;
            foundObjects.add(object);
        }
        return foundObjects;
    }

    @Override
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.objects.keySet();
    }

    @Override
    public void add(ObjectType connection) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void update(ObjectType connection) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void remove(String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

