/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;

public class SimpleObjectPermissionSet
implements ObjectPermissionSet {
    private Set<ObjectPermission> permissions = Collections.emptySet();

    public SimpleObjectPermissionSet() {
    }

    private static Set<ObjectPermission> createPermissions(Collection<String> identifiers, Collection<ObjectPermission.Type> types) {
        HashSet<ObjectPermission> permissions = new HashSet<ObjectPermission>(identifiers.size());
        types.forEach(type -> identifiers.forEach(identifier -> permissions.add(new ObjectPermission((ObjectPermission.Type)((Object)type), (String)identifier))));
        return permissions;
    }

    public SimpleObjectPermissionSet(Collection<String> identifiers, Collection<ObjectPermission.Type> types) {
        this(SimpleObjectPermissionSet.createPermissions(identifiers, types));
    }

    public SimpleObjectPermissionSet(Collection<String> identifiers) {
        this(identifiers, Collections.singletonList(ObjectPermission.Type.READ));
    }

    public SimpleObjectPermissionSet(Set<ObjectPermission> permissions) {
        this.permissions = permissions;
    }

    protected void setPermissions(Set<ObjectPermission> permissions) {
        this.permissions = permissions;
    }

    @Override
    public Set<ObjectPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean hasPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        ObjectPermission objectPermission = new ObjectPermission(permission, identifier);
        return this.permissions.contains(objectPermission);
    }

    @Override
    public void addPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void removePermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public Collection<String> getAccessibleObjects(Collection<ObjectPermission.Type> permissionTypes, Collection<String> identifiers) throws GuacamoleException {
        ArrayList<String> accessibleObjects = new ArrayList<String>(this.permissions.size());
        block0: for (String identifier : identifiers) {
            for (ObjectPermission.Type permissionType : permissionTypes) {
                ObjectPermission permission = new ObjectPermission(permissionType, identifier);
                if (!this.permissions.contains(permission)) continue;
                accessibleObjects.add(identifier);
                continue block0;
            }
        }
        return accessibleObjects;
    }

    @Override
    public void addPermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void removePermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

