/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.xml;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.guacamole.xml.TagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentHandler
extends DefaultHandler {
    private String rootElementName;
    private TagHandler root;
    private Deque<DocumentHandlerState> stack = new LinkedList<DocumentHandlerState>();

    public DocumentHandler(String rootElementName, TagHandler root) {
        this.root = root;
        this.rootElementName = rootElementName;
    }

    private DocumentHandlerState getCurrentState() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.getLast();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        TagHandler handler;
        String name = localName.isEmpty() ? qName : localName;
        DocumentHandlerState current = this.getCurrentState();
        if (current == null) {
            if (!name.equals(this.rootElementName)) {
                throw new SAXException("Root element must be '" + this.rootElementName + "'");
            }
            handler = this.root;
        } else {
            TagHandler parent_handler = current.getTagHandler();
            handler = parent_handler.childElement(name);
        }
        if (handler == null) {
            throw new SAXException("Unexpected element: '" + name + "'");
        }
        handler.init(attributes);
        this.stack.addLast(new DocumentHandlerState(handler));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        DocumentHandlerState completed = this.stack.removeLast();
        completed.getTagHandler().complete(completed.getTextContent().toString());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        DocumentHandlerState current = this.getCurrentState();
        if (current == null) {
            throw new SAXException("Character data not allowed outside XML document.");
        }
        current.getTextContent().append(ch, start, length);
    }

    private static class DocumentHandlerState {
        private StringBuilder textContent = new StringBuilder();
        private TagHandler tagHandler;

        public DocumentHandlerState(TagHandler tagHandler) {
            this.tagHandler = tagHandler;
        }

        public StringBuilder getTextContent() {
            return this.textContent;
        }

        public TagHandler getTagHandler() {
            return this.tagHandler;
        }
    }
}

