/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.plexus.config.PlexusBean;
import org.sonatype.guice.plexus.config.PlexusBeanLocator;
import org.sonatype.guice.plexus.locators.DefaultPlexusBeans;
import org.sonatype.guice.plexus.locators.HintedPlexusBeans;
import org.sonatype.guice.plexus.locators.RealmFilter;

@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private static final String REALM_VISIBILITY = "realm";
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, REALM_VISIBILITY);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key key = hints.length == 1 ? Key.get(role, (Annotation)Names.named((String)hints[0])) : Key.get(role, Named.class);
        RealmFilter beans = this.beanLocator.locate(key);
        if (REALM_VISIBILITY.equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilter(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans<T>(beans, role, hints);
    }
}

