/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValue = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValue == null) {
            retValue = this.fromChildren(configuration, expressionEvaluator, listener);
        }
        return retValue;
    }

    private Object fromChildren(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        String element = configuration.getName();
        Properties retValue = new Properties();
        int n = configuration.getChildCount();
        for (int i = 0; i < n; ++i) {
            PlexusConfiguration value;
            Object name;
            PlexusConfiguration childConfiguration = configuration.getChild(i);
            if ("property".equals(childConfiguration.getName()) && childConfiguration.getChildCount() > 0) {
                name = this.fromExpression(childConfiguration.getChild("name"), expressionEvaluator);
                value = childConfiguration.getChild("value");
            } else {
                if (childConfiguration.getChildCount() > 0) continue;
                name = childConfiguration.getName();
                value = childConfiguration;
            }
            this.addEntry(retValue, element, name, value, expressionEvaluator);
        }
        return retValue;
    }

    private void addEntry(Properties properties, String element, Object name, PlexusConfiguration valueConfiguration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        String key;
        String string = key = name != null ? name.toString() : null;
        if (key == null) {
            String msg = "Missing name for property of configuration element '" + element + "'";
            throw new ComponentConfigurationException(msg);
        }
        Object value = this.fromExpression(valueConfiguration, expressionEvaluator);
        if (value == null) {
            properties.setProperty(key, "");
        } else {
            properties.setProperty(key, value.toString());
        }
    }
}

