/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.scanners.ClassFinder;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.asm.ClassReader;
import org.sonatype.guice.bean.scanners.asm.ClassVisitor;

public final class ClassSpaceScanner {
    private static final int ASM_FLAGS = 7;
    private final ClassFinder finder;
    private final ClassSpace space;

    public ClassSpaceScanner(ClassSpace space) {
        this(null, space);
    }

    public ClassSpaceScanner(ClassFinder finder, ClassSpace space) {
        this.finder = finder;
        this.space = space;
    }

    public void accept(ClassSpaceVisitor visitor) {
        Enumeration result;
        visitor.visit(this.space);
        Enumeration enumeration = result = null != this.finder ? this.finder.findClasses(this.space) : this.space.findEntries(null, "*.class", true);
        while (result.hasMoreElements()) {
            URL url = (URL)result.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (null == cv) continue;
            ClassSpaceScanner.accept(cv, url);
        }
        visitor.visitEnd();
    }

    public static void accept(ClassVisitor visitor, URL url) {
        if (null == url) {
            return;
        }
        try (InputStream in2 = url.openStream();){
            new ClassReader(in2).accept(visitor, 7);
        }
        catch (ArrayIndexOutOfBoundsException in2) {
        }
        catch (Exception e) {
            Logs.debug((String)"Problem scanning: {}", (Object)url, (Object)e);
        }
    }

    public static boolean verify(ClassSpace space, Class<?> ... specification) {
        for (Class<?> expectedClazz : specification) {
            try {
                Class spaceClazz = space.loadClass(expectedClazz.getName());
                if (spaceClazz == expectedClazz) continue;
                Logs.warn((String)"Inconsistent ClassLoader for: {} in: {}", expectedClazz, (Object)space);
                Logs.warn((String)"Expected: {} saw: {}", (Object)expectedClazz.getClassLoader(), (Object)spaceClazz.getClassLoader());
            }
            catch (TypeNotPresentException e) {
                if (!expectedClazz.isAnnotation()) continue;
                Logs.debug((String)"Potential problem: {} is not visible from: {}", expectedClazz, (Object)space);
            }
        }
        return true;
    }
}

