/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleTable;

public class AtkTable {
    AccessibleContext ac;
    AccessibleTable acc_table;

    public AtkTable(AccessibleContext accessibleContext) {
        this.ac = accessibleContext;
        this.acc_table = accessibleContext.getAccessibleTable();
    }

    public AccessibleContext ref_at(int n, int n2) {
        Accessible accessible = this.acc_table.getAccessibleAt(n, n2);
        if (accessible != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public int get_column_at_index(int n) {
        int n2 = -1;
        if (this.acc_table instanceof AccessibleExtendedTable) {
            n2 = ((AccessibleExtendedTable)this.acc_table).getAccessibleColumn(n);
        }
        return n2;
    }

    public int get_row_at_index(int n) {
        int n2 = -1;
        if (this.acc_table instanceof AccessibleExtendedTable) {
            n2 = ((AccessibleExtendedTable)this.acc_table).getAccessibleRow(n);
        }
        return n2;
    }

    public int get_n_columns() {
        return this.acc_table.getAccessibleColumnCount();
    }

    public int get_n_rows() {
        return this.acc_table.getAccessibleRowCount();
    }

    public int get_column_extent_at(int n, int n2) {
        return this.acc_table.getAccessibleColumnExtentAt(n, n2);
    }

    public int get_row_extent_at(int n, int n2) {
        return this.acc_table.getAccessibleRowExtentAt(n, n2);
    }

    public AccessibleContext get_caption() {
        Accessible accessible = this.acc_table.getAccessibleCaption();
        if (accessible != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public void setCaption(Accessible accessible) {
        this.acc_table.setAccessibleCaption(accessible);
    }

    public String get_column_description(int n) {
        AccessibleContext accessibleContext;
        Accessible accessible = this.acc_table.getAccessibleColumnDescription(n);
        if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
            return accessibleContext.getAccessibleDescription();
        }
        return "";
    }

    public void setColumnDescription(int n, String string) {
        Accessible accessible = this.acc_table.getAccessibleColumnDescription(n);
        if (string.equals(accessible.toString()) && accessible != null) {
            this.acc_table.setAccessibleColumnDescription(n, accessible);
        }
    }

    public String get_row_description(int n) {
        AccessibleContext accessibleContext;
        Accessible accessible = this.acc_table.getAccessibleRowDescription(n);
        if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
            return accessibleContext.getAccessibleDescription();
        }
        return "";
    }

    public void setRowDescription(int n, String string) {
        Accessible accessible = this.acc_table.getAccessibleRowDescription(n);
        if (string.equals(accessible.toString()) && accessible != null) {
            this.acc_table.setAccessibleRowDescription(n, accessible);
        }
    }

    public AccessibleContext get_column_header(int n) {
        Accessible accessible;
        AccessibleTable accessibleTable = this.acc_table.getAccessibleColumnHeader();
        if (accessibleTable != null && (accessible = accessibleTable.getAccessibleAt(0, n)) != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public void setColumnHeader(int n, AccessibleTable accessibleTable) {
        this.acc_table.setAccessibleColumnHeader(accessibleTable);
    }

    public AccessibleContext get_row_header(int n) {
        Accessible accessible;
        AccessibleTable accessibleTable = this.acc_table.getAccessibleRowHeader();
        if (accessibleTable != null && (accessible = accessibleTable.getAccessibleAt(n, 0)) != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public void setRowHeader(int n, AccessibleTable accessibleTable) {
        this.acc_table.setAccessibleRowHeader(accessibleTable);
    }

    public AccessibleContext get_summary() {
        Accessible accessible = this.acc_table.getAccessibleSummary();
        if (accessible != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public void setSummary(Accessible accessible) {
        this.acc_table.setAccessibleSummary(accessible);
    }

    public int[] get_selected_columns() {
        return this.acc_table.getSelectedAccessibleColumns();
    }

    public int[] get_selected_rows() {
        return this.acc_table.getSelectedAccessibleRows();
    }

    public boolean is_column_selected(int n) {
        return this.acc_table.isAccessibleColumnSelected(n);
    }

    public boolean is_row_selected(int n) {
        return this.acc_table.isAccessibleRowSelected(n);
    }

    public boolean is_selected(int n, int n2) {
        return this.acc_table.isAccessibleSelected(n, n2);
    }

    public boolean addColumnSelection(int n) {
        return false;
    }

    public boolean addRowSelection(int n) {
        return false;
    }

    public boolean remove_column_selection(int n) {
        return false;
    }

    public boolean remove_row_selection(int n) {
        return false;
    }
}

