/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.locators.ProviderIterableAdapter;
import org.sonatype.guice.bean.reflect.TypeParameters;

class AbstractBeans<K extends Annotation, V> {
    @Inject
    private BeanLocator locator;
    private final Key<?> key;
    private final boolean isProvider;

    AbstractBeans(Key<V> key) {
        TypeLiteral type = key.getTypeLiteral();
        Class clazz = type.getRawType();
        this.isProvider = Provider.class == clazz || com.google.inject.Provider.class == clazz;
        this.key = this.isProvider ? key.ofType(TypeParameters.get((TypeLiteral)type, (int)0)) : key;
    }

    protected final Iterable<Map.Entry<K, V>> beans() {
        Iterable beans = this.locator.locate(this.key);
        return this.isProvider ? new ProviderIterableAdapter(beans) : beans;
    }
}

