/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementsImpl9;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PackageElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ElementsImpl
implements Elements {
    private static final Pattern INITIAL_DELIMITER = Pattern.compile("^\\s*/\\*+");
    protected final BaseProcessingEnvImpl _env;

    protected ElementsImpl(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
    }

    public static ElementsImpl create(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        return SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) <= 0 ? new ElementsImpl(baseProcessingEnvImpl) : new ElementsImpl9(baseProcessingEnvImpl);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element element) {
        if (element.getKind() == ElementKind.CLASS && element instanceof TypeElementImpl) {
            ArrayList<AnnotationBinding> arrayList = new ArrayList<AnnotationBinding>();
            HashSet<ReferenceBinding> hashSet = new HashSet<ReferenceBinding>();
            boolean bl = false;
            for (ReferenceBinding referenceBinding = (ReferenceBinding)((TypeElementImpl)element)._binding; null != referenceBinding; referenceBinding = referenceBinding.superclass()) {
                if (referenceBinding instanceof ParameterizedTypeBinding) {
                    referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
                }
                for (AnnotationBinding annotationBinding : Factory.getPackedAnnotationBindings(referenceBinding.getAnnotations())) {
                    if (annotationBinding == null) continue;
                    ReferenceBinding referenceBinding2 = annotationBinding.getAnnotationType();
                    if (bl && (referenceBinding2.getAnnotationTagBits() & 0x1000000000000L) == 0L || hashSet.contains(referenceBinding2)) continue;
                    hashSet.add(referenceBinding2);
                    arrayList.add(annotationBinding);
                }
                bl = true;
            }
            AnnotationBinding[] annotationBindingArray = new ArrayList(arrayList.size());
            for (AnnotationBinding annotationBinding : arrayList) {
                annotationBindingArray.add(this._env.getFactory().newAnnotationMirror(annotationBinding));
            }
            return Collections.unmodifiableList(annotationBindingArray);
        }
        return element.getAnnotationMirrors();
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement typeElement) {
        AbstractCollection abstractCollection;
        if (null == typeElement || !(typeElement instanceof TypeElementImpl)) {
            return Collections.emptyList();
        }
        HashMap<String, ReferenceBinding> hashMap = new HashMap<String, ReferenceBinding>();
        ArrayList<FieldBinding> arrayList = new ArrayList<FieldBinding>();
        HashMap<String, Set<MethodBinding>> hashMap2 = new HashMap<String, Set<MethodBinding>>();
        LinkedHashSet<ReferenceBinding> linkedHashSet = new LinkedHashSet<ReferenceBinding>();
        boolean bl = true;
        for (ReferenceBinding referenceBinding = (ReferenceBinding)((TypeElementImpl)typeElement)._binding; null != referenceBinding; referenceBinding = referenceBinding.superclass()) {
            this.addMembers(referenceBinding, bl, hashMap, arrayList, hashMap2);
            abstractCollection = new LinkedHashSet();
            this.collectSuperInterfaces(referenceBinding, (Set<ReferenceBinding>)linkedHashSet, (Set<ReferenceBinding>)((Object)abstractCollection));
            for (ReferenceBinding object : abstractCollection) {
                this.addMembers(object, false, hashMap, arrayList, hashMap2);
            }
            linkedHashSet.addAll(abstractCollection);
            bl = false;
        }
        abstractCollection = new ArrayList();
        for (ReferenceBinding referenceBinding : hashMap.values()) {
            abstractCollection.add(this._env.getFactory().newElement(referenceBinding));
        }
        for (FieldBinding fieldBinding : arrayList) {
            abstractCollection.add(this._env.getFactory().newElement(fieldBinding));
        }
        for (Set set : hashMap2.values()) {
            for (MethodBinding methodBinding : set) {
                abstractCollection.add(this._env.getFactory().newElement(methodBinding));
            }
        }
        return abstractCollection;
    }

    private void collectSuperInterfaces(ReferenceBinding referenceBinding, Set<ReferenceBinding> set, Set<ReferenceBinding> set2) {
        for (ReferenceBinding referenceBinding2 : referenceBinding.superInterfaces()) {
            if (set.contains(referenceBinding2) || set2.contains(referenceBinding2)) continue;
            set2.add(referenceBinding2);
            this.collectSuperInterfaces(referenceBinding2, set, set2);
        }
    }

    private void addMembers(ReferenceBinding referenceBinding, boolean bl, Map<String, ReferenceBinding> map, List<FieldBinding> list, Map<String, Set<MethodBinding>> map2) {
        String string;
        for (ReferenceBinding binding : referenceBinding.memberTypes()) {
            if (!bl && binding.isPrivate() || null != map.get(string = new String(binding.sourceName()))) continue;
            map.put(string, binding);
        }
        for (Binding binding : referenceBinding.fields()) {
            if (!bl && ((FieldBinding)binding).isPrivate()) continue;
            list.add((FieldBinding)binding);
        }
        for (Binding binding : referenceBinding.methods()) {
            if (((MethodBinding)binding).isSynthetic() || !bl && (((MethodBinding)binding).isPrivate() || ((MethodBinding)binding).isConstructor())) continue;
            string = new String(((MethodBinding)binding).selector);
            Set<MethodBinding> set = map2.get(string);
            if (null == set) {
                set = new HashSet<MethodBinding>(4);
                map2.put(string, set);
                set.add((MethodBinding)binding);
                continue;
            }
            boolean bl2 = true;
            if (!bl) {
                for (MethodBinding methodBinding : set) {
                    MethodVerifier methodVerifier = this._env.getLookupEnvironment().methodVerifier();
                    if (!methodVerifier.doesMethodOverride(methodBinding, (MethodBinding)binding)) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            set.add((MethodBinding)binding);
        }
    }

    @Override
    public Name getBinaryName(TypeElement typeElement) {
        TypeElementImpl typeElementImpl = (TypeElementImpl)typeElement;
        ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
        return new NameImpl(CharOperation.replaceOnCopy(referenceBinding.constantPoolName(), '/', '.'));
    }

    @Override
    public String getConstantExpression(Object object) {
        if (!(object instanceof Integer || object instanceof Byte || object instanceof Float || object instanceof Double || object instanceof Long || object instanceof Short || object instanceof Character || object instanceof String || object instanceof Boolean)) {
            throw new IllegalArgumentException("Not a valid wrapper type : " + object.getClass());
        }
        if (object instanceof Character) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\'').append(object).append('\'');
            return String.valueOf(stringBuilder);
        }
        if (object instanceof String) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"').append(object).append('\"');
            return String.valueOf(stringBuilder);
        }
        if (object instanceof Float) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object).append('f');
            return String.valueOf(stringBuilder);
        }
        if (object instanceof Long) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object).append('L');
            return String.valueOf(stringBuilder);
        }
        if (object instanceof Short) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(short)").append(object);
            return String.valueOf(stringBuilder);
        }
        if (object instanceof Byte) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(byte)0x");
            byte by = (Byte)object;
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            return String.valueOf(stringBuilder);
        }
        return String.valueOf(object);
    }

    @Override
    public String getDocComment(Element element) {
        char[] cArray = this.getUnparsedDocComment(element);
        return ElementsImpl.formatJavadoc(cArray);
    }

    private char[] getUnparsedDocComment(Element element) {
        Object object;
        Javadoc javadoc = null;
        ReferenceContext referenceContext = null;
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                object = (TypeElementImpl)element;
                ReferenceBinding referenceBinding = (ReferenceBinding)((TypeElementImpl)object)._binding;
                if (!(referenceBinding instanceof SourceTypeBinding)) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
                referenceContext = sourceTypeBinding.scope.referenceContext;
                javadoc = ((TypeDeclaration)referenceContext).javadoc;
                break;
            }
            case PACKAGE: {
                PackageElementImpl packageElementImpl = (PackageElementImpl)element;
                PackageBinding packageBinding = (PackageBinding)packageElementImpl._binding;
                char[][] cArray = CharOperation.arrayConcat(packageBinding.compoundName, TypeConstants.PACKAGE_INFO_NAME);
                ReferenceBinding referenceBinding = this._env.getLookupEnvironment().getType(cArray);
                if (referenceBinding == null || !referenceBinding.isValidBinding() || !(referenceBinding instanceof SourceTypeBinding)) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
                referenceContext = sourceTypeBinding.scope.referenceContext;
                javadoc = ((TypeDeclaration)referenceContext).javadoc;
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)element;
                MethodBinding methodBinding = (MethodBinding)executableElementImpl._binding;
                AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
                if (abstractMethodDeclaration == null) break;
                javadoc = abstractMethodDeclaration.javadoc;
                referenceContext = abstractMethodDeclaration;
                break;
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                VariableElementImpl variableElementImpl = (VariableElementImpl)element;
                FieldBinding fieldBinding = (FieldBinding)variableElementImpl._binding;
                FieldDeclaration fieldDeclaration = fieldBinding.sourceField();
                if (fieldDeclaration == null) break;
                javadoc = fieldDeclaration.javadoc;
                if (!(fieldBinding.declaringClass instanceof SourceTypeBinding)) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                referenceContext = sourceTypeBinding.scope.referenceContext;
                break;
            }
            default: {
                return null;
            }
        }
        if (javadoc != null && referenceContext != null && (object = (Object)referenceContext.compilationResult().getCompilationUnit().getContents()) != null) {
            return CharOperation.subarray((char[])object, javadoc.sourceStart, javadoc.sourceEnd - 1);
        }
        return null;
    }

    private static String formatJavadoc(char[] cArray) {
        if (cArray == null || cArray.length < 5) {
            return null;
        }
        String[] stringArray = new String(cArray).split("\n");
        Matcher matcher = INITIAL_DELIMITER.matcher(stringArray[0]);
        if (!matcher.find()) {
            return null;
        }
        int n = matcher.end();
        stringArray[0] = stringArray[0].substring(n);
        if (stringArray.length == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray2 = stringArray[0].toCharArray();
            boolean bl = true;
            for (char c : cArray2) {
                if (Character.isWhitespace(c)) {
                    if (bl) continue;
                    stringBuilder.append(c);
                    continue;
                }
                bl = false;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        int n2 = stringArray[0].trim().length() > 0 ? 0 : 1;
        int n3 = stringArray[stringArray.length - 1].trim().length() > 0 ? stringArray.length - 1 : stringArray.length - 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray[0].length() != 0 && n2 == 1) {
            stringBuilder.append('\n');
        }
        boolean bl = stringArray[0].length() == 0;
        for (int i = n2; i <= n3; ++i) {
            int n4;
            char[] cArray3 = stringArray[i].toCharArray();
            int n5 = ElementsImpl.getStars(cArray3);
            int n6 = 0;
            boolean bl2 = true;
            int n7 = cArray3.length;
            block5: for (n4 = 0; n4 < n7; ++n4) {
                char c = cArray3[n4];
                switch (c) {
                    case ' ': {
                        if (n5 == -1) {
                            if (bl2) {
                                ++n6;
                                continue block5;
                            }
                            stringBuilder.append(c);
                            continue block5;
                        }
                        if (n4 < n5) continue block5;
                        stringBuilder.append(c);
                        continue block5;
                    }
                    default: {
                        bl2 = false;
                        if (n6 != 0) {
                            int n8;
                            int n9;
                            int n10 = n6 / 8;
                            if (n10 != 0) {
                                n9 = n10;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    stringBuilder.append("        ");
                                }
                                if (n6 % 8 >= 1) {
                                    stringBuilder.append(' ');
                                }
                            } else if (i != 0) {
                                n9 = n6;
                                for (n8 = 0; n8 < n9; ++n8) {
                                    stringBuilder.append(' ');
                                }
                            }
                            n6 = 0;
                            stringBuilder.append(c);
                            continue block5;
                        }
                        if (c == '\t') {
                            if (n4 < n5) continue block5;
                            stringBuilder.append(c);
                            continue block5;
                        }
                        if (c == '*' && n4 <= n5) continue block5;
                        stringBuilder.append(c);
                    }
                }
            }
            n4 = stringArray.length - 1;
            if (i < n4) {
                stringBuilder.append('\n');
                continue;
            }
            if (!bl || i != n4) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static int getStars(char[] cArray) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) continue;
            if (c != '*') break;
            for (int j = i + 1; j < n; ++j) {
                if (cArray[j] == '*') continue;
                return j;
            }
            return n - 1;
        }
        return -1;
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror annotationMirror) {
        return ((AnnotationMirrorImpl)annotationMirror).getElementValuesWithDefaults();
    }

    @Override
    public Name getName(CharSequence charSequence) {
        return new NameImpl(charSequence);
    }

    @Override
    public PackageElement getPackageElement(CharSequence charSequence) {
        LookupEnvironment lookupEnvironment = this._env.getLookupEnvironment();
        if (charSequence.length() == 0) {
            return (PackageElement)this._env.getFactory().newElement(lookupEnvironment.defaultPackage);
        }
        char[] cArray = charSequence.toString().toCharArray();
        PackageBinding packageBinding = lookupEnvironment.createPackage(CharOperation.splitOn('.', cArray));
        if (packageBinding == null) {
            return null;
        }
        return (PackageElement)this._env.getFactory().newElement(packageBinding);
    }

    @Override
    public PackageElement getPackageOf(Element element) {
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                TypeElementImpl typeElementImpl = (TypeElementImpl)element;
                ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
                return (PackageElement)this._env.getFactory().newElement(referenceBinding.fPackage);
            }
            case PACKAGE: {
                return (PackageElement)element;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)element;
                MethodBinding methodBinding = (MethodBinding)executableElementImpl._binding;
                return (PackageElement)this._env.getFactory().newElement(methodBinding.declaringClass.fPackage);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                VariableElementImpl variableElementImpl = (VariableElementImpl)element;
                FieldBinding fieldBinding = (FieldBinding)variableElementImpl._binding;
                return (PackageElement)this._env.getFactory().newElement(fieldBinding.declaringClass.fPackage);
            }
            case PARAMETER: {
                VariableElementImpl variableElementImpl = (VariableElementImpl)element;
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)variableElementImpl._binding;
                return (PackageElement)this._env.getFactory().newElement(localVariableBinding.declaringScope.classScope().referenceContext.binding.fPackage);
            }
            case EXCEPTION_PARAMETER: 
            case INSTANCE_INIT: 
            case OTHER: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: 
            case LOCAL_VARIABLE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public TypeElement getTypeElement(CharSequence charSequence) {
        char[][] cArray;
        LookupEnvironment lookupEnvironment = this._env.getLookupEnvironment();
        ReferenceBinding referenceBinding = lookupEnvironment.getType(cArray = CharOperation.splitOn('.', charSequence.toString().toCharArray()));
        if (null == referenceBinding) {
            ReferenceBinding referenceBinding2 = null;
            int n = cArray.length;
            while (--n > 0) {
                char[][] cArrayArray = new char[n][];
                for (int i = 0; i < n; ++i) {
                    cArrayArray[i] = cArray[i];
                }
                referenceBinding2 = lookupEnvironment.getType(cArrayArray);
                if (null == referenceBinding2) continue;
                break;
            }
            if (null == referenceBinding2) {
                return null;
            }
            referenceBinding = referenceBinding2;
            for (int n2 = n; null != referenceBinding && n2 < cArray.length; referenceBinding = referenceBinding.getMemberType(cArray[n2]), ++n2) {
            }
        }
        if (null == referenceBinding) {
            return null;
        }
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            return null;
        }
        return new TypeElementImpl(this._env, referenceBinding, null);
    }

    @Override
    public boolean hides(Element element, Element element2) {
        if (element2 == null) {
            throw new NullPointerException();
        }
        return ((ElementImpl)element).hides(element2);
    }

    @Override
    public boolean isDeprecated(Element element) {
        if (!(element instanceof ElementImpl)) {
            return false;
        }
        return (((ElementImpl)element)._binding.getAnnotationTagBits() & 0x400000000000L) != 0L;
    }

    @Override
    public boolean overrides(ExecutableElement executableElement, ExecutableElement executableElement2, TypeElement typeElement) {
        if (executableElement2 == null || typeElement == null) {
            throw new NullPointerException();
        }
        return ((ExecutableElementImpl)executableElement).overrides(executableElement2, typeElement);
    }

    @Override
    public void printElements(Writer writer, Element ... elementArray) {
        String string = System.getProperty("line.separator");
        for (Element element : elementArray) {
            try {
                writer.write(element.toString());
                writer.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isFunctionalInterface(TypeElement typeElement) {
        ReferenceBinding referenceBinding;
        if (typeElement != null && typeElement.getKind() == ElementKind.INTERFACE && (referenceBinding = (ReferenceBinding)((TypeElementImpl)typeElement)._binding) instanceof SourceTypeBinding) {
            return referenceBinding.isFunctionalInterface(((SourceTypeBinding)referenceBinding).scope);
        }
        return false;
    }
}

