/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypeParameter
extends AbstractVariableDeclaration {
    public TypeVariableBinding binding;
    public TypeReference[] bounds;

    @Override
    public int getKind() {
        return 6;
    }

    public void checkBounds(Scope scope) {
        if (this.type != null) {
            this.type.checkBounds(scope);
        }
        if (this.bounds != null) {
            int n = this.bounds.length;
            for (int i = 0; i < n; ++i) {
                this.bounds[i].checkBounds(scope);
            }
        }
    }

    public void getAllAnnotationContexts(int n, int n2, List list) {
        int n3;
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, n2, list);
        if (this.annotations != null) {
            n3 = this.annotations.length;
            for (int i = 0; i < n3; ++i) {
                this.annotations[i].traverse((ASTVisitor)annotationCollector, (BlockScope)null);
            }
        }
        switch (annotationCollector.targetType) {
            case 0: {
                annotationCollector.targetType = 17;
                break;
            }
            case 1: {
                annotationCollector.targetType = 18;
            }
        }
        n3 = 0;
        if (this.type != null) {
            if (this.type.resolvedType.isInterface()) {
                n3 = 1;
            }
            if ((this.type.bits & 0x100000) != 0) {
                annotationCollector.info2 = n3;
                this.type.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
            }
        }
        if (this.bounds != null) {
            for (TypeReference typeReference : this.bounds) {
                if ((typeReference.bits & 0x100000) == 0) continue;
                annotationCollector.info2 = ++n3;
                typeReference.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
            }
        }
    }

    private void internalResolve(Scope scope, boolean bl) {
        Binding binding;
        if (this.binding != null && (binding = scope.parent.getBinding(this.name, 4, this, false)) != null && this.binding != binding && binding.isValidBinding() && (binding.kind() != 4100 || !bl)) {
            scope.problemReporter().typeHiding(this, binding);
        }
        if (this.annotations != null || scope.environment().usesNullTypeAnnotations()) {
            this.resolveAnnotations(scope);
        }
        if (CharOperation.equals(this.name, TypeConstants.VAR)) {
            if (scope.compilerOptions().sourceLevel < 0x360000L) {
                scope.problemReporter().varIsReservedTypeNameInFuture(this);
            } else {
                scope.problemReporter().varIsNotAllowedHere(this);
            }
        }
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.internalResolve(blockScope, blockScope.methodScope().isStatic);
    }

    public void resolve(ClassScope classScope) {
        this.internalResolve(classScope, classScope.enclosingSourceType().isStatic());
    }

    public void resolveAnnotations(Scope scope) {
        BlockScope blockScope = Scope.typeAnnotationsResolutionScope(scope);
        if (blockScope != null) {
            AnnotationBinding[] annotationBindingArray = TypeParameter.resolveAnnotations(blockScope, this.annotations, this.binding, false);
            LookupEnvironment lookupEnvironment = scope.environment();
            boolean bl = lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
            if (annotationBindingArray != null && annotationBindingArray.length > 0) {
                this.binding.setTypeAnnotations(annotationBindingArray, bl);
                scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            }
            if (bl && this.binding != null && this.binding.isValidBinding()) {
                if (!this.binding.hasNullTypeAnnotations() && scope.hasDefaultNullnessFor(128, this.sourceStart())) {
                    AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()};
                    TypeVariableBinding typeVariableBinding = this.binding;
                    this.binding = (TypeVariableBinding)lookupEnvironment.createAnnotatedType((TypeBinding)this.binding, annotationBindingArray2);
                    if (scope instanceof MethodScope) {
                        MethodBinding methodBinding;
                        MethodScope methodScope = (MethodScope)scope;
                        if (methodScope.referenceContext instanceof AbstractMethodDeclaration && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                            methodBinding.updateTypeVariableBinding(typeVariableBinding, this.binding);
                        }
                    }
                }
                this.binding.evaluateNullAnnotations(scope, this);
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.annotations != null) {
            TypeParameter.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.name);
        if (this.type != null) {
            stringBuffer.append(" extends ");
            this.type.print(0, stringBuffer);
        }
        if (this.bounds != null) {
            for (int i = 0; i < this.bounds.length; ++i) {
                stringBuffer.append(" & ");
                this.bounds[i].print(0, stringBuffer);
            }
        }
        return stringBuffer;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.bounds != null) {
                n2 = this.bounds.length;
                for (n = 0; n < n2; ++n) {
                    this.bounds[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, classScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
            if (this.bounds != null) {
                n2 = this.bounds.length;
                for (n = 0; n < n2; ++n) {
                    this.bounds[n].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

