/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected ZipFile annotationZipFile;
    protected boolean closeZipFileAtEnd;
    protected Set<String> packageCache;
    protected List<String> annotationPaths;

    public ClasspathJar(File file, boolean bl, AccessRuleSet accessRuleSet, String string) {
        super(accessRuleSet, string);
        this.file = file;
        this.closeZipFileAtEnd = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileSystem.Classpath> fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        InputStream inputStream = null;
        try {
            Object object;
            this.initialize();
            ArrayList<FileSystem.Classpath> arrayList = new ArrayList<FileSystem.Classpath>();
            ZipEntry zipEntry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry != null) {
                inputStream = this.zipFile.getInputStream(zipEntry);
                object = new ManifestAnalyzer();
                boolean bl = ((ManifestAnalyzer)object).analyzeManifestContents(inputStream);
                List list = ((ManifestAnalyzer)object).getCalledFileNames();
                if (classpathSectionProblemReporter != null) {
                    if (!bl || ((ManifestAnalyzer)object).getClasspathSectionsCount() == 1 && list == null) {
                        classpathSectionProblemReporter.invalidClasspathSection(this.getPath());
                    } else if (((ManifestAnalyzer)object).getClasspathSectionsCount() > 1) {
                        classpathSectionProblemReporter.multipleClasspathSections(this.getPath());
                    }
                }
                if (list != null) {
                    Iterator iterator = list.iterator();
                    String string = this.getPath();
                    int n = string.lastIndexOf(File.separatorChar);
                    string = string.substring(0, n + 1);
                    while (iterator.hasNext()) {
                        arrayList.add(new ClasspathJar(new File(string + (String)iterator.next()), this.closeZipFileAtEnd, this.accessRuleSet, this.destinationPath));
                    }
                }
            }
            object = arrayList;
            return object;
        }
        catch (IOException | IllegalArgumentException exception) {
            List<FileSystem.Classpath> list = null;
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3) {
        return this.findClass(cArray, string, string2, string3, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        block12: {
            if (!this.isPackage(string, string2)) {
                return null;
            }
            try {
                char[] cArray2;
                IBinaryType iBinaryType;
                block13: {
                    Object object;
                    iBinaryType = ClassFileReader.read(this.zipFile, string3);
                    if (iBinaryType == null) break block12;
                    char[] cArray3 = cArray2 = this.module == null ? null : this.module.name();
                    if (iBinaryType instanceof ClassFileReader) {
                        object = iBinaryType;
                        if (((ClassFileReader)object).moduleName == null) {
                            ((ClassFileReader)object).moduleName = cArray2;
                        } else {
                            cArray2 = ((ClassFileReader)object).moduleName;
                        }
                    }
                    if (this.annotationPaths != null) {
                        object = string3.substring(0, string3.length() - "CLASS".length() - 1);
                        for (String string4 : this.annotationPaths) {
                            try {
                                if (this.annotationZipFile == null) {
                                    this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(string4, null);
                                }
                                if ((iBinaryType = ExternalAnnotationDecorator.create(iBinaryType, string4, (String)object, this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                                break block13;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        iBinaryType = new ExternalAnnotationDecorator(iBinaryType, null);
                    }
                }
                return new NameEnvironmentAnswer(iBinaryType, this.fetchAccessRestriction(string3), cArray2);
            }
            catch (ClassFormatException classFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        return this.zipFile.getEntry(string + ".eea") != null;
    }

    @Override
    public char[][][] findTypeNames(String string, String string2) {
        Object object;
        if (!this.isPackage(string, string2)) {
            return null;
        }
        char[] cArray = string.toCharArray();
        ArrayList<char[][]> arrayList = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            String string3;
            object = enumeration.nextElement().getName();
            int n2 = ((String)object).lastIndexOf(47);
            if (n2 <= 0 || !string.equals(string3 = ((String)object).substring(0, n2)) || (n = ((String)object).lastIndexOf(46)) == -1) continue;
            String string4 = ((String)object).substring(n2 + 1, n);
            arrayList.add(CharOperation.arrayConcat(CharOperation.splitOn('/', cArray), string4.toCharArray()));
        }
        int n = arrayList.size();
        if (n != 0) {
            object = new char[n][][];
            arrayList.toArray((T[])object);
            return object;
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
    }

    void acceptModule(ClassFileReader classFileReader) {
        if (classFileReader != null) {
            this.acceptModule(classFileReader.getModuleDeclaration());
        }
    }

    void acceptModule(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        ClassFileReader classFileReader = null;
        try {
            classFileReader = new ClassFileReader(byArray, "module-info.class".toCharArray());
        }
        catch (ClassFormatException classFormatException) {
            classFormatException.printStackTrace();
        }
        if (classFileReader != null && classFileReader.getModuleDeclaration() != null) {
            this.acceptModule(classFileReader);
        }
    }

    protected void addToPackageCache(String string, boolean bl) {
        int n;
        int n2 = n = bl ? string.length() : string.lastIndexOf(47);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (this.packageCache.contains(string2)) {
                return;
            }
            this.packageCache.add(string2);
            n = string2.lastIndexOf(47);
        }
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String string, String string2) {
        if (this.packageCache != null) {
            return this.singletonModuleNameIf(this.packageCache.contains(string));
        }
        this.packageCache = new HashSet<String>(41);
        this.packageCache.add(Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().getName();
            this.addToPackageCache(string3, false);
        }
        return this.singletonModuleNameIf(this.packageCache.contains(string));
    }

    @Override
    public boolean hasCompilationUnit(String string, String string2) {
        string = string + '/';
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = enumeration.nextElement().getName();
            if (!string4.startsWith(string) || string4.length() <= string.length() || (string3 = string4.substring(string.length())).indexOf(47) != -1 || !string3.toLowerCase().endsWith(".class")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.closeZipFileAtEnd) {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.zipFile = null;
            }
            if (this.annotationZipFile != null) {
                try {
                    this.annotationZipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.annotationZipFile = null;
            }
        }
        this.packageCache = null;
        this.annotationPaths = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String string = this.getPath();
            char[] cArray = string.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(cArray, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(cArray, 0, CharOperation.lastIndexOf('.', cArray));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public IModule getModule() {
        if (this.isAutoModule && this.module == null) {
            Manifest manifest = null;
            try {
                this.initialize();
                ZipEntry zipEntry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
                if (zipEntry != null) {
                    manifest = new Manifest(this.zipFile.getInputStream(zipEntry));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.module = IModule.createAutomatic(this.file.getName(), true, manifest);
            return this.module;
        }
        return this.module;
    }
}

