/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class ConstraintExpressionFormula
extends ConstraintFormula {
    Expression left;
    boolean isSoft;

    ConstraintExpressionFormula(Expression expression, TypeBinding typeBinding, int n) {
        this.left = expression;
        this.right = typeBinding;
        this.relation = n;
    }

    ConstraintExpressionFormula(Expression expression, TypeBinding typeBinding, int n, boolean bl) {
        this(expression, typeBinding, n);
        this.isSoft = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object reduce(InferenceContext18 inferenceContext18) throws InferenceFailureException {
        if (this.relation == 8) {
            return this.left.isPotentiallyCompatibleWith(this.right, inferenceContext18.scope) ? TRUE : FALSE;
        }
        if (this.right.isProperType(true)) {
            if (this.left.isCompatibleWith(this.right, inferenceContext18.scope) || this.left.isBoxingCompatibleWith(this.right, inferenceContext18.scope)) {
                if (this.left.resolvedType != null && this.left.resolvedType.needsUncheckedConversion(this.right)) {
                    inferenceContext18.usesUncheckedConversion = true;
                }
                return TRUE;
            }
            return FALSE;
        }
        if (!this.canBePolyExpression(this.left)) {
            TypeBinding typeBinding = this.left.resolvedType;
            if (typeBinding == null || !typeBinding.isValidBinding()) {
                if (this.left instanceof MessageSend && ((MessageSend)this.left).actualReceiverType instanceof InferenceVariable) {
                    return null;
                }
                return FALSE;
            }
            return ConstraintTypeFormula.create(typeBinding, this.right, 1, this.isSoft);
        }
        if (this.left instanceof Invocation) {
            Invocation invocation = (Invocation)((Object)this.left);
            MethodBinding methodBinding = invocation.binding();
            if (methodBinding == null) {
                return null;
            }
            MethodBinding methodBinding2 = methodBinding;
            methodBinding2 = methodBinding.shallowOriginal();
            InferenceContext18.SuspendedInferenceRecord suspendedInferenceRecord = inferenceContext18.enterPolyInvocation(invocation, invocation.arguments());
            try {
                boolean bl;
                Expression[] expressionArray = invocation.arguments();
                TypeBinding[] typeBindingArray = expressionArray == null ? Binding.NO_PARAMETERS : new TypeBinding[expressionArray.length];
                for (bl = false; bl < typeBindingArray.length; bl += 1) {
                    typeBindingArray[bl] = expressionArray[bl].resolvedType;
                }
                if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                    InferenceContext18 inferenceContext182 = invocation.getInferenceContext((ParameterizedGenericMethodBinding)methodBinding);
                    if (inferenceContext182 == null) {
                        TypeBinding typeBinding = this.left.resolvedType;
                        if (typeBinding == null || !typeBinding.isValidBinding()) {
                            ConstraintTypeFormula constraintTypeFormula = FALSE;
                            return constraintTypeFormula;
                        }
                        ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(typeBinding, this.right, 1, this.isSoft);
                        return constraintTypeFormula;
                    }
                    if (inferenceContext182.stepCompleted < 1) {
                        ConstraintTypeFormula constraintTypeFormula = FALSE;
                        return constraintTypeFormula;
                    }
                    inferenceContext18.integrateInnerInferenceB2(inferenceContext182);
                } else {
                    inferenceContext18.inferenceKind = inferenceContext18.getInferenceKind(methodBinding, typeBindingArray);
                    bl = methodBinding2.isConstructor() && this.left.isPolyExpression(methodBinding2);
                    ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext18, methodBinding2, typeBindingArray, bl, inferenceContext18.inferenceKind);
                }
                if (!inferenceContext18.computeB3(invocation, this.right, methodBinding2)) {
                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                Object var8_19 = null;
                return var8_19;
            }
            finally {
                inferenceContext18.resumeSuspendedInference(suspendedInferenceRecord);
            }
        }
        if (this.left instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)this.left;
            return new ConstraintFormula[]{new ConstraintExpressionFormula(conditionalExpression.valueIfTrue, this.right, this.relation, this.isSoft), new ConstraintExpressionFormula(conditionalExpression.valueIfFalse, this.right, this.relation, this.isSoft)};
        }
        if (this.left instanceof LambdaExpression) {
            Object object;
            LambdaExpression lambdaExpression = (LambdaExpression)this.left;
            BlockScope blockScope = lambdaExpression.enclosingScope;
            if (!this.right.isFunctionalInterface(blockScope)) {
                return FALSE;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.right;
            ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(referenceBinding);
            if (parameterizedTypeBinding != null) {
                referenceBinding = ConstraintExpressionFormula.findGroundTargetType(inferenceContext18, blockScope, lambdaExpression, parameterizedTypeBinding);
            }
            if (referenceBinding == null) {
                return FALSE;
            }
            MethodBinding methodBinding = referenceBinding.getSingleAbstractMethod(blockScope, true);
            if (methodBinding == null) {
                return FALSE;
            }
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            if (typeBindingArray.length != lambdaExpression.arguments().length) {
                return FALSE;
            }
            if (lambdaExpression.argumentsTypeElided()) {
                for (int i = 0; i < typeBindingArray.length; ++i) {
                    if (typeBindingArray[i].isProperType(true)) continue;
                    return FALSE;
                }
            }
            if ((lambdaExpression = lambdaExpression.resolveExpressionExpecting(referenceBinding, inferenceContext18.scope, inferenceContext18)) == null) {
                return FALSE;
            }
            if (methodBinding.returnType == TypeBinding.VOID ? !lambdaExpression.isVoidCompatible() : !lambdaExpression.isValueCompatible()) {
                return FALSE;
            }
            ArrayList<ConstraintFormula> arrayList = new ArrayList<ConstraintFormula>();
            if (!lambdaExpression.argumentsTypeElided()) {
                object = lambdaExpression.arguments();
                for (int i = 0; i < typeBindingArray.length; ++i) {
                    arrayList.add(ConstraintTypeFormula.create(typeBindingArray[i], object[i].type.resolvedType, 4));
                }
                if (lambdaExpression.resolvedType != null) {
                    arrayList.add(ConstraintTypeFormula.create(lambdaExpression.resolvedType, this.right, 2));
                }
            }
            if (methodBinding.returnType != TypeBinding.VOID) {
                int n;
                object = methodBinding.returnType;
                Expression[] expressionArray = lambdaExpression.resultExpressions();
                int n2 = n = expressionArray == null ? 0 : expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    Expression expression = expressionArray[i];
                    if (((TypeBinding)object).isProperType(true) && expression.resolvedType != null) {
                        TypeBinding typeBinding = expression.resolvedType;
                        if (expression.isConstantValueOfTypeAssignableToType(typeBinding, (TypeBinding)object) || typeBinding.isCompatibleWith((TypeBinding)object) || expression.isBoxingCompatible(typeBinding, (TypeBinding)object, expression, blockScope)) continue;
                        return FALSE;
                    }
                    arrayList.add(new ConstraintExpressionFormula(expression, (TypeBinding)object, 1, this.isSoft));
                }
            }
            if (arrayList.size() == 0) {
                return TRUE;
            }
            return arrayList.toArray(new ConstraintFormula[arrayList.size()]);
        }
        if (this.left instanceof ReferenceExpression) {
            return this.reduceReferenceExpressionCompatibility((ReferenceExpression)this.left, inferenceContext18);
        }
        return FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceBinding findGroundTargetType(InferenceContext18 inferenceContext18, BlockScope blockScope, LambdaExpression lambdaExpression, ParameterizedTypeBinding parameterizedTypeBinding) {
        if (lambdaExpression.argumentsTypeElided()) {
            return lambdaExpression.findGroundTargetTypeForElidedLambda(blockScope, parameterizedTypeBinding);
        }
        InferenceContext18.SuspendedInferenceRecord suspendedInferenceRecord = inferenceContext18.enterLambda(lambdaExpression);
        try {
            ReferenceBinding referenceBinding = inferenceContext18.inferFunctionalInterfaceParameterization(lambdaExpression, blockScope, parameterizedTypeBinding);
            return referenceBinding;
        }
        finally {
            inferenceContext18.resumeSuspendedInference(suspendedInferenceRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBePolyExpression(Expression expression) {
        ExpressionContext expressionContext = expression.getExpressionContext();
        if (expressionContext == ExpressionContext.VANILLA_CONTEXT) {
            this.left.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
        }
        try {
            boolean bl = expression.isPolyExpression();
            return bl;
        }
        finally {
            expression.setExpressionContext(expressionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object reduceReferenceExpressionCompatibility(ReferenceExpression referenceExpression, InferenceContext18 inferenceContext18) {
        ReferenceBinding referenceBinding;
        TypeBinding typeBinding;
        MethodBinding methodBinding;
        TypeBinding typeBinding2 = this.right;
        if (typeBinding2.isProperType(true)) {
            throw new IllegalStateException("Should not reach here with T being a proper type");
        }
        if (!typeBinding2.isFunctionalInterface(inferenceContext18.scope)) {
            return FALSE;
        }
        MethodBinding methodBinding2 = typeBinding2.getSingleAbstractMethod(inferenceContext18.scope, true);
        if (methodBinding2 == null) {
            return FALSE;
        }
        MethodBinding methodBinding3 = methodBinding = (referenceExpression = referenceExpression.resolveExpressionExpecting(typeBinding2, inferenceContext18.scope, inferenceContext18)) != null ? referenceExpression.binding : null;
        if (methodBinding == null) {
            return FALSE;
        }
        if (referenceExpression.isExactMethodReference()) {
            ArrayList<ConstraintTypeFormula> arrayList = new ArrayList<ConstraintTypeFormula>();
            TypeBinding[] typeBindingArray = methodBinding2.parameters;
            int n = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            int n2 = typeBindingArray2.length;
            int n3 = 0;
            if (n == n2 + 1) {
                arrayList.add(ConstraintTypeFormula.create(typeBindingArray[0], referenceExpression.lhs.resolvedType, 1));
                n3 = 1;
            }
            for (int i = n3; i < n; ++i) {
                arrayList.add(ConstraintTypeFormula.create(typeBindingArray[i], typeBindingArray2[i - n3], 1));
            }
            TypeBinding typeBinding3 = methodBinding2.returnType;
            if (typeBinding3 != TypeBinding.VOID) {
                TypeBinding typeBinding4;
                TypeBinding typeBinding5 = typeBinding4 = methodBinding.isConstructor() && !referenceExpression.isArrayConstructorReference() ? methodBinding.declaringClass : methodBinding.returnType;
                if (typeBinding4 == TypeBinding.VOID) {
                    return FALSE;
                }
                TypeBinding typeBinding6 = typeBinding4.capture(inferenceContext18.scope, referenceExpression.sourceStart, referenceExpression.sourceEnd);
                arrayList.add(ConstraintTypeFormula.create(typeBinding6, typeBinding3, 1));
            }
            return arrayList.toArray(new ConstraintFormula[arrayList.size()]);
        }
        int n = methodBinding2.parameters.length;
        for (int i = 0; i < n; ++i) {
            if (methodBinding2.parameters[i].isProperType(true)) continue;
            return FALSE;
        }
        MethodBinding methodBinding4 = methodBinding;
        if (!methodBinding4.isValidBinding()) {
            return FALSE;
        }
        TypeBinding typeBinding7 = typeBinding = methodBinding2.isConstructor() ? methodBinding2.declaringClass : methodBinding2.returnType;
        if (typeBinding.id == 6) {
            return TRUE;
        }
        MethodBinding methodBinding5 = methodBinding4.shallowOriginal();
        if (this.needsInference(referenceExpression, methodBinding5)) {
            TypeBinding[] typeBindingArray;
            Object object;
            if (typeBinding2.isParameterizedType()) {
                object = ((ParameterizedTypeBinding)typeBinding2).getSingleAbstractMethod(inferenceContext18.scope, true, referenceExpression.sourceStart, referenceExpression.sourceEnd);
                typeBindingArray = ((MethodBinding)object).parameters;
            } else {
                typeBindingArray = methodBinding2.parameters;
            }
            object = inferenceContext18.enterPolyInvocation(referenceExpression, referenceExpression.createPseudoExpressions(typeBindingArray));
            try {
                InferenceContext18 inferenceContext182 = referenceExpression.getInferenceContext((ParameterizedMethodBinding)methodBinding4);
                int n4 = this.determineInferenceKind(methodBinding4, typeBindingArray, inferenceContext182);
                ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext18, methodBinding5, typeBindingArray, methodBinding5.isConstructor(), n4);
                if (!inferenceContext18.computeB3(referenceExpression, typeBinding, methodBinding5)) {
                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                Object var14_29 = null;
                return var14_29;
            }
            catch (InferenceFailureException inferenceFailureException) {
                ConstraintTypeFormula constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            finally {
                inferenceContext18.resumeSuspendedInference((InferenceContext18.SuspendedInferenceRecord)object);
            }
        }
        TypeBinding typeBinding8 = referenceBinding = methodBinding4.isConstructor() ? methodBinding4.declaringClass : methodBinding4.returnType.capture(inferenceContext18.scope, referenceExpression.sourceStart(), referenceExpression.sourceEnd());
        if (referenceBinding.id == 6) {
            return FALSE;
        }
        return ConstraintTypeFormula.create(referenceBinding, typeBinding, 1, this.isSoft);
    }

    private boolean needsInference(ReferenceExpression referenceExpression, MethodBinding methodBinding) {
        TypeBinding typeBinding;
        if (referenceExpression.typeArguments != null) {
            return false;
        }
        if (methodBinding.isConstructor()) {
            if (methodBinding.declaringClass.typeVariables() != Binding.NO_TYPE_VARIABLES && referenceExpression.receiverType.isRawType()) {
                return true;
            }
            typeBinding = methodBinding.declaringClass;
        } else {
            typeBinding = methodBinding.returnType;
        }
        return methodBinding.typeVariables() != Binding.NO_TYPE_VARIABLES && typeBinding.mentionsAny(methodBinding.typeVariables(), -1);
    }

    private int determineInferenceKind(MethodBinding methodBinding, TypeBinding[] typeBindingArray, InferenceContext18 inferenceContext18) {
        if (inferenceContext18 != null) {
            return inferenceContext18.inferenceKind;
        }
        if (methodBinding.isVarargs()) {
            TypeBinding typeBinding;
            TypeBinding typeBinding2;
            int n = methodBinding.parameters.length;
            int n2 = typeBindingArray.length;
            if (n < n2) {
                return 3;
            }
            if (n == n2 && !(typeBinding2 = typeBindingArray[n - 1]).isCompatibleWith(typeBinding = methodBinding.parameters[n - 1]) && typeBinding.isArrayType() && typeBinding2.isCompatibleWith(typeBinding = typeBinding.leafComponentType())) {
                return 3;
            }
        }
        return 1;
    }

    static void inferInvocationApplicability(InferenceContext18 inferenceContext18, MethodBinding methodBinding, TypeBinding[] typeBindingArray, boolean bl, int n) {
        TypeBinding[] typeBindingArray2 = methodBinding.getAllTypeVariables(bl);
        InferenceVariable[] inferenceVariableArray = inferenceContext18.createInitialBoundSet((TypeVariableBinding[])typeBindingArray2);
        int n2 = methodBinding.parameters.length;
        TypeBinding typeBinding = null;
        if (methodBinding.isVarargs()) {
            int n3 = n2 - 1;
            typeBinding = methodBinding.parameters[n3];
        }
        inferenceContext18.createInitialConstraintsForParameters(methodBinding.parameters, n == 3, typeBinding, methodBinding);
        inferenceContext18.addThrowsContraints(typeBindingArray2, inferenceVariableArray, methodBinding.thrownExceptions);
    }

    static boolean inferPolyInvocationType(InferenceContext18 inferenceContext18, InvocationSite invocationSite, TypeBinding typeBinding, MethodBinding methodBinding) throws InferenceFailureException {
        TypeBinding[] typeBindingArray = invocationSite.genericTypeArguments();
        if (typeBindingArray == null) {
            Object object;
            TypeBinding typeBinding2;
            TypeBinding typeBinding3 = typeBinding2 = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
            if (typeBinding2 == TypeBinding.VOID) {
                throw new InferenceFailureException("expression has no value");
            }
            if (inferenceContext18.usesUncheckedConversion) {
                TypeBinding typeBinding4 = ConstraintExpressionFormula.getRealErasure(typeBinding2, inferenceContext18.environment);
                ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(typeBinding4, typeBinding, 1);
                return inferenceContext18.reduceAndIncorporate(constraintTypeFormula);
            }
            TypeBinding typeBinding5 = inferenceContext18.substitute(typeBinding2);
            ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(typeBinding5);
            if (parameterizedTypeBinding != null && parameterizedTypeBinding.arguments != null) {
                TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
                TypeBinding[] typeBindingArray3 = inferenceContext18.addTypeVariableSubstitutions(typeBindingArray2);
                ParameterizedTypeBinding parameterizedTypeBinding2 = inferenceContext18.environment.createParameterizedType(parameterizedTypeBinding.genericType(), typeBindingArray3, parameterizedTypeBinding.enclosingType(), parameterizedTypeBinding.getTypeAnnotations());
                inferenceContext18.currentBounds.captures.put(parameterizedTypeBinding2, parameterizedTypeBinding);
                int n = typeBindingArray2.length;
                block4: for (int i = 0; i < n; ++i) {
                    if (!typeBindingArray2[i].isWildcard()) continue;
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBindingArray2[i];
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            inferenceContext18.currentBounds.addBound(new TypeBound((InferenceVariable)typeBindingArray3[i], wildcardBinding.bound(), 2), inferenceContext18.environment);
                            continue block4;
                        }
                        case 2: {
                            inferenceContext18.currentBounds.addBound(new TypeBound((InferenceVariable)typeBindingArray3[i], wildcardBinding.bound(), 3), inferenceContext18.environment);
                        }
                    }
                }
                ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(parameterizedTypeBinding2, typeBinding, 1);
                return inferenceContext18.reduceAndIncorporate(constraintTypeFormula);
            }
            if (typeBinding5.leafComponentType() instanceof InferenceVariable) {
                Object object2;
                object = (InferenceVariable)typeBinding5.leafComponentType();
                TypeBinding typeBinding6 = typeBinding.leafComponentType();
                boolean bl = false;
                if (inferenceContext18.currentBounds.condition18_5_2_bullet_3_3_1((InferenceVariable)object, typeBinding6)) {
                    bl = true;
                } else if (inferenceContext18.currentBounds.condition18_5_2_bullet_3_3_2((InferenceVariable)object, typeBinding6, inferenceContext18)) {
                    bl = true;
                } else if (typeBinding6.isPrimitiveType() && (object2 = inferenceContext18.currentBounds.findWrapperTypeBound((InferenceVariable)object)) != null) {
                    bl = true;
                }
                if (bl) {
                    object2 = inferenceContext18.solve(new InferenceVariable[]{object});
                    if (object2 == null) {
                        return false;
                    }
                    TypeBinding typeBinding7 = ((BoundSet)object2).getInstantiation((InferenceVariable)object, null).capture(inferenceContext18.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    if (typeBinding5.dimensions() != 0) {
                        typeBinding7 = inferenceContext18.environment.createArrayType(typeBinding7, typeBinding5.dimensions());
                    }
                    ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(typeBinding7, typeBinding, 1);
                    return inferenceContext18.reduceAndIncorporate(constraintTypeFormula);
                }
            }
            if (!inferenceContext18.reduceAndIncorporate((ConstraintFormula)(object = ConstraintTypeFormula.create(typeBinding5, typeBinding, 1)))) {
                return false;
            }
        }
        return true;
    }

    private static TypeBinding getRealErasure(TypeBinding typeBinding, LookupEnvironment lookupEnvironment) {
        TypeBinding typeBinding2 = typeBinding.erasure();
        TypeBinding typeBinding3 = typeBinding2.leafComponentType();
        if (typeBinding3.isGenericType()) {
            typeBinding3 = lookupEnvironment.convertToRawType(typeBinding3, false);
        }
        if (typeBinding2.isArrayType()) {
            return lookupEnvironment.createArrayType(typeBinding3, typeBinding2.dimensions());
        }
        return typeBinding3;
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 inferenceContext18) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                LambdaExpression lambdaExpression = (LambdaExpression)this.left;
                ReferenceBinding referenceBinding = (ReferenceBinding)this.right;
                ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(referenceBinding);
                if (parameterizedTypeBinding != null) {
                    referenceBinding = ConstraintExpressionFormula.findGroundTargetType(inferenceContext18, lambdaExpression.enclosingScope, lambdaExpression, parameterizedTypeBinding);
                }
                if (referenceBinding == null) {
                    return EMPTY_VARIABLE_LIST;
                }
                MethodBinding methodBinding = referenceBinding.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                if (lambdaExpression.argumentsTypeElided()) {
                    int n = methodBinding.parameters.length;
                    for (int i = 0; i < n; ++i) {
                        methodBinding.parameters[i].collectInferenceVariables(hashSet);
                    }
                }
                if (methodBinding.returnType != TypeBinding.VOID) {
                    int n;
                    TypeBinding typeBinding = methodBinding.returnType;
                    LambdaExpression lambdaExpression2 = lambdaExpression.resolveExpressionExpecting(this.right, inferenceContext18.scope, inferenceContext18);
                    Expression[] expressionArray = lambdaExpression2 != null ? lambdaExpression2.resultExpressions() : null;
                    int n2 = n = expressionArray == null ? 0 : expressionArray.length;
                    for (int i = 0; i < n; ++i) {
                        hashSet.addAll(new ConstraintExpressionFormula(expressionArray[i], typeBinding, 1).inputVariables(inferenceContext18));
                    }
                }
                return hashSet;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope) && !this.left.isExactMethodReference()) {
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                int n = methodBinding.parameters.length;
                for (int i = 0; i < n; ++i) {
                    methodBinding.parameters[i].collectInferenceVariables(hashSet);
                }
                return hashSet;
            }
        } else if (this.left instanceof ConditionalExpression && this.left.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)this.left;
            HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
            hashSet.addAll(new ConstraintExpressionFormula(conditionalExpression.valueIfTrue, this.right, 1).inputVariables(inferenceContext18));
            hashSet.addAll(new ConstraintExpressionFormula(conditionalExpression.valueIfFalse, this.right, 1).inputVariables(inferenceContext18));
            return hashSet;
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, stringBuffer);
        stringBuffer.append(ConstraintExpressionFormula.relationToString(this.relation));
        this.appendTypeName(stringBuffer, this.right);
        stringBuffer.append('\u27e9');
        return stringBuffer.toString();
    }
}

