/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public class ModuleBinding
extends Binding
implements IUpdatableModule {
    public static final char[] UNNAMED = "".toCharArray();
    public static final char[] ALL_UNNAMED = "ALL-UNNAMED".toCharArray();
    public static final char[] ANY = "".toCharArray();
    public static final char[] ANY_NAMED = "".toCharArray();
    public char[] moduleName;
    protected ModuleBinding[] requires;
    protected ModuleBinding[] requiresTransitive;
    protected PackageBinding[] exportedPackages;
    private Map<PackageBinding, SimpleSetOfCharArray> exportRestrictions;
    protected PackageBinding[] openedPackages;
    private Map<PackageBinding, SimpleSetOfCharArray> openRestrictions;
    protected TypeBinding[] uses;
    protected TypeBinding[] services;
    public Map<TypeBinding, TypeBinding[]> implementations;
    public char[] mainClassName;
    private SimpleSetOfCharArray packageNames;
    public int modifiers;
    public LookupEnvironment environment;
    public long tagBits;
    public int defaultNullness = 0;
    ModuleBinding[] requiredModules = null;
    boolean isAuto = false;
    private boolean[] isComplete = new boolean[IUpdatableModule.UpdateKind.values().length];
    private Set<ModuleBinding> transitiveRequires;
    boolean isPackageLookupActive = false;
    SimpleLookupTable storedAnnotations = null;
    public HashtableOfPackage declaredPackages;

    private ModuleBinding(LookupEnvironment lookupEnvironment) {
        this.moduleName = UNNAMED;
        this.environment = lookupEnvironment;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PACKAGES;
        this.openedPackages = Binding.NO_PACKAGES;
        this.declaredPackages = new HashtableOfPackage(0);
        Arrays.fill(this.isComplete, true);
    }

    ModuleBinding(char[] cArray) {
        this.moduleName = cArray;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PACKAGES;
        this.openedPackages = Binding.NO_PACKAGES;
        this.uses = Binding.NO_TYPES;
        this.services = Binding.NO_TYPES;
        this.declaredPackages = new HashtableOfPackage(5);
    }

    protected ModuleBinding(char[] cArray, LookupEnvironment lookupEnvironment) {
        this.moduleName = cArray;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.environment = new LookupEnvironment(lookupEnvironment.root, this);
        this.declaredPackages = new HashtableOfPackage(5);
    }

    public PackageBinding[] getExports() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.exportedPackages;
    }

    public String[] getExportRestrictions(PackageBinding packageBinding) {
        SimpleSetOfCharArray simpleSetOfCharArray;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.exportRestrictions != null && (simpleSetOfCharArray = this.exportRestrictions.get(packageBinding)) != null) {
            char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
            simpleSetOfCharArray.asArray((Object[])cArrayArray);
            return CharOperation.charArrayToStringArray(cArrayArray);
        }
        return CharOperation.NO_STRINGS;
    }

    public PackageBinding[] getOpens() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.openedPackages;
    }

    public String[] getOpenRestrictions(PackageBinding packageBinding) {
        SimpleSetOfCharArray simpleSetOfCharArray;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.openRestrictions != null && (simpleSetOfCharArray = this.openRestrictions.get(packageBinding)) != null) {
            char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
            simpleSetOfCharArray.asArray((Object[])cArrayArray);
            return CharOperation.charArrayToStringArray(cArrayArray);
        }
        return CharOperation.NO_STRINGS;
    }

    public TypeBinding[] getImplementations(TypeBinding typeBinding) {
        if (this.implementations != null) {
            return this.implementations.get(typeBinding);
        }
        return null;
    }

    public ModuleBinding[] getRequires() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requires;
    }

    public ModuleBinding[] getRequiresTransitive() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requiresTransitive;
    }

    public TypeBinding[] getUses() {
        return this.uses;
    }

    public TypeBinding[] getServices() {
        return this.services;
    }

    private void completeIfNeeded(IUpdatableModule.UpdateKind updateKind) {
        if (!this.isComplete[updateKind.ordinal()]) {
            this.isComplete[updateKind.ordinal()] = true;
            if (this.environment.nameEnvironment instanceof IModuleAwareNameEnvironment) {
                ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).applyModuleUpdates(this, updateKind);
            }
        }
    }

    @Override
    public void addReads(char[] cArray) {
        ModuleBinding moduleBinding = this.environment.getModule(cArray);
        if (moduleBinding != null) {
            int n = this.requires.length;
            if (n == 0) {
                this.requires = new ModuleBinding[]{moduleBinding};
            } else {
                this.requires = new ModuleBinding[n + 1];
                System.arraycopy(this.requires, 0, this.requires, 0, n);
                this.requires[n] = moduleBinding;
            }
        }
        HashtableOfPackage hashtableOfPackage = this.environment.knownPackages;
        for (int i = 0; i < hashtableOfPackage.valueTable.length; ++i) {
            PackageBinding packageBinding = hashtableOfPackage.valueTable[i];
            if (packageBinding == null) continue;
            PackageBinding packageBinding2 = moduleBinding.getVisiblePackage(packageBinding.compoundName);
            if (packageBinding == (packageBinding2 = SplitPackageBinding.combine(packageBinding2, packageBinding, this))) continue;
            hashtableOfPackage.valueTable[i] = packageBinding2;
            if (!this.declaredPackages.containsKey(packageBinding2.readableName())) continue;
            this.declaredPackages.put(packageBinding2.readableName(), packageBinding2);
        }
    }

    @Override
    public void addExports(char[] cArray, char[][] cArray2) {
        PackageBinding packageBinding = this.getVisiblePackage(CharOperation.splitOn('.', cArray));
        if (packageBinding != null && packageBinding.isValidBinding()) {
            this.addResolvedExport(packageBinding, cArray2);
        }
    }

    @Override
    public void setMainClassName(char[] cArray) {
        this.mainClassName = cArray;
    }

    @Override
    public void setPackageNames(SimpleSetOfCharArray simpleSetOfCharArray) {
        this.packageNames = simpleSetOfCharArray;
    }

    public char[][] getPackageNamesForClassFile() {
        if (this.packageNames == null) {
            return null;
        }
        for (PackageBinding packageBinding : this.exportedPackages) {
            this.packageNames.add(packageBinding.readableName());
        }
        for (PackageBinding packageBinding : this.openedPackages) {
            this.packageNames.add(packageBinding.readableName());
        }
        if (this.implementations != null) {
            Iterator<TypeBinding[]> iterator = this.implementations.values().iterator();
            while (iterator.hasNext()) {
                TypeBinding[] typeBindingArray;
                for (TypeBinding typeBinding : typeBindingArray = (TypeBinding[])iterator.next()) {
                    this.packageNames.add(((ReferenceBinding)typeBinding).fPackage.readableName());
                }
            }
        }
        return this.packageNames.values;
    }

    public void addResolvedExport(PackageBinding packageBinding, char[][] cArray) {
        int n = this.exportedPackages.length;
        if (packageBinding == null || !packageBinding.isValidBinding()) {
            return;
        }
        if (n == 0) {
            this.exportedPackages = new PackageBinding[]{packageBinding};
        } else {
            this.exportedPackages = new PackageBinding[n + 1];
            System.arraycopy(this.exportedPackages, 0, this.exportedPackages, 0, n);
            this.exportedPackages[n] = packageBinding;
        }
        packageBinding.isExported = Boolean.TRUE;
        this.recordExportRestrictions(packageBinding, cArray);
    }

    public void addResolvedOpens(PackageBinding packageBinding, char[][] cArray) {
        int n = this.openedPackages.length;
        if (packageBinding == null || !packageBinding.isValidBinding()) {
            return;
        }
        if (n == 0) {
            this.openedPackages = new PackageBinding[]{packageBinding};
        } else {
            this.openedPackages = new PackageBinding[n + 1];
            System.arraycopy(this.openedPackages, 0, this.openedPackages, 0, n);
            this.openedPackages[n] = packageBinding;
        }
        this.recordOpensRestrictions(packageBinding, cArray);
    }

    protected void recordExportRestrictions(PackageBinding packageBinding, char[][] cArray) {
        if (cArray != null && cArray.length > 0) {
            SimpleSetOfCharArray simpleSetOfCharArray = new SimpleSetOfCharArray(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                simpleSetOfCharArray.add(cArray[i]);
            }
            if (this.exportRestrictions == null) {
                this.exportRestrictions = new HashMap<PackageBinding, SimpleSetOfCharArray>();
            }
            this.exportRestrictions.put(packageBinding, simpleSetOfCharArray);
        }
    }

    protected void recordOpensRestrictions(PackageBinding packageBinding, char[][] cArray) {
        if (cArray != null && cArray.length > 0) {
            SimpleSetOfCharArray simpleSetOfCharArray = new SimpleSetOfCharArray(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                simpleSetOfCharArray.add(cArray[i]);
            }
            if (this.openRestrictions == null) {
                this.openRestrictions = new HashMap<PackageBinding, SimpleSetOfCharArray>();
            }
            this.openRestrictions.put(packageBinding, simpleSetOfCharArray);
        }
    }

    Stream<ModuleBinding> getRequiredModules(boolean bl) {
        return Stream.of(bl ? this.getRequiresTransitive() : this.getRequires());
    }

    private void collectAllDependencies(Set<ModuleBinding> set) {
        this.getRequiredModules(false).forEach(moduleBinding -> {
            if (set.add((ModuleBinding)moduleBinding)) {
                moduleBinding.collectAllDependencies(set);
            }
        });
    }

    private void collectTransitiveDependencies(Set<ModuleBinding> set) {
        this.getRequiredModules(true).forEach(moduleBinding -> {
            if (set.add((ModuleBinding)moduleBinding)) {
                moduleBinding.collectTransitiveDependencies(set);
            }
        });
    }

    public Supplier<Collection<ModuleBinding>> dependencyGraphCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (hashSet, moduleBinding) -> {
            hashSet.add(moduleBinding);
            moduleBinding.collectAllDependencies((Set<ModuleBinding>)hashSet);
        }, AbstractCollection::addAll);
    }

    public Supplier<Collection<ModuleBinding>> dependencyCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (hashSet, moduleBinding) -> {
            hashSet.add(moduleBinding);
            moduleBinding.collectTransitiveDependencies((Set<ModuleBinding>)hashSet);
        }, AbstractCollection::addAll);
    }

    public ModuleBinding[] getAllRequiredModules() {
        if (this.requiredModules != null) {
            return this.requiredModules;
        }
        Collection<ModuleBinding> collection = this.dependencyCollector().get();
        if (collection.contains(this)) {
            return NO_MODULES;
        }
        ModuleBinding moduleBinding = this.environment.javaBaseModule();
        if (!CharOperation.equals(this.moduleName, TypeConstants.JAVA_BASE) && moduleBinding != null && moduleBinding != this.environment.UnNamedModule) {
            collection.add(moduleBinding);
        }
        this.requiredModules = collection.size() > 0 ? collection.toArray(new ModuleBinding[collection.size()]) : Binding.NO_MODULES;
        return this.requiredModules;
    }

    @Override
    public char[] name() {
        return this.moduleName;
    }

    public char[] nameForLookup() {
        return this.moduleName;
    }

    public boolean isPackageExportedTo(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        PackageBinding packageBinding2 = null;
        if (packageBinding instanceof SplitPackageBinding) {
            packageBinding2 = ((SplitPackageBinding)packageBinding).getIncarnation(this);
        } else if (packageBinding.enclosingModule == this) {
            packageBinding2 = packageBinding;
        }
        if (packageBinding2 != null) {
            if (this.isAuto) {
                return packageBinding.enclosingModule == this;
            }
            PackageBinding[] packageBindingArray = this.getExports();
            for (int i = 0; i < packageBindingArray.length; ++i) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                PackageBinding packageBinding3 = packageBindingArray[i];
                if (!packageBinding3.subsumes(packageBinding2)) continue;
                if (this.exportRestrictions != null && (simpleSetOfCharArray = this.exportRestrictions.get(packageBinding3)) != null) {
                    if (moduleBinding.isUnnamed()) {
                        return simpleSetOfCharArray.includes(ALL_UNNAMED);
                    }
                    return simpleSetOfCharArray.includes(moduleBinding.name());
                }
                return true;
            }
        }
        return false;
    }

    public PackageBinding getTopLevelPackage(char[] cArray) {
        PackageBinding packageBinding = this.declaredPackages.get(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        packageBinding = this.environment.getPackage0(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        packageBinding = this.getVisiblePackage(null, cArray, true);
        if (packageBinding != null) {
            this.environment.knownPackages.put(cArray, packageBinding);
            packageBinding = this.addPackage(packageBinding, false);
        } else {
            this.environment.knownPackages.put(cArray, LookupEnvironment.TheNotFoundPackage);
        }
        return packageBinding;
    }

    PackageBinding getDeclaredPackage(char[][] cArray, char[] cArray2) {
        char[][] cArray3 = CharOperation.arrayConcat(cArray, cArray2);
        char[] cArray4 = CharOperation.concatWith(cArray3, '.');
        PackageBinding packageBinding = this.declaredPackages.get(cArray4);
        if (packageBinding != null) {
            return packageBinding;
        }
        PackageBinding packageBinding2 = cArray.length == 0 ? null : this.getVisiblePackage(cArray);
        PackageBinding packageBinding3 = new PackageBinding(cArray3, packageBinding2, this.environment, this);
        this.declaredPackages.put(cArray4, packageBinding3);
        if (packageBinding2 == null) {
            this.environment.knownPackages.put(cArray2, packageBinding3);
        }
        return packageBinding3;
    }

    PackageBinding getVisiblePackage(PackageBinding packageBinding, char[] cArray, boolean bl) {
        boolean bl2;
        char[][] cArray2 = packageBinding == null ? CharOperation.NO_CHAR_CHAR : packageBinding.compoundName;
        char[][] cArray3 = CharOperation.arrayConcat(cArray2, cArray);
        char[] cArray4 = CharOperation.concatWith(cArray3, '.');
        PackageBinding packageBinding2 = this.declaredPackages.get(cArray4);
        if (packageBinding2 != null) {
            return packageBinding2;
        }
        packageBinding2 = packageBinding != null ? packageBinding.getPackage0(cArray) : this.environment.getPackage0(cArray);
        if (packageBinding2 != null) {
            if (packageBinding2 == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return this.addPackage(packageBinding2, false);
        }
        Binding binding = null;
        char[][] cArray5 = null;
        boolean bl3 = bl2 = !bl;
        if (this.environment.useModuleSystem) {
            IModuleAwareNameEnvironment iModuleAwareNameEnvironment = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
            cArray5 = iModuleAwareNameEnvironment.getUniqueModulesDeclaringPackage(cArray2, cArray, this.nameForLookup());
            if (cArray5 != null) {
                if (CharOperation.containsEqual(cArray5, this.moduleName)) {
                    binding = new PackageBinding(cArray3, packageBinding, this.environment, this);
                } else if (bl) {
                    for (char[] cArray6 : cArray5) {
                        ModuleBinding moduleBinding = this.environment.root.getModule(cArray6);
                        if (moduleBinding == null) continue;
                        if (moduleBinding.isPackageLookupActive) {
                            bl2 = true;
                            continue;
                        }
                        PackageBinding packageBinding3 = moduleBinding.getDeclaredPackage(cArray2, cArray);
                        if (packageBinding3 == null) continue;
                        if (packageBinding3.parent != null) {
                            packageBinding3.parent.addPackage(packageBinding3, moduleBinding, true);
                        }
                        packageBinding = null;
                        binding = SplitPackageBinding.combine(packageBinding3, (PackageBinding)binding, this);
                    }
                }
            }
        } else if (this.environment.nameEnvironment.isPackage(cArray2, cArray)) {
            binding = new PackageBinding(cArray3, packageBinding, this.environment, this);
        }
        if (bl) {
            binding = this.combineWithPackagesFromOtherRelevantModules((PackageBinding)binding, cArray3, cArray5);
        }
        if (binding == null || !binding.isValidBinding()) {
            if (packageBinding != null && !bl2) {
                packageBinding.knownPackages.put(cArray, (PackageBinding)(binding == null ? LookupEnvironment.TheNotFoundPackage : binding));
            }
            return null;
        }
        if (cArray2.length == 0) {
            ((PackageBinding)binding).environment.knownPackages.put(cArray, (PackageBinding)binding);
        } else if (packageBinding != null) {
            binding = packageBinding.addPackage((PackageBinding)binding, this, false);
        }
        return this.addPackage((PackageBinding)binding, false);
    }

    public PackageBinding getVisiblePackage(char[][] cArray) {
        return this.getVisiblePackage(cArray, true);
    }

    PackageBinding getVisiblePackage(char[][] cArray, boolean bl) {
        if (cArray == null || cArray.length == 0) {
            return this.environment.defaultPackage;
        }
        PackageBinding packageBinding = this.getTopLevelPackage(cArray[0]);
        if (packageBinding == null || packageBinding == LookupEnvironment.TheNotFoundPackage) {
            return null;
        }
        for (int i = 1; i < cArray.length; ++i) {
            PackageBinding packageBinding2 = this.getVisiblePackage(packageBinding, cArray[i], bl);
            if (packageBinding2 == null || packageBinding2 == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            packageBinding = packageBinding2;
        }
        return packageBinding;
    }

    public PackageBinding getPackage(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return this.getVisiblePackage(null, cArray2, true);
        }
        PackageBinding packageBinding = null;
        PackageBinding packageBinding2 = this.getVisiblePackage(cArray);
        if (packageBinding2 != null && packageBinding2 != LookupEnvironment.TheNotFoundPackage) {
            packageBinding = this.getVisiblePackage(packageBinding2, cArray2, true);
        }
        if (packageBinding != null) {
            return this.addPackage(packageBinding, false);
        }
        return null;
    }

    PackageBinding addPackage(PackageBinding packageBinding, boolean bl) {
        if (packageBinding.isDeclaredIn(this)) {
            char[] cArray = packageBinding.readableName();
            if (bl && this.environment.useModuleSystem) {
                char[][] cArray2 = null;
                if (this.isUnnamed()) {
                    IModuleAwareNameEnvironment iModuleAwareNameEnvironment = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
                    cArray2 = iModuleAwareNameEnvironment.getUniqueModulesDeclaringPackage(null, cArray, ANY);
                }
                packageBinding = this.combineWithPackagesFromOtherRelevantModules(packageBinding, packageBinding.compoundName, cArray2);
            }
            this.declaredPackages.put(cArray, packageBinding);
            if (packageBinding.parent == null) {
                this.environment.knownPackages.put(cArray, packageBinding);
            }
        }
        return packageBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageBinding combineWithPackagesFromOtherRelevantModules(PackageBinding packageBinding, char[][] cArray, char[][] cArray2) {
        boolean bl = this.isPackageLookupActive;
        this.isPackageLookupActive = true;
        try {
            char[] cArray3 = cArray[cArray.length - 1];
            PackageBinding packageBinding2 = packageBinding != null ? packageBinding.parent : null;
            for (ModuleBinding moduleBinding : this.otherRelevantModules(cArray2)) {
                if (moduleBinding.isPackageLookupActive) continue;
                PackageBinding packageBinding3 = packageBinding2 != null ? moduleBinding.getVisiblePackage(packageBinding2, cArray3, false) : moduleBinding.getVisiblePackage(cArray, false);
                packageBinding = SplitPackageBinding.combine(packageBinding3, packageBinding, this);
            }
            PackageBinding packageBinding4 = packageBinding;
            return packageBinding4;
        }
        finally {
            this.isPackageLookupActive = bl;
        }
    }

    List<ModuleBinding> otherRelevantModules(char[][] cArray2) {
        if (this.isUnnamed() && cArray2 != null) {
            return Arrays.stream(cArray2).filter(cArray -> cArray != UNNAMED).map(cArray -> this.environment.getModule((char[])cArray)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Arrays.asList(this.getAllRequiredModules());
    }

    public boolean canAccess(PackageBinding packageBinding) {
        if (packageBinding.isDeclaredIn(this)) {
            return true;
        }
        for (ModuleBinding moduleBinding : this.getAllRequiredModules()) {
            if (!moduleBinding.isPackageExportedTo(packageBinding, this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        return CharOperation.prepend('\"', this.moduleName);
    }

    @Override
    public int kind() {
        return 64;
    }

    @Override
    public char[] readableName() {
        return this.moduleName;
    }

    public String toString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.isOpen()) {
            stringBuffer.append("open ");
        }
        stringBuffer.append("module " + new String(this.readableName()));
        if (this.requires.length > 0) {
            stringBuffer.append("\n/*    requires    */\n");
            for (n = 0; n < this.requires.length; ++n) {
                stringBuffer.append("\n\t");
                if (this.requiresTransitive != null) {
                    for (ModuleBinding object22 : this.requiresTransitive) {
                        if (object22 != this.requires[n]) continue;
                        stringBuffer.append("transitive ");
                        break;
                    }
                }
                stringBuffer.append(this.requires[n].moduleName);
            }
        } else {
            stringBuffer.append("\nNo Requires");
        }
        if (this.exportedPackages != null && this.exportedPackages.length > 0) {
            stringBuffer.append("\n/*    exports    */\n");
            for (n = 0; n < this.exportedPackages.length; ++n) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                object = this.exportedPackages[n];
                stringBuffer.append("\n\t");
                if (object == null) {
                    stringBuffer.append("<unresolved>");
                    continue;
                }
                stringBuffer.append(((PackageBinding)object).readableName());
                SimpleSetOfCharArray simpleSetOfCharArray2 = simpleSetOfCharArray = this.exportRestrictions != null ? this.exportRestrictions.get(object) : null;
                if (simpleSetOfCharArray == null) continue;
                stringBuffer.append(" to ");
                String string = "";
                char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
                simpleSetOfCharArray.asArray((Object[])cArrayArray);
                for (char[] cArray : cArrayArray) {
                    stringBuffer.append(string);
                    stringBuffer.append(cArray);
                    string = ", ";
                }
            }
        } else {
            stringBuffer.append("\nNo Exports");
        }
        if (this.openedPackages != null && this.openedPackages.length > 0) {
            stringBuffer.append("\n/*    exports    */\n");
            for (n = 0; n < this.openedPackages.length; ++n) {
                SimpleSetOfCharArray simpleSetOfCharArray;
                object = this.openedPackages[n];
                stringBuffer.append("\n\t");
                if (object == null) {
                    stringBuffer.append("<unresolved>");
                    continue;
                }
                stringBuffer.append(((PackageBinding)object).readableName());
                SimpleSetOfCharArray simpleSetOfCharArray3 = simpleSetOfCharArray = this.openRestrictions != null ? this.openRestrictions.get(object) : null;
                if (simpleSetOfCharArray == null) continue;
                stringBuffer.append(" to ");
                String string = "";
                char[][] cArrayArray = new char[simpleSetOfCharArray.elementSize][];
                simpleSetOfCharArray.asArray((Object[])cArrayArray);
                for (char[] cArray : cArrayArray) {
                    stringBuffer.append(string);
                    stringBuffer.append(cArray);
                    string = ", ";
                }
            }
        } else {
            stringBuffer.append("\nNo Opens");
        }
        if (this.uses != null && this.uses.length > 0) {
            stringBuffer.append("\n/*    uses    /*\n");
            for (n = 0; n < this.uses.length; ++n) {
                stringBuffer.append("\n\t");
                stringBuffer.append(this.uses[n].debugName());
            }
        } else {
            stringBuffer.append("\nNo Uses");
        }
        if (this.services != null && this.services.length > 0) {
            stringBuffer.append("\n/*    Services    */\n");
            for (n = 0; n < this.services.length; ++n) {
                stringBuffer.append("\n\t");
                stringBuffer.append("provides ");
                stringBuffer.append(this.services[n].debugName());
                stringBuffer.append(" with ");
                if (this.implementations != null && this.implementations.containsKey(this.services[n])) {
                    object = "";
                    TypeBinding[] typeBindingArray = this.implementations.get(this.services[n]);
                    int n2 = typeBindingArray.length;
                    for (int i = 0; i < n2; ++i) {
                        Object object2 = typeBindingArray[i];
                        stringBuffer.append((String)object).append(((TypeBinding)object2).debugName());
                        object = ", ";
                    }
                    continue;
                }
                stringBuffer.append("<missing implementations>");
            }
        } else {
            stringBuffer.append("\nNo Services");
        }
        return stringBuffer.toString();
    }

    public boolean isUnnamed() {
        return false;
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isDeprecated() {
        return (this.tagBits & 0x400000000000L) != 0L;
    }

    public boolean hasUnstableAutoName() {
        return false;
    }

    public boolean isTransitivelyRequired(ModuleBinding moduleBinding) {
        if (this.transitiveRequires == null) {
            HashSet<ModuleBinding> hashSet = new HashSet<ModuleBinding>();
            this.collectTransitiveDependencies(hashSet);
            this.transitiveRequires = hashSet;
        }
        return this.transitiveRequires.contains(moduleBinding);
    }

    public int getDefaultNullness() {
        this.getAnnotationTagBits();
        return this.defaultNullness;
    }

    SimpleLookupTable storedAnnotations(boolean bl, boolean bl2) {
        if (bl && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations && !bl2) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(bl, false);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.storeAnnotations(this, annotationBindingArray, bl);
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, false);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray, boolean bl) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false, bl);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true, bl);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    public static class UnNamedModule
    extends ModuleBinding {
        private static final char[] UNNAMED_READABLE_NAME = "<unnamed>".toCharArray();

        UnNamedModule(LookupEnvironment lookupEnvironment) {
            super(lookupEnvironment);
        }

        @Override
        public ModuleBinding[] getAllRequiredModules() {
            return Binding.NO_MODULES;
        }

        @Override
        public boolean canAccess(PackageBinding packageBinding) {
            ModuleBinding moduleBinding = packageBinding.enclosingModule;
            if (moduleBinding != null && moduleBinding != this) {
                return moduleBinding.isPackageExportedTo(packageBinding, this);
            }
            return true;
        }

        @Override
        public boolean isPackageExportedTo(PackageBinding packageBinding, ModuleBinding moduleBinding) {
            return packageBinding.isDeclaredIn(this) && packageBinding.hasCompilationUnit(false);
        }

        @Override
        public boolean isUnnamed() {
            return true;
        }

        @Override
        public char[] nameForLookup() {
            return ANY;
        }

        @Override
        public char[] readableName() {
            return UNNAMED_READABLE_NAME;
        }

        @Override
        public String toString() {
            return "The Unnamed Module";
        }
    }
}

