/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

class JrtFileSystem {
    private final Map<String, String> packageToModule = new HashMap<String, String>();
    private final Map<String, List<String>> packageToModules = new HashMap<String, List<String>>();
    FileSystem jrtSystem = null;

    public JrtFileSystem(File file) throws IOException {
        this.initialize(file);
    }

    void initialize(File file) throws IOException {
        URL uRL = null;
        String string = null;
        if (file.toString().endsWith("jrt-fs.jar")) {
            uRL = file.toPath().toUri().toURL();
            string = file.getParentFile().getParent();
        } else {
            string = file.toPath().toString();
            uRL = Paths.get(string, "lib", "jrt-fs.jar").toUri().toURL();
        }
        JRTUtil.MODULE_TO_LOAD = System.getProperty("modules.to.load");
        String string2 = System.getProperty("java.version");
        if (string2 != null && string2.startsWith("1.8")) {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
            HashMap hashMap = new HashMap();
            this.jrtSystem = FileSystems.newFileSystem(JRTUtil.JRT_URI, hashMap, (ClassLoader)uRLClassLoader);
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("java.home", string);
            this.jrtSystem = FileSystems.newFileSystem(JRTUtil.JRT_URI, hashMap);
        }
        this.walkModuleImage(null, true, 0);
    }

    public List<String> getModulesDeclaringPackage(String string, String string2) {
        List<String> list;
        string = string.replace('.', '/');
        String string3 = this.packageToModule.get(string);
        if (string2 == null) {
            if (string3 == null) {
                return null;
            }
            if (string3 == "MU") {
                return this.packageToModules.get(string);
            }
            return Collections.singletonList(string3);
        }
        if (string3 != null && (string3 == "MU" ? (list = this.packageToModules.get(string)).contains(string2) : string3.equals(string2))) {
            return Collections.singletonList(string2);
        }
        return null;
    }

    public String[] getModules(String string) {
        int n = string.lastIndexOf(47);
        String string2 = null;
        string2 = n != -1 ? string.substring(0, n) : "";
        String string3 = this.packageToModule.get(string2);
        if (string3 != null) {
            if (string3 == "MU") {
                List<String> list = this.packageToModules.get(string2);
                return list.toArray(new String[list.size()]);
            }
            return new String[]{string3};
        }
        return JRTUtil.DEFAULT_MODULE;
    }

    public boolean hasClassFile(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = this.packageToModule.get(string);
        if (string3 == null || string3 != "MU" && !string3.equals(string2)) {
            return false;
        }
        Path path2 = this.jrtSystem.getPath("/modules", string2, string);
        if (!Files.exists(path2, new LinkOption[0])) {
            return false;
        }
        try {
            return Files.list(path2).anyMatch(path -> path.toString().endsWith(".class") || path.toString().endsWith(".CLASS"));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public InputStream getContentFromJrt(String string, String string2) throws IOException {
        if (string2 != null) {
            return Files.newInputStream(this.jrtSystem.getPath("/modules", string2, string), new OpenOption[0]);
        }
        int n = 0;
        String[] stringArray = this.getModules(string);
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        if (n < n2) {
            String string3 = stringArray2[n];
            return Files.newInputStream(this.jrtSystem.getPath("/modules", string3, string), new OpenOption[0]);
        }
        return null;
    }

    private ClassFileReader getClassfile(String string, Predicate<String> predicate) throws IOException, ClassFormatException {
        String[] stringArray = this.getModules(string);
        byte[] byArray = null;
        String string2 = null;
        for (String string3 : stringArray) {
            if (predicate != null && !predicate.test(string3) || (byArray = JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", string3, string))) == null) continue;
            string2 = string3;
            break;
        }
        if (byArray != null) {
            ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
            classFileReader.moduleName = string2.toCharArray();
            return classFileReader;
        }
        return null;
    }

    byte[] getClassfileContent(String string, String string2) throws IOException, ClassFormatException {
        byte[] byArray = null;
        if (string2 != null) {
            byArray = this.getClassfileBytes(string, new String(string2.toCharArray()));
        } else {
            String[] stringArray;
            for (String string3 : stringArray = this.getModules(string)) {
                byArray = JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", string3, string));
                if (byArray != null) break;
            }
        }
        return byArray;
    }

    private byte[] getClassfileBytes(String string, String string2) throws IOException, ClassFormatException {
        return JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", string2, string));
    }

    public ClassFileReader getClassfile(String string, String string2, Predicate<String> predicate) throws IOException, ClassFormatException {
        ClassFileReader classFileReader = null;
        if (string2 == null) {
            classFileReader = this.getClassfile(string, predicate);
        } else {
            byte[] byArray = this.getClassfileBytes(string, string2);
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string.toCharArray());
                classFileReader.moduleName = string2.toCharArray();
            }
        }
        return classFileReader;
    }

    public ClassFileReader getClassfile(String string, IModule iModule) throws IOException, ClassFormatException {
        ClassFileReader classFileReader = null;
        if (iModule == null) {
            classFileReader = this.getClassfile(string, (Predicate<String>)null);
        } else {
            byte[] byArray = this.getClassfileBytes(string, new String(iModule.name()));
            if (byArray != null) {
                classFileReader = new ClassFileReader(byArray, string.toCharArray());
            }
        }
        return classFileReader;
    }

    void walkModuleImage(final JRTUtil.JrtFileVisitor<Path> jrtFileVisitor, boolean bl, final int n) throws IOException {
        Iterable<Path> iterable = this.jrtSystem.getRootDirectories();
        for (Path path : iterable) {
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    for (final Path path2 : directoryStream) {
                        if (path2.toString().equals("/modules")) {
                            if (bl) continue;
                            Files.walkFileTree(path2, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                    int n2 = path.getNameCount();
                                    if (n2 == 2) {
                                        Path path22 = path.getName(1);
                                        if (JRTUtil.MODULE_TO_LOAD != null && JRTUtil.MODULE_TO_LOAD.length() > 0 && JRTUtil.MODULE_TO_LOAD.indexOf(path22.toString()) == -1) {
                                            return FileVisitResult.SKIP_SUBTREE;
                                        }
                                        return (n & JRTUtil.NOTIFY_MODULES) == 0 ? FileVisitResult.CONTINUE : jrtFileVisitor.visitModule(path22);
                                    }
                                    if (path == path2 || n2 < 3 || (n & JRTUtil.NOTIFY_PACKAGES) == 0) {
                                        return FileVisitResult.CONTINUE;
                                    }
                                    return jrtFileVisitor.visitPackage(path.subpath(2, n2), path.getName(1), basicFileAttributes);
                                }

                                @Override
                                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                    if ((n & JRTUtil.NOTIFY_FILES) == 0) {
                                        return FileVisitResult.CONTINUE;
                                    }
                                    int n2 = path.getNameCount();
                                    if (n2 == 3) {
                                        JrtFileSystem.this.cachePackage("", path.getName(1).toString());
                                    }
                                    return jrtFileVisitor.visitFile(path.subpath(2, path.getNameCount()), path.getName(1), basicFileAttributes);
                                }
                            });
                            continue;
                        }
                        if (!bl) continue;
                        Files.walkFileTree(path2, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                Path path22 = path2.relativize(path);
                                JrtFileSystem.this.cachePackage(path22.getParent().toString(), path22.getFileName().toString());
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                finally {
                    if (directoryStream == null) continue;
                    directoryStream.close();
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }

    void cachePackage(String string, String string2) {
        string = string.intern();
        string2 = string2.intern();
        String string3 = this.packageToModule.get(string = string.replace('.', '/'));
        if (string3 == null) {
            this.packageToModule.put(string, string2);
        } else {
            if (string3 == string2 || string3.equals(string2)) {
                return;
            }
            if (string3 == "MU") {
                List<String> list = this.packageToModules.get(string);
                if (!list.contains(string2)) {
                    if ("java.base" == string2 || "java.base".equals(string2)) {
                        list.add(0, "java.base");
                    } else {
                        list.add(string2);
                    }
                }
            } else {
                String string4 = string3;
                this.packageToModule.put(string, "MU");
                ArrayList<String> arrayList = new ArrayList<String>();
                if ("java.base" == string3 || "java.base".equals(string3)) {
                    arrayList.add(string4);
                    arrayList.add(string2);
                } else {
                    arrayList.add(string2);
                    arrayList.add(string4);
                }
                this.packageToModules.put(string, arrayList);
            }
        }
    }
}

